/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.command;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandExcutor;
import com.huawei.ism.util.CommonUtil;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand
implements Command {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCommand.class);
    private static int count;
    private CommandExcutor.CommandState commandState = CommandExcutor.CommandState.WAIT_EXECUTE;
    private String result = "--";
    private Object resultObj = null;
    private Set<Command> orderCustomSet;
    private Object wanted = null;
    private int index;

    public AbstractCommand() {
        AbstractCommand.countIncreatment();
        this.index = count;
    }

    private static void countIncreatment() {
        ++count;
    }

    protected void setCommandState(CommandExcutor.CommandState commandState) {
        this.commandState = commandState;
    }

    @Override
    public final CommandExcutor.CommandState getCommandState() {
        return this.commandState;
    }

    protected void afterExecuteTask() throws IsmException {
        this.commandState = CommandExcutor.CommandState.SYN_CMD_FINISHED;
    }

    protected void afterExecuteTaskSuccess() {
        this.commandState = CommandExcutor.CommandState.SYN_CMD_FINISHED;
        this.payOutWanted();
    }

    protected void doSomeTask() {
    }

    @Override
    public boolean execute() {
        boolean excuteResult = false;
        try {
            this.commandState = CommandExcutor.CommandState.EXECUTING;
            this.executeTask();
            this.afterExecuteTaskSuccess();
            excuteResult = true;
        }
        catch (IsmException e) {
            LOGGER.error("AbstractCommand execute error:", (Throwable)e);
            this.result = CommonUtil.change2ErrMsg(e);
            this.commandState = CommandExcutor.CommandState.FAILED;
            if (e.getErrorId() == 50331670L) {
                this.result = "--";
                this.commandState = CommandExcutor.CommandState.ASYNC_CMD_COMPLETED;
            }
            excuteResult = false;
        }
        catch (Throwable e) {
            LOGGER.error("AbstractCommand execute error:", e);
            this.result = CommonUtil.change2ErrMsg(e);
            this.commandState = CommandExcutor.CommandState.FAILED;
            excuteResult = false;
        }
        try {
            this.doSomeTask();
        }
        catch (Throwable e) {
            LOGGER.error("AbstractCommand doSomeTask error:", e);
        }
        return excuteResult;
    }

    @Override
    public final String getResult() {
        return this.result;
    }

    protected final void saveResultObj(Object resultObject) {
        this.resultObj = resultObject;
    }

    @Override
    public final Object getResultObj() {
        return this.resultObj;
    }

    public int getIndex() {
        return this.index;
    }

    public final boolean equals(Object obj) {
        if (null == obj || !(obj instanceof AbstractCommand)) {
            return false;
        }
        AbstractCommand command = (AbstractCommand)obj;
        return command.getIndex() == this.index;
    }

    public final int hashCode() {
        return this.index;
    }

    @Override
    public void addCustomCommand(Command command) {
        if (this.orderCustomSet == null) {
            this.orderCustomSet = new HashSet<Command>();
        }
        this.orderCustomSet.add(command);
    }

    public final void setResult(String result) {
        this.result = result;
    }

    @Override
    public void setWanted(Object wanted) {
        this.wanted = wanted;
    }

    @Override
    public void payOutWanted() {
        if (this.orderCustomSet == null) {
            return;
        }
        for (Command c : this.orderCustomSet) {
            c.setWanted(this.getWanted());
        }
    }

    @Override
    public Object getWanted() {
        return this.wanted;
    }

    protected abstract void executeTask() throws IsmException;
}

