/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.event.EventManagerPanel;
import com.huawei.ism.ui.module.event.EventTabLayout;
import com.huawei.ism.ui.module.event.FaultTabLayout;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.util.Pair;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

final class EventManagerLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int BOX_GAP = 12;
    private static final String ALARM_LEVEL = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_LEVEL");
    private static final String ALARM_SOURCE = ResourceManager.getString("ALARM_TABLE_MODEL_SOURCE");
    private static final String ALARM_DESC = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_DESC");
    private static final String ALARM_START_TIME = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_START_TIME");
    private static final String ALARM_RECONVER_TIME = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_RECOVER_TIME");
    private static final String ALARM_ID = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_ID");
    private static final String ALARM_SN = ResourceManager.getString("ALARM_TABLE_MODEL_ALARM_NO");
    private static final String ALARM_DETAIL = ResourceManager.getString("COMMON.TXT.DETAIL");
    private static final Icon ICON_EVENT_CRITICAL = ResourceManager.getImage("critical.png");
    private static final Icon ICON_EVENT_MAJOR = ResourceManager.getImage("major.png");
    private static final Icon ICON_EVENT_WARNING = ResourceManager.getImage("warning.png");
    private static final Icon ICON_EVENT_INFO = ResourceManager.getImage("info.png");
    private static final String FAULT_TAB_TITLE = ResourceManager.getString("ALARM_DIALOG_CURRENT_ALARM");
    private static final String EVENT_TAB_TITLE = ResourceManager.getString("ALARM_DIALOG_HISTORY_ALARM");
    private static final String[] EVENT_COLUMN_NAME = new String[]{ALARM_LEVEL, ALARM_SOURCE, ALARM_ID, ALARM_DESC, ALARM_START_TIME, ALARM_RECONVER_TIME, ALARM_SN, ALARM_DETAIL};
    private static final String[] FAULT_COLUMN_NAME = new String[]{ALARM_LEVEL, ALARM_SOURCE, ALARM_ID, ALARM_DESC, ALARM_START_TIME, ALARM_SN, ALARM_DETAIL};
    private JPanel basePanel;
    private FaultTabLayout faultLayout = null;
    private EventTabLayout eventLayout = null;
    private DefaultTableModel faultTableModel;
    private DefaultTableModel eventTableModel;
    private IsmTable faultTable;
    private IsmTable eventTable;
    private JTabbedPane eventTabbedPane = new JTabbedPane();

    public EventManagerLayout() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.init();
    }

    private void init() {
        this.initTable();
        this.eventLayout = new EventTabLayout(this.eventTable);
        this.faultLayout = new FaultTabLayout(this.faultTable);
        this.eventTabbedPane = new JTabbedPane();
        this.eventTabbedPane.add(FAULT_TAB_TITLE, this.faultLayout);
        this.eventTabbedPane.add(EVENT_TAB_TITLE, this.eventLayout);
        Box deviceBox = Box.createHorizontalBox();
        deviceBox.add(new JLabel(ResourceManager.getString("ALARM_CHOOSE_DEVICE")));
        deviceBox.add(Box.createHorizontalStrut(12));
        deviceBox.add(Box.createHorizontalGlue());
        this.basePanel = new JPanel(new BorderLayout());
        this.basePanel.add((Component)this.eventTabbedPane, "Center");
        EventLevelListCellRenderer render = new EventLevelListCellRenderer();
        this.eventLayout.getLevelComboBox().setRenderer(render);
        this.faultLayout.getLevelComboBox().setRenderer(render);
        this.add(this.basePanel);
    }

    private void initTable() {
        this.faultTableModel = new DefaultTableModel(FAULT_COLUMN_NAME, 0, 1, 2, 3, 4, 6);
        this.eventTableModel = new DefaultTableModel(EVENT_COLUMN_NAME, 0, 1, 2, 3, 4, 5, 7);
        this.faultTable = new IsmTable(this.faultTableModel);
        this.eventTable = new IsmTable(this.eventTableModel);
        TableColumnModel faultColumnModel = this.faultTable.getColumnModel();
        TableColumn columnLevel = faultColumnModel.getColumn(0);
        columnLevel.setPreferredWidth(60);
        faultColumnModel.getColumn(1).setPreferredWidth(80);
        faultColumnModel.getColumn(2).setPreferredWidth(80);
        faultColumnModel.getColumn(3).setPreferredWidth(260);
        faultColumnModel.getColumn(4).setPreferredWidth(200);
        faultColumnModel.getColumn(5).setPreferredWidth(85);
        TableColumnModel eventColumnModel = this.eventTable.getColumnModel();
        TableColumn faultLevelColumn = eventColumnModel.getColumn(0);
        faultLevelColumn.setPreferredWidth(60);
        eventColumnModel.getColumn(1).setPreferredWidth(85);
        eventColumnModel.getColumn(2).setPreferredWidth(80);
        eventColumnModel.getColumn(3).setPreferredWidth(250);
        eventColumnModel.getColumn(4).setPreferredWidth(180);
        eventColumnModel.getColumn(5).setPreferredWidth(180);
        eventColumnModel.getColumn(6).setPreferredWidth(85);
    }

    public FaultTabLayout getFaultLayout() {
        return this.faultLayout;
    }

    public void setFaultLayout(FaultTabLayout faultLayout) {
        this.faultLayout = faultLayout;
    }

    public EventTabLayout getEventLayout() {
        return this.eventLayout;
    }

    public void setEventLayout(EventTabLayout eventLayout) {
        this.eventLayout = eventLayout;
    }

    public DefaultTableModel getFaultTableModel() {
        return this.faultTableModel;
    }

    public void setFaultTableModel(DefaultTableModel faultTableModel) {
        this.faultTableModel = faultTableModel;
    }

    public DefaultTableModel getEventTableModel() {
        return this.eventTableModel;
    }

    public void setEventTableModel(DefaultTableModel eventTableModel) {
        this.eventTableModel = eventTableModel;
    }

    public IsmTable getFaultTable() {
        return this.faultTable;
    }

    public void setFaultTable(IsmTable faultTable) {
        this.faultTable = faultTable;
    }

    public IsmTable getEventTable() {
        return this.eventTable;
    }

    public void setEventTable(IsmTable eventTable) {
        this.eventTable = eventTable;
    }

    public JTabbedPane getEventTabbedPane() {
        return this.eventTabbedPane;
    }

    public void setEventTabbedPane(JTabbedPane eventTabbedPane) {
        this.eventTabbedPane = eventTabbedPane;
    }

    public static String[] getEventColumnName() {
        return null == EVENT_COLUMN_NAME ? null : (String[])EVENT_COLUMN_NAME.clone();
    }

    public static String[] getFaultColumnName() {
        return (String[])FAULT_COLUMN_NAME.clone();
    }

    private static class EventLevelListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private EventLevelListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (component instanceof JLabel) {
                this.setLebelText(value, component);
            }
            return component;
        }

        private void setLebelText(Object value, Component component) {
            JLabel jLabel = (JLabel)component;
            if (value instanceof Pair) {
                Pair item = (Pair)value;
                if (item == EventManagerPanel.COMBOBOX_ITEM_ALL_LEVEL) {
                    jLabel.setText(item.toString());
                } else if (item.getValue() instanceof Event.Level) {
                    this.setLabelIcon(jLabel, item);
                }
            }
        }

        private void setLabelIcon(JLabel jLabel, Pair<?, ?> item) {
            Event.Level alarmLevel = (Event.Level)((Object)item.getValue());
            switch (alarmLevel) {
                case CRITICAL: {
                    jLabel.setIcon(ICON_EVENT_CRITICAL);
                    break;
                }
                case MAJOR: {
                    jLabel.setIcon(ICON_EVENT_MAJOR);
                    break;
                }
                case WARNING: {
                    jLabel.setIcon(ICON_EVENT_WARNING);
                    break;
                }
                case INFO: {
                    jLabel.setIcon(ICON_EVENT_INFO);
                    break;
                }
            }
            jLabel.setText(alarmLevel.toString());
        }
    }
}

