/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.border;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

public final class NoTitleBorder
extends AbstractBorder {
    private static final Color TOP_GRADIENT = new Color(15198441);
    private static final int GRADIENT_HEIGHT = 15;
    private static final long serialVersionUID = 1249854430128575680L;
    private static final int DEFAULT_INSET = 3;
    private int xAxis;
    private int yAxis;
    private int width;
    private int height;

    public NoTitleBorder() {
        this(3);
    }

    public NoTitleBorder(int padding) {
        this(padding, padding, padding, padding);
    }

    public NoTitleBorder(int xAxis, int yAxis, int width, int height) {
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.width = width;
        this.height = height;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int xx, int yy, int ww, int hh) {
        if (!(component instanceof JComponent)) {
            return;
        }
        GradientPaint gradientPaint = new GradientPaint(xx, yy, TOP_GRADIENT, xx, 15.0f, Color.WHITE, false);
        Graphics2D g2d = CommonUtil.convertObject(graphics, Graphics2D.class);
        g2d.setPaint(gradientPaint);
        g2d.fillRect(xx + 2, yy + 3, ww - 4, 15);
        Color innerColor = UIManager.getColor("Control.borderColor");
        graphics.setColor(innerColor);
        graphics.drawRoundRect(xx + 1, yy + 1, ww - 3, hh - 3, 5, 5);
        Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 15);
        graphics.setColor(outterColor);
        graphics.drawRoundRect(xx, yy, ww - 1, hh - 1, 5, 5);
        graphics.setColor(Color.WHITE);
        graphics.drawLine(xx + 4, yy + 2, ww - 8, 2);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(this.xAxis, this.yAxis, this.width, this.height);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets borderInsets = this.getBorderInsets(component);
        insets.top = borderInsets.top;
        insets.left = borderInsets.left;
        insets.bottom = borderInsets.bottom;
        insets.right = borderInsets.right;
        return insets;
    }
}

