/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.border;

import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.FontUIResource;

public final class TitleBorder
extends AbstractBorder {
    private static final long serialVersionUID = -6353964178289670200L;
    private static final Insets TEXT_INSETS = new Insets(39, 12, 17, 12);
    private static final Insets TABLE_INSETS = new Insets(34, 7, 7, 7);
    private static final Insets TITLE_INSETS = new Insets(18, 20, 0, 10);
    private static final Color TOP_GRADIENT = new Color(15198441);
    private static final int GRADIENT_HEIGHT = 15;
    private String title = null;
    private Style style = Style.TEXT;

    public TitleBorder(String title, Style style) {
        if (null == title || title.isEmpty()) {
            throw new IllegalArgumentException("The title cannot be empty");
        }
        this.title = title;
        this.style = style;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
        if (!(component instanceof JComponent)) {
            return;
        }
        JComponent jc = (JComponent)component;
        GradientPaint gradientPaint = new GradientPaint(xx, yy, TOP_GRADIENT, xx, 15.0f, Color.WHITE, false);
        Graphics2D g2d = CommonUtil.convertObject(graphics, Graphics2D.class);
        g2d.setPaint(gradientPaint);
        g2d.fillRect(xx + 2, yy + 3, width - 4, 15);
        FontUIResource font = IsmFontFactory.getBold12Font();
        FontMetrics fontMetrics = component.getFontMetrics(font);
        int length = fontMetrics.stringWidth(this.title);
        int titleBGLength = length + TitleBorder.TITLE_INSETS.left + TitleBorder.TITLE_INSETS.right;
        ImageIcon centerIcon = (ImageIcon)UIManager.getIcon("TitleBorder.centerBG");
        ImageIcon leftIcon = (ImageIcon)UIManager.getIcon("TitleBorder.leftBG");
        ImageIcon rightIcon = (ImageIcon)UIManager.getIcon("TitleBorder.rightBG");
        int bgStartX = xx + 2;
        int bgStartY = yy + 3;
        this.fillTexture(g2d, leftIcon, bgStartX, bgStartY, leftIcon.getIconWidth(), leftIcon.getIconHeight());
        this.fillTexture(g2d, centerIcon, bgStartX + leftIcon.getIconWidth(), bgStartY, titleBGLength - leftIcon.getIconWidth() - rightIcon.getIconWidth(), centerIcon.getIconHeight());
        this.fillTexture(g2d, rightIcon, titleBGLength - rightIcon.getIconWidth() + bgStartX, bgStartY, rightIcon.getIconWidth(), rightIcon.getIconHeight());
        graphics.setFont(font);
        graphics.setColor(UIManager.getColor("BoldFont.color"));
        if (!component.isEnabled()) {
            graphics.setColor(component.getBackground().darker());
        }
        SwingUIUtil.drawString(jc, graphics, this.title, bgStartX + TitleBorder.TEXT_INSETS.left, bgStartY + TitleBorder.TITLE_INSETS.top);
        Color innerColor = UIManager.getColor("Control.borderColor");
        graphics.setColor(innerColor);
        graphics.drawRoundRect(xx + 1, yy + 1, width - 3, height - 3, 5, 5);
        Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 15);
        graphics.setColor(outterColor);
        graphics.drawRoundRect(xx, yy, width - 1, height - 1, 5, 5);
        graphics.setColor(Color.WHITE);
        graphics.drawLine(xx + 4, yy + 2, width - 8, 2);
    }

    private void fillTexture(Graphics2D g2, ImageIcon imgIcon, int xx, int yy, int ww, int hh) {
        BufferedImage bufferedImage = new BufferedImage(imgIcon.getIconWidth(), imgIcon.getIconHeight(), 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.drawImage(imgIcon.getImage(), 0, 0, null);
        graphics.dispose();
        Rectangle anchor = new Rectangle(xx, yy, imgIcon.getIconWidth(), imgIcon.getIconHeight());
        TexturePaint imgPaint = new TexturePaint(bufferedImage, anchor);
        g2.setPaint(imgPaint);
        g2.fillRect(xx, yy, ww, hh);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (this.style == Style.TEXT) {
            return TEXT_INSETS;
        }
        return TABLE_INSETS;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets borderInsets = this.getBorderInsets(component);
        insets.top = borderInsets.top;
        insets.left = borderInsets.left;
        insets.bottom = borderInsets.bottom;
        insets.right = borderInsets.right;
        return insets;
    }

    public static enum Style {
        TEXT,
        TABLE;

    }
}

