/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendar;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.layout.DefaultLayoutRow;
import com.huawei.ism.ui.layout.KeyValueLayoutRow;
import com.huawei.ism.ui.layout.LayoutGroup;
import com.huawei.ism.ui.layout.LayoutUtils;
import com.huawei.ism.ui.swing.calendar.DateGrid;
import com.huawei.ism.ui.swing.calendar.DateSpinnerEditor;
import com.huawei.ism.ui.swing.calendar.TimeClock;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.Timer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeSelector
extends IsmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTimeSelector.class);
    public static final int CONFIRM_VALUE = 1;
    public static final int CANCEL_VALUE = 0;
    private static final int MAX_YEAR = 2035;
    private static final int MIN_YEAR = 1970;
    private static final int YEAR_SPINNER_STEP = 1;
    private static final Dimension TIME_SPINNER_DIMENSION = new Dimension(120, 20);
    private static final long serialVersionUID = -519227869743198322L;
    private JComboBox region = new JComboBox();
    private JComboBox monthComboBox = new JComboBox();
    private JSpinner yearSpinner = new JSpinner();
    private DateGrid dateGrid = new DateGrid();
    private JSpinner timeSpinner = new DateSpinnerEditor();
    private boolean dateSelector;
    private boolean timeSelector;
    private boolean timeZoneSelector;
    private Calendar calendar = null;
    private transient Timer timer = null;
    private int returnVlaue = 0;

    public DateTimeSelector(Window parent, Timer timer) {
        super(parent);
        this.timer = timer;
    }

    public DateTimeSelector(Window parnet, boolean timeSelector, boolean timeZoneSelector, Calendar calendar) {
        super(parnet, ResourceManager.getString("SYSTEM_SET_TIME_TEXT"), IsmDialog.ECommonButton.Confirm, IsmDialog.ECommonButton.Cancel);
        this.dateSelector = true;
        this.timeSelector = timeSelector;
        this.timeZoneSelector = timeZoneSelector;
        this.calendar = (Calendar)calendar.clone();
        this.initDatePanel();
        this.initTimePanel();
        this.initTimeZonePanel();
        this.doUILayout();
        this.initEvent();
        this.pack();
        this.setModal(true);
        SwingUtil.putParentCenter(this, parnet);
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public int getChoise() {
        return this.returnVlaue;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (null != this.timer) {
            this.timer.cancel();
        }
    }

    @Override
    protected void doConfirmTask() {
        this.returnVlaue = 1;
        int day = this.dateGrid.getDay();
        this.calendar.set(5, day);
        this.dispose();
    }

    private void doUILayout() {
        DefaultLayoutRow row;
        ArrayList<LayoutGroup> groups = new ArrayList<LayoutGroup>(0);
        if (this.dateSelector) {
            LayoutGroup dateGroup = new LayoutGroup();
            row = new DefaultLayoutRow();
            row.addComponent(5, this.monthComboBox, this.yearSpinner);
            dateGroup.addLayoutRow(row);
            row = new DefaultLayoutRow();
            row.addComponent(5, this.dateGrid);
            dateGroup.addLayoutRow(row);
            dateGroup.setBorder(UCD.getCompoundBorder(UCD.createTitledBorder(ResourceManager.getString("DATE_TITLE")), UCD.createEmptyBorder(1)));
            Dimension dimension = new Dimension(250, 130);
            UCD.setJComponentSize(this.dateGrid, dimension);
            groups.add(dateGroup);
        }
        if (this.timeSelector) {
            LayoutGroup timeGroup = new LayoutGroup();
            timeGroup.setBorder(UCD.getCompoundTitleBorder(ResourceManager.getString("TIME_TITLE")));
            row = new DefaultLayoutRow();
            TimeClock timeClock = new TimeClock(this.timeSpinner, this.calendar.getTimeZone());
            UCD.setJComponentSize(timeClock, new Dimension(140, 140));
            row.addComponent(2, timeClock);
            timeGroup.addLayoutRow(row);
            row = new DefaultLayoutRow();
            row.addComponent(2, this.timeSpinner);
            timeGroup.addLayoutRow(row);
            groups.add(timeGroup);
        }
        JComponent component = LayoutUtils.doHorizontalLayout(groups);
        if (this.timeZoneSelector) {
            LayoutGroup group = new LayoutGroup();
            DefaultLayoutRow row2 = new DefaultLayoutRow();
            row2.addComponent(component);
            group.addLayoutRow(row2);
            KeyValueLayoutRow kvRow = new KeyValueLayoutRow();
            JLabel start = new JLabel(ResourceManager.getString("CURRENT_TIME_ZONE") + ":");
            kvRow.addKeyComponent(start);
            kvRow.addValueComponent(this.region);
            group.addLayoutRow(kvRow);
            component = LayoutUtils.doLayout(group);
            if (!this.timeSelector) {
                kvRow.setSize(250, 21);
            } else {
                kvRow.setSize(430, 21);
            }
        }
        this.getDialogContentPane().setBorder(UCD.createEmptyBorder());
        this.getDialogContentPane().setLayout(new BorderLayout());
        this.getDialogContentPane().add((Component)component, "Center");
    }

    private void initEvent() {
        this.monthComboBox.addItemListener(new MonthComboBoxHandler());
        this.region.addItemListener(new RegionItemHandler());
        this.yearSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSpinner spinner = (JSpinner)changeEvent.getSource();
                Object obj = spinner.getValue();
                DateTimeSelector.this.calendar.set(1, Integer.valueOf(obj.toString()));
                DateTimeSelector.this.dateGrid.set(DateTimeSelector.this.calendar.get(1), DateTimeSelector.this.calendar.get(2) + 1);
            }
        });
        this.timeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Date date = (Date)DateTimeSelector.this.timeSpinner.getValue();
                DateTimeSelector.this.calendar.set(11, date.getHours());
                DateTimeSelector.this.calendar.set(12, date.getMinutes());
                DateTimeSelector.this.calendar.set(13, date.getSeconds());
            }
        });
    }

    private void initDatePanel() {
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_JANUARY"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_FEBRUARY"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_MARCH"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_APRIL"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_MAY"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_JUNE"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_JULY"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_AUGUST"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_SEPERTEMBER"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_OCTOBER"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_NOVEMBER"));
        this.monthComboBox.addItem(ResourceManager.getString("MONTH_DECEMBER"));
        this.monthComboBox.setBackground(Color.white);
        this.monthComboBox.setSelectedIndex(this.calendar.get(2));
        this.yearSpinner = new JSpinner(new SpinnerNumberModel(2011, 1970, 2035, 1));
        this.yearSpinner.setValue(this.calendar.get(1));
        JSpinner.NumberEditor editor = new JSpinner.NumberEditor(this.yearSpinner, "0");
        JFormattedTextField textField = editor.getTextField();
        textField.setBackground(Color.white);
        textField.setHorizontalAlignment(2);
        textField.setEditable(false);
        this.yearSpinner.setEditor(editor);
        this.dateGrid.set(this.calendar.get(1), this.calendar.get(2) + 1);
        this.dateGrid.setDay(this.calendar.get(5));
    }

    private void initTimePanel() {
        this.timeSpinner.setMaximumSize(TIME_SPINNER_DIMENSION);
        this.timeSpinner.setMinimumSize(TIME_SPINNER_DIMENSION);
        this.timeSpinner.setPreferredSize(TIME_SPINNER_DIMENSION);
        Dimension dimension = new Dimension(120, 22);
        UCD.setJComponentSize(this.monthComboBox, dimension);
        UCD.setJComponentSize(this.yearSpinner, dimension);
        JSpinner.DateEditor dateEditor = (JSpinner.DateEditor)this.timeSpinner.getEditor();
        dateEditor.getFormat().setTimeZone(this.calendar.getTimeZone());
        this.timeSpinner.setValue(this.calendar.getTime());
    }

    private void initTimeZonePanel() {
        this.region = new JComboBox();
        List<Pair<String, String>> items = DateTimeSelector.getTimeZoneItmes();
        boolean timeZoneExsit = false;
        Pair<String, String> selectPair = null;
        String timeZoneKey = null;
        for (Pair<String, String> pair : items) {
            timeZoneKey = pair.getKey();
            if (null != this.calendar.getTimeZone() && timeZoneKey.equals(this.calendar.getTimeZone().getID())) {
                timeZoneExsit = true;
                selectPair = pair;
            }
            this.region.addItem(pair);
        }
        if (!timeZoneExsit) {
            Pair<String, String> notExsitTimezone;
            selectPair = notExsitTimezone = new Pair<String, String>(this.calendar.getTimeZone().getID(), DateTimeSelector.getShowTimeZoneValue(this.calendar.getTimeZone()));
            this.region.addItem(notExsitTimezone);
        }
        this.region.setSelectedItem(selectPair);
    }

    public static List<Pair<String, String>> getTimeZoneItmes() {
        String[] timezones = ResourceManager.getString("ALL_TIME_ZONE").split(";");
        ArrayList<Pair<String, String>> items = new ArrayList<Pair<String, String>>(0);
        String key = null;
        for (String timezone : timezones) {
            key = timezone.substring(timezone.indexOf("'") + 1);
            items.add(new Pair<String, String>(key, timezone.substring(0, timezone.indexOf("'"))));
        }
        return items;
    }

    public static String getShowTimeZoneValue(TimeZone timeZone) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("UTC");
            sb.append(DateTimeSelector.convertTimezoneOffset(timeZone));
        }
        catch (Exception e) {
            LOGGER.error("convert rawOffset error!");
        }
        sb.append('(');
        sb.append(timeZone.getID());
        sb.append(')');
        return sb.toString();
    }

    private static String convertTimezoneOffset(TimeZone timeZone) {
        StringBuffer returnStr1 = new StringBuffer();
        float rawOffsetF = timeZone.getRawOffset();
        BigDecimal bigDecimal = new BigDecimal((double)rawOffsetF / 3600000.0);
        float rawOffset = bigDecimal.setScale(2, 4).floatValue();
        int offsetMinit = (int)(Math.abs(rawOffset) * 60.0f);
        int minit = offsetMinit % 60;
        int hour = offsetMinit / 60;
        if (0.0f > rawOffset) {
            returnStr1.append('-');
        } else {
            returnStr1.append('+');
        }
        if (hour < 10) {
            returnStr1.append('0');
        }
        returnStr1.append(hour);
        returnStr1.append(':');
        if (minit < 10) {
            returnStr1.append('0');
        }
        returnStr1.append(minit);
        return returnStr1.toString();
    }

    private final class MonthComboBoxHandler
    implements ItemListener {
        private MonthComboBoxHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getID() == 701 && itemEvent.getStateChange() == 1) {
                JComboBox box = (JComboBox)itemEvent.getSource();
                int mouth = box.getSelectedIndex();
                DateTimeSelector.this.calendar.set(2, mouth);
                DateTimeSelector.this.dateGrid.set(DateTimeSelector.this.calendar.get(1), mouth + 1);
            }
        }
    }

    private final class RegionItemHandler
    implements ItemListener {
        private RegionItemHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getID() == 701 && itemEvent.getStateChange() == 1) {
                JComboBox box = (JComboBox)itemEvent.getSource();
                Pair pair = (Pair)box.getSelectedItem();
                String timeZoneId = pair.getKey().toString();
                DateTimeSelector.this.calendar.setTimeZone(TimeZone.getTimeZone(timeZoneId));
            }
        }
    }
}

