/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.control;

import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class TitlePane
extends JPanel {
    private static final long serialVersionUID = 6189736772470957825L;
    private JLabel titleLabel;
    private Box titleLeftBox;
    private Type paneType;
    private JPanel titleContentPane;
    private JPanel titleRightPane;

    public TitlePane(Type type, String title) {
        this.paneType = type;
        this.doLayoutUI(title);
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
    }

    private void doLayoutUI(String title) {
        this.titleLabel = new JLabel(title);
        this.titleLabel.setFont(IsmFontFactory.getBold13Font());
        this.titleLabel.setIconTextGap(4);
        this.titleRightPane = new JPanel();
        this.titleRightPane.setOpaque(false);
        this.titleRightPane.setLayout(new BorderLayout());
        this.titleLeftBox = Box.createHorizontalBox();
        ImageIcon icon = (ImageIcon)this.paneType.getImageIcon();
        ImagePanel titleBar = new ImagePanel(icon, ImagePanel.ExtendOrient.HORIZONAL);
        titleBar.setLayout(new BoxLayout(titleBar, 0));
        titleBar.add(Box.createRigidArea(new Dimension(10, icon.getIconHeight())));
        titleBar.add(this.titleLeftBox);
        titleBar.add(UCD.buildHBoxLeft(this.titleLabel));
        titleBar.add(Box.createGlue());
        titleBar.add(UCD.buildHBoxRight(this.titleRightPane));
        titleBar.add(Box.createRigidArea(new Dimension(10, icon.getIconHeight())));
        this.titleContentPane = new JPanel();
        this.titleContentPane.setOpaque(false);
        this.titleContentPane.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)titleBar, "North");
        this.add((Component)this.titleContentPane, "Center");
    }

    public void addContentPane(Component contentPane) {
        this.titleContentPane.add(contentPane, "Center");
        if (null != this.paneType) {
            this.titleContentPane.setBorder(this.paneType.getBorder());
        }
    }

    public void appendRightCorner(Component component) {
        this.titleRightPane.add(component, "Center");
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public void appendLeftCorner(Component component) {
        this.titleLeftBox.add(component);
        this.titleLeftBox.add(Box.createHorizontalStrut(10));
    }

    public static enum Type {
        FIRST_TEXT_FLOOR(new EmptyBorder(8, 20, 8, 20), "FirstFloorPane.titleBackGroudImage"),
        FIRST_TABLE_FLOOR(new EmptyBorder(5, 5, 5, 5), "FirstFloorPane.titleBackGroudImage"),
        SECOND_TEXT_FLOOR(new EmptyBorder(8, 20, 8, 20), "SecondFloorPane.titleBackGroudImage"),
        SECOND_TABLE_FLOOR(new EmptyBorder(5, 5, 5, 5), "SecondFloorPane.titleBackGroudImage");

        private Border paneBorder = null;
        private String iconKey = null;

        private Type(Border border, String iconKey) {
            this.paneBorder = border;
            this.iconKey = iconKey;
        }

        public Border getBorder() {
            return this.paneBorder;
        }

        public Icon getImageIcon() {
            return UIManager.getIcon(this.iconKey);
        }
    }
}

