/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.dialog.HeadlessDialog;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class ProgressDialog
extends HeadlessDialog {
    private static final long serialVersionUID = 1L;
    private String custMizeMsg;
    private int custWidth = 220;

    public ProgressDialog(Window parent) {
        this(parent, null, 220);
    }

    public ProgressDialog(Window parent, JProgressBar progressBar) {
        this(parent, null, 220, progressBar);
    }

    public ProgressDialog(Window parent, String custMizeMsg, int custWidth) {
        super(parent);
        this.custMizeMsg = custMizeMsg;
        this.custWidth = custWidth;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_ProgressDialog");
        this.layoutUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.toFront();
        this.setFocusableWindowState(true);
    }

    public ProgressDialog(Window parent, String custMizeMsg, int custWidth, JProgressBar progressBar) {
        super(parent);
        this.custMizeMsg = custMizeMsg;
        this.custWidth = custWidth;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_ProgressDialog");
        this.layoutUI(progressBar);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.toFront();
        this.setFocusableWindowState(true);
    }

    public ProgressDialog(Window parent, String custMizeMsg) {
        super(parent);
        this.custMizeMsg = custMizeMsg;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_ProgressDialog");
        this.layoutUI();
        this.pack();
        this.setLocationRelativeTo(parent);
        this.toFront();
        this.setFocusableWindowState(true);
    }

    public String getCustMizeMsg() {
        return this.custMizeMsg;
    }

    public void setCustMizeMsg(String custMizeMsg) {
        this.custMizeMsg = custMizeMsg;
    }

    public int getCustWidth() {
        return this.custWidth;
    }

    public void setCustWidth(int custWidth) {
        this.custWidth = custWidth;
    }

    private void layoutUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JComponent iconLabel = null;
        if (!IsmPlafUtils.isBlueStyle()) {
            iconLabel = this.createArmorContentPane();
            iconLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        } else {
            Border border = BorderFactory.createRaisedBevelBorder();
            panel.setBorder(border);
            iconLabel = this.createIconPanel("progress.gif");
        }
        panel.add((Component)iconLabel, "North");
        JButton jButton = new JButton("");
        jButton.setSize(0, 0);
        jButton.setPreferredSize(new Dimension(0, 0));
        panel.add((Component)jButton, "South");
        this.add(panel);
    }

    public JLabel createIconPanel(String imgName) {
        ImageIcon process = ResourceManager.getImage(imgName);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(process);
        process.setImageObserver(iconLabel);
        iconLabel.setFont(IsmFontFactory.getPlaint13Font());
        iconLabel.setForeground(Color.WHITE);
        iconLabel.setText(this.getLoadingMsg());
        return iconLabel;
    }

    private JComponent createArmorContentPane() {
        ImagePanel leftImagePanel = new ImagePanel(ResourceManager.getImage("loading-left.png"));
        ImagePanel rightImagePanel = new ImagePanel(ResourceManager.getImage("loading-right.png"));
        ImagePanel middleImagePanel = this.initMiddleImg();
        leftImagePanel.setPreferredSize(new Dimension(20, 122));
        middleImagePanel.setPreferredSize(new Dimension(this.custWidth, 122));
        rightImagePanel.setPreferredSize(new Dimension(20, 122));
        leftImagePanel.setOpaque(false);
        middleImagePanel.setOpaque(false);
        rightImagePanel.setOpaque(false);
        middleImagePanel.setLayout(new BorderLayout());
        JLabel lable = this.createIconPanel("task_loading.gif");
        Box lableBox = Box.createHorizontalBox();
        lableBox.add(Box.createHorizontalGlue());
        lableBox.add(lable);
        lableBox.add(Box.createHorizontalGlue());
        middleImagePanel.add(lableBox);
        Box box = Box.createHorizontalBox();
        box.add(leftImagePanel);
        box.add(middleImagePanel);
        box.add(rightImagePanel);
        return box;
    }

    public ImagePanel initMiddleImg() {
        ImagePanel middleImagePanel = new ImagePanel(ResourceManager.getImage("loading-middle.png"), ImagePanel.ExtendOrient.HORIZONAL);
        return middleImagePanel;
    }

    protected String getLoadingMsg() {
        return this.custMizeMsg == null ? ResourceManager.getString("LOADING_TEXT") : this.custMizeMsg;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private JComponent createArmorContentPane(JProgressBar progressBar) {
        ImagePanel leftImagePanel = new ImagePanel(ResourceManager.getImage("loading-left.png"));
        ImagePanel rightImagePanel = new ImagePanel(ResourceManager.getImage("loading-right.png"));
        ImagePanel middleImagePanel = this.initMiddleImg();
        leftImagePanel.setPreferredSize(new Dimension(20, 122));
        middleImagePanel.setPreferredSize(new Dimension(this.custWidth, 122));
        rightImagePanel.setPreferredSize(new Dimension(20, 122));
        leftImagePanel.setOpaque(false);
        middleImagePanel.setOpaque(false);
        rightImagePanel.setOpaque(false);
        middleImagePanel.setLayout(new BorderLayout());
        JLabel lable = this.createIconPanel();
        Box lableBox = Box.createHorizontalBox();
        lableBox.add(Box.createHorizontalGlue());
        Box createVerticalBox = Box.createVerticalBox();
        createVerticalBox.add(Box.createVerticalGlue());
        createVerticalBox.add(lable);
        createVerticalBox.add(UCD.buildHorizotalBox(null, 0, Box.createHorizontalStrut(12), progressBar, Box.createHorizontalStrut(12)));
        createVerticalBox.add(Box.createVerticalGlue());
        lableBox.add(createVerticalBox);
        lableBox.add(Box.createHorizontalGlue());
        middleImagePanel.add(lableBox);
        Box box = Box.createHorizontalBox();
        box.add(leftImagePanel);
        box.add(middleImagePanel);
        box.add(rightImagePanel);
        return box;
    }

    private void layoutUI(JProgressBar progressBar) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JComponent iconLabel = null;
        if (!IsmPlafUtils.isBlueStyle()) {
            iconLabel = this.createArmorContentPane(progressBar);
            iconLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        } else {
            Border border = BorderFactory.createRaisedBevelBorder();
            panel.setBorder(border);
            iconLabel = this.createIconPanel("progress.gif");
        }
        panel.add((Component)iconLabel, "North");
        JButton jButton = new JButton("");
        jButton.setSize(0, 0);
        jButton.setPreferredSize(new Dimension(0, 0));
        panel.add((Component)jButton, "South");
        this.add(panel);
    }

    private JLabel createIconPanel() {
        JLabel iconLabel = new JLabel();
        iconLabel.setFont(IsmFontFactory.getPlaint13Font());
        iconLabel.setForeground(Color.WHITE);
        iconLabel.setText(this.getLoadingMsg());
        return iconLabel;
    }
}

