/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.TernaryCheckBox;
import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public final class IsmIconFactory {
    private static final Dimension MENU_CHECK_ICON_SIZE = new Dimension(0, 10);
    private static Icon radioButtonIcon;
    private static Icon checkBoxIcon;
    private static Icon sliderHorizIcon;
    private static Icon sliderVertIcon;
    private static Icon treeCollapsedIcon;
    private static Icon comboBoxIcon;
    private static Icon spinnerNextIcon;
    private static Icon spinnerPreviousIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon scrollBarUpArrowIcon;
    private static Icon scrollBarLeftArrowIcon;
    private static Icon scrollBarDownArrowIcon;
    private static Icon scrollBarRightArrowIcon;
    private static Icon menuArrowIcon;

    public static Icon getScrollBarUpArrowIcon() {
        if (scrollBarUpArrowIcon == null) {
            scrollBarUpArrowIcon = new ScrollBarArrowIcon(ScrollBarArrowIcon.Direction.UP);
        }
        return scrollBarUpArrowIcon;
    }

    public static Icon getScrollBarLeftArrowIcon() {
        if (scrollBarLeftArrowIcon == null) {
            scrollBarLeftArrowIcon = new ScrollBarArrowIcon(ScrollBarArrowIcon.Direction.LEFT);
        }
        return scrollBarLeftArrowIcon;
    }

    public static Icon getScrollBarDownArrowIcon() {
        if (scrollBarDownArrowIcon == null) {
            scrollBarDownArrowIcon = new ScrollBarArrowIcon(ScrollBarArrowIcon.Direction.DOWN);
        }
        return scrollBarDownArrowIcon;
    }

    public static Icon getScrollBarRightArrowIcon() {
        if (scrollBarRightArrowIcon == null) {
            scrollBarRightArrowIcon = new ScrollBarArrowIcon(ScrollBarArrowIcon.Direction.RIGHT);
        }
        return scrollBarRightArrowIcon;
    }

    public static Icon getMenuArrowIcon() {
        if (menuArrowIcon == null) {
            menuArrowIcon = new MenuArrowIcon();
        }
        return menuArrowIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new CheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getSpinnerNextIcon() {
        if (spinnerNextIcon == null) {
            spinnerNextIcon = new SpinnerNextIcon();
        }
        return spinnerNextIcon;
    }

    public static Icon getSpinnerPreviousIcon() {
        if (spinnerPreviousIcon == null) {
            spinnerPreviousIcon = new SpinnerPreviousIcon();
        }
        return spinnerPreviousIcon;
    }

    public static Icon getComboBoxIcon() {
        if (comboBoxIcon == null) {
            comboBoxIcon = new ComboBoxIcon();
        }
        return comboBoxIcon;
    }

    public static Icon getSliderVerticalIcon() {
        if (sliderVertIcon == null) {
            sliderVertIcon = new SliderVerticalIcon();
        }
        return sliderVertIcon;
    }

    public static Icon getSliderHorizontalIcon() {
        if (sliderHorizIcon == null) {
            sliderHorizIcon = new SliderHorizontalIcon();
        }
        return sliderHorizIcon;
    }

    public static Icon getTreeCollapsedIcon() {
        if (treeCollapsedIcon == null) {
            treeCollapsedIcon = new TreeCollapsedIcon();
        }
        return treeCollapsedIcon;
    }

    private static class CheckBoxIcon
    implements Icon,
    UIResource {
        private static final int ICON_H = 13;
        private static final int ICON_W = 13;

        private CheckBoxIcon() {
        }

        @Override
        public int getIconHeight() {
            return 13;
        }

        @Override
        public int getIconWidth() {
            return 13;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            if (component instanceof AbstractButton) {
                CheckBoxIcon.getCurrentIcon((AbstractButton)component).paintIcon(component, graphics, xx, yy);
            }
        }

        private static Icon getCurrentIcon(AbstractButton abstractButton) {
            boolean isRolloverEnabled;
            ButtonModel model = abstractButton.getModel();
            Icon icon = null;
            boolean bl = isRolloverEnabled = abstractButton.isRolloverEnabled() || UIManager.getBoolean("CheckBox.rollover");
            if (abstractButton instanceof TernaryCheckBox && null != (icon = CheckBoxIcon.getPartialIcon((TernaryCheckBox)abstractButton))) {
                return icon;
            }
            icon = !model.isEnabled() ? CheckBoxIcon.getDisabledIcon(abstractButton) : (model.isPressed() && model.isArmed() ? (model.isSelected() ? UIManager.getIcon("CheckBox.selectedPressedIcon") : UIManager.getIcon("CheckBox.unselectedPressedIcon")) : (model.isSelected() ? (isRolloverEnabled && model.isRollover() ? UIManager.getIcon("CheckBox.selectedRolloverIcon") : UIManager.getIcon("CheckBox.selectedEnabledIcon")) : (isRolloverEnabled && model.isRollover() ? UIManager.getIcon("CheckBox.unselectedRolloverIcon") : UIManager.getIcon("CheckBox.unselectedEnabledIcon"))));
            return icon;
        }

        private static Icon getDisabledIcon(AbstractButton abstractButton) {
            ButtonModel model = abstractButton.getModel();
            Icon icon = null;
            icon = model.isSelected() ? UIManager.getIcon("CheckBox.selectedDisabledIcon") : UIManager.getIcon("CheckBox.unselectedDisabledIcon");
            return icon;
        }

        private static Icon getPartialIcon(TernaryCheckBox ternaryCheckBox) {
            Icon icon = null;
            boolean isRolloverEnabled = ternaryCheckBox.isRolloverEnabled() || UIManager.getBoolean("CheckBox.rollover");
            ButtonModel model = ternaryCheckBox.getModel();
            icon = ternaryCheckBox.isPartialSelected() ? (ternaryCheckBox.isEnabled() ? (model.isPressed() && model.isArmed() ? UIManager.getIcon("CheckBox.partialPressedIcon") : (isRolloverEnabled && model.isRollover() ? UIManager.getIcon("CheckBox.partialRolloverIcon") : UIManager.getIcon("CheckBox.partialEnabledIcon"))) : UIManager.getIcon("CheckBox.partialDisabledIcon")) : null;
            return icon;
        }
    }

    private static class RadioButtonIcon
    implements Icon,
    UIResource {
        private static final int ICON_H = 12;
        private static final int ICON_W = 12;

        private RadioButtonIcon() {
        }

        @Override
        public int getIconWidth() {
            return 12;
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public void paintIcon(Component jc, Graphics graphics, int xx, int yy) {
            if (jc instanceof AbstractButton) {
                RadioButtonIcon.getCurrentIcon((AbstractButton)jc).paintIcon(jc, graphics, xx, yy);
            }
        }

        private static Icon getCurrentIcon(AbstractButton btn) {
            boolean isRolloverEnabled;
            ButtonModel model = btn.getModel();
            Icon icon = null;
            boolean bl = isRolloverEnabled = btn.isRolloverEnabled() || UIManager.getBoolean("RadioButton.rollover");
            icon = !model.isEnabled() ? RadioButtonIcon.getDisabledIcon(btn) : (model.isPressed() && model.isArmed() ? (model.isSelected() ? UIManager.getIcon("RadioButton.selectedPressedIcon") : UIManager.getIcon("RadioButton.unselectedPressedIcon")) : (model.isSelected() ? (isRolloverEnabled && model.isRollover() ? UIManager.getIcon("RadioButton.selectedRolloverIcon") : UIManager.getIcon("RadioButton.selectedEnabledIcon")) : (isRolloverEnabled && model.isRollover() ? UIManager.getIcon("RadioButton.unselectedRolloverIcon") : UIManager.getIcon("RadioButton.unselectedEnabledIcon"))));
            return icon;
        }

        private static Icon getDisabledIcon(AbstractButton abstractButton) {
            ButtonModel model = abstractButton.getModel();
            Icon icon = null;
            icon = model.isSelected() ? UIManager.getIcon("RadioButton.selectedDisabledIcon") : UIManager.getIcon("RadioButton.unselectedDisabledIcon");
            return icon;
        }
    }

    private static class ScrollBarArrowIcon
    implements Icon,
    UIResource {
        private Direction direction;

        public ScrollBarArrowIcon(Direction dir) {
            this.direction = dir;
        }

        @Override
        public int getIconHeight() {
            Icon icon = ScrollBarArrowIcon.getImageIcon(this.direction, true);
            if (icon == null) {
                return 0;
            }
            return icon.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            Icon icon = ScrollBarArrowIcon.getImageIcon(this.direction, true);
            if (icon == null) {
                return 0;
            }
            return icon.getIconWidth();
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            Icon icon = ScrollBarArrowIcon.getImageIcon(this.direction, component.isEnabled());
            if (icon == null) {
                return;
            }
            icon.paintIcon(component, graphics, xx, yy);
        }

        private static Icon getImageIcon(Direction dir, boolean isEnabled) {
            String postfix = isEnabled ? "" : "Disabled";
            Icon icon = null;
            switch (dir) {
                case UP: {
                    icon = UIManager.getIcon("ScrollBar.northButtonIconImage" + postfix);
                    break;
                }
                case LEFT: {
                    icon = UIManager.getIcon("ScrollBar.westButtonIconImage" + postfix);
                    break;
                }
                case DOWN: {
                    icon = UIManager.getIcon("ScrollBar.southButtonIconImage" + postfix);
                    break;
                }
                case RIGHT: {
                    icon = UIManager.getIcon("ScrollBar.eastButtonIconImage" + postfix);
                    break;
                }
            }
            return icon;
        }

        public static enum Direction {
            UP,
            LEFT,
            DOWN,
            RIGHT;

        }
    }

    private static class MenuArrowIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final int ICON_W = 4;
        private static final int ICON_H = 8;

        private MenuArrowIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            Polygon polygon = new Polygon();
            polygon.addPoint(xx, yy);
            polygon.addPoint(xx + this.getIconWidth(), yy + this.getIconHeight() / 2);
            polygon.addPoint(xx, yy + this.getIconHeight());
            graphics.fillPolygon(polygon);
        }

        @Override
        public int getIconWidth() {
            return 4;
        }

        @Override
        public int getIconHeight() {
            return 8;
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1L;

        private CheckBoxMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            ButtonModel model = null;
            if (!(component instanceof JMenuItem)) {
                return;
            }
            model = ((JMenuItem)component).getModel();
            boolean isSelected = model.isSelected();
            boolean isEnabled = model.isEnabled();
            boolean isArmed = model.isArmed();
            graphics.translate(xx, yy);
            if (isSelected) {
                if (isEnabled) {
                    if (isArmed || component instanceof JMenu && isSelected) {
                        graphics.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        graphics.setColor(component.getForeground());
                    }
                } else {
                    graphics.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                Graphics2D g2d = CommonUtil.convertObject(graphics, Graphics2D.class);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.drawLine(2, 2, 2, 6);
                graphics.drawLine(3, 2, 3, 6);
                graphics.drawLine(4, 4, 8, 0);
                graphics.drawLine(4, 5, 9, 0);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            }
            graphics.translate(-xx, -yy);
        }

        @Override
        public int getIconWidth() {
            return MENU_CHECK_ICON_SIZE.width;
        }

        @Override
        public int getIconHeight() {
            return MENU_CHECK_ICON_SIZE.height;
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1L;

        private RadioButtonMenuItemIcon() {
        }

        @Override
        public void paintIcon(Component comp, Graphics grap, int xx, int yy) {
            ButtonModel btnModel = null;
            if (!(comp instanceof JMenuItem)) {
                return;
            }
            btnModel = ((JMenuItem)comp).getModel();
            boolean isSelected = btnModel.isSelected();
            boolean isEnabled = btnModel.isEnabled();
            boolean isArmed = btnModel.isArmed();
            grap.translate(xx, yy);
            if (isSelected) {
                if (isEnabled) {
                    if (isArmed || comp instanceof JMenu && btnModel.isSelected()) {
                        grap.setColor(MetalLookAndFeel.getMenuSelectedForeground());
                    } else {
                        grap.setColor(comp.getForeground());
                    }
                } else {
                    grap.setColor(MetalLookAndFeel.getMenuDisabledForeground());
                }
                Graphics2D g2d = CommonUtil.convertObject(grap, Graphics2D.class);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                grap.drawLine(3, 2, 5, 2);
                grap.drawLine(2, 3, 6, 3);
                grap.drawLine(2, 4, 6, 4);
                grap.drawLine(2, 5, 6, 5);
                grap.drawLine(3, 6, 5, 6);
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            }
            grap.translate(-xx, -yy);
        }

        @Override
        public int getIconWidth() {
            return MENU_CHECK_ICON_SIZE.width;
        }

        @Override
        public int getIconHeight() {
            return MENU_CHECK_ICON_SIZE.height;
        }
    }

    private static class SpinnerPreviousIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 8191199334213423414L;

        private SpinnerPreviousIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            if (component.isEnabled()) {
                UIManager.getIcon("Spinner.downImage").paintIcon(component, graphics, xx, yy);
            } else {
                UIManager.getIcon("Spinner.downImageDisable").paintIcon(component, graphics, xx, yy);
            }
        }

        @Override
        public int getIconWidth() {
            return UIManager.getIcon("Spinner.downImage").getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return UIManager.getIcon("Spinner.downImage").getIconHeight();
        }
    }

    private static class SpinnerNextIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 8191199334213423414L;

        private SpinnerNextIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            if (component.isEnabled()) {
                UIManager.getIcon("Spinner.upImage").paintIcon(component, graphics, xx, yy);
            } else {
                UIManager.getIcon("Spinner.upImageDisable").paintIcon(component, graphics, xx, yy);
            }
        }

        @Override
        public int getIconWidth() {
            return UIManager.getIcon("Spinner.upImage").getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return UIManager.getIcon("Spinner.upImage").getIconHeight();
        }
    }

    private static class TreeCollapsedIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 6191195335214123414L;
        private static final int ICON_W = 18;
        private static final int ICON_H = 18;

        private TreeCollapsedIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            graphics.translate(xx, yy);
            Graphics2D g2D = CommonUtil.convertObject(graphics, Graphics2D.class);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(MetalLookAndFeel.getFocusColor());
            g2D.fillOval(2, 2, 14, 14);
            g2D.setColor(MetalLookAndFeel.getBlack());
            g2D.drawLine(11, 11, 7, 7);
            g2D.drawLine(11, 11, 7, 11);
            g2D.drawLine(11, 11, 11, 7);
            Icon icono = UIManager.getIcon("Tree.PelotillaIcon");
            icono.paintIcon(component, graphics, 0, 0);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            graphics.translate(-xx, -yy);
        }

        @Override
        public int getIconWidth() {
            return 18;
        }

        @Override
        public int getIconHeight() {
            return 18;
        }
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1191199335214123414L;
        private static final int ICON_W = 7;
        private static final int ICON_H = 17;

        private SliderHorizontalIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("Slider.ThumbStyle");
            IsmButtonStyle.ButtonState state = IsmButtonStyle.ButtonState.NORMAL;
            if (!component.isEnabled()) {
                state = IsmButtonStyle.ButtonState.DISABLED;
            } else if (component.hasFocus()) {
                state = IsmButtonStyle.ButtonState.PRESSED;
            }
            IsmPlafUtils.drawDualGradient(component, graphics, style.getGradientUL(state), style.getGradientDR(state), new Rectangle(xx, yy, 7, 17), false);
            IsmPlafUtils.drawButtonBorder(style, state, graphics, new Rectangle(xx, yy, 7, 17), true);
        }

        @Override
        public int getIconWidth() {
            return 7;
        }

        @Override
        public int getIconHeight() {
            return 17;
        }
    }

    private static class SliderVerticalIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 3191199335214123414L;
        private static final int ICON_W = 17;
        private static final int ICON_H = 7;

        private SliderVerticalIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("Slider.ThumbStyle");
            IsmButtonStyle.ButtonState state = IsmButtonStyle.ButtonState.NORMAL;
            if (component.hasFocus()) {
                state = IsmButtonStyle.ButtonState.PRESSED;
            } else if (!component.isEnabled()) {
                state = IsmButtonStyle.ButtonState.DISABLED;
            }
            IsmPlafUtils.drawDualGradient(component, graphics, style.getGradientUL(state), style.getGradientDR(state), new Rectangle(xx, yy, 17, 7), true);
            IsmPlafUtils.drawButtonBorder(style, state, graphics, new Rectangle(xx, yy, 17, 7), true);
        }

        @Override
        public int getIconWidth() {
            return 17;
        }

        @Override
        public int getIconHeight() {
            return 7;
        }
    }

    private static class ComboBoxIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = -3071886619903027901L;

        private ComboBoxIcon() {
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            Icon icon = UIManager.getIcon("ComboBox.arrowImage");
            if (!component.isEnabled()) {
                icon = UIManager.getIcon("ComboBox.arrowImageDisable");
            }
            icon.paintIcon(component, graphics, xx + 1, yy + 1);
        }

        @Override
        public int getIconWidth() {
            return UIManager.getIcon("ComboBox.arrowImage").getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return UIManager.getIcon("ComboBox.arrowImage").getIconHeight();
        }
    }
}

