/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicMenuUI;

public class IsmMenuUI
extends BasicMenuUI {
    public static ComponentUI createUI(JComponent c) {
        return new IsmMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.menuItem.setRolloverEnabled(true);
    }

    @Override
    protected void paintBackground(Graphics graphics, JMenuItem menuItem, Color bgColor) {
        JMenu menu;
        ButtonModel model = menuItem.getModel();
        int menuW = menuItem.getWidth();
        int menuH = menuItem.getHeight();
        Insets margin = menuItem.getMargin();
        if (menuItem instanceof JMenu && (menu = (JMenu)menuItem).isTopLevelMenu()) {
            margin = UIManager.getInsets("IsmMenu.SelectedInsets");
        }
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected() || model.isRollover()) {
            IsmPlafUtils.fillSelectionBG(menuItem, graphics, margin.left, margin.top, menuW - margin.left - margin.right, menuH - margin.top - margin.bottom, true);
            IsmPlafUtils.fillSelectionCover(menuItem, graphics, margin.left, margin.top, menuW - margin.left - margin.right, menuH - margin.top - margin.bottom, true);
        }
    }

    @Override
    protected void paintText(Graphics graphics, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = IsmPlafUtils.getFontMetrics(menuItem, graphics);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            if (UIManager.get("Menu.disabledForeground") instanceof Color) {
                graphics.setColor(UIManager.getColor("Menu.disabledForeground"));
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, text, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + fm.getAscent());
            } else {
                graphics.setColor(menuItem.getBackground().brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, text, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + fm.getAscent());
                graphics.setColor(menuItem.getBackground().darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, text, mnemIndex, (int)textRect.getX() - 1, (int)textRect.getY() + fm.getAscent() - 1);
            }
        } else {
            if (model.isArmed() || menuItem instanceof JMenu && model.isSelected() || model.isRollover()) {
                graphics.setColor(this.selectionForeground);
            }
            BasicGraphicsUtils.drawStringUnderlineCharAt(graphics, text, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + fm.getAscent());
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new IsmMouseInputHandler();
    }

    protected class IsmMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected IsmMouseInputHandler() {
            super(IsmMenuUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            super.mouseEntered(evt);
            JMenu menu = (JMenu)evt.getSource();
            ButtonModel model = menu.getModel();
            if (menu.isRolloverEnabled()) {
                model.setRollover(true);
                IsmMenuUI.this.menuItem.repaint();
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            JMenu menu = (JMenu)evt.getSource();
            ButtonModel model = menu.getModel();
            if (menu.isRolloverEnabled()) {
                model.setRollover(false);
                IsmMenuUI.this.menuItem.repaint();
            }
        }
    }
}

