/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmIconFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;

public class IsmRadioButtonUI
extends MetalRadioButtonUI {
    private static final String PROPERTY_PREFIX = "RadioButton.";
    private static Rectangle prefViewRect = new Rectangle();
    private static Rectangle prefIconRect = new Rectangle();
    private static Rectangle prefTextRect = new Rectangle();
    private static Insets prefInsets = new Insets(0, 0, 0, 0);
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static final IsmRadioButtonUI RADIOBUTTONUI = new IsmRadioButtonUI();
    private Icon buttonIcon;
    private boolean defaultsInitialized = false;

    public static ComponentUI createUI(JComponent component) {
        return RADIOBUTTONUI;
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaultsInitialized) {
            this.buttonIcon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.defaultsInitialized = true;
        }
        abstractButton.setOpaque(false);
    }

    @Override
    public void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaultsInitialized = false;
    }

    @Override
    public Icon getDefaultIcon() {
        return this.buttonIcon;
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = CommonUtil.convertObject(jComponent, AbstractButton.class);
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fm = graphics.getFontMetrics();
        IsmRadioButtonUI.updateStaticSeize(abstractButton);
        this.initViewSize();
        String text = this.paintLooks(graphics, jComponent, abstractButton, fm);
        this.drawTheText(graphics, jComponent, abstractButton, fm, text);
    }

    private void initViewSize() {
        IsmRadioButtonUI.viewRect.width = IsmRadioButtonUI.size.width;
        IsmRadioButtonUI.viewRect.height = IsmRadioButtonUI.size.height;
        IsmRadioButtonUI.iconRect.height = 0;
        IsmRadioButtonUI.iconRect.width = 0;
        IsmRadioButtonUI.textRect.height = 0;
        IsmRadioButtonUI.textRect.width = 0;
        viewRect.setLocation(0, 0);
        iconRect.setLocation(0, 0);
        textRect.setLocation(0, 0);
    }

    private String paintLooks(Graphics graphics, JComponent jComponent, AbstractButton abstractButton, FontMetrics fm) {
        Icon altIcon = abstractButton.getIcon();
        if (!abstractButton.isEnabled()) {
            graphics.setColor(Color.LIGHT_GRAY);
        }
        String text = SwingUtilities.layoutCompoundLabel(jComponent, fm, abstractButton.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, IsmRadioButtonUI.size.width, IsmRadioButtonUI.size.height);
        }
        if (abstractButton.getIcon() != null) {
            altIcon = this.getCurrentUserDfinedIcon(abstractButton);
            if (null != altIcon) {
                altIcon.paintIcon(jComponent, graphics, (int)iconRect.getX(), (int)iconRect.getY());
            }
        } else {
            Icon icon = this.getCurrentIcon();
            if (null != icon) {
                icon.paintIcon(jComponent, graphics, (int)iconRect.getX(), (int)iconRect.getY());
            }
        }
        return text;
    }

    private void drawTheText(Graphics graphics, JComponent jComponent, AbstractButton abstractButton, FontMetrics fm, String text) {
        if (text != null) {
            View clientProperty = (View)jComponent.getClientProperty("html");
            if (clientProperty != null) {
                clientProperty.paint(graphics, textRect);
                if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && IsmRadioButtonUI.textRect.width > 0 && IsmRadioButtonUI.textRect.height > 0) {
                    this.paintFocus(graphics, textRect, size);
                }
            } else {
                int mnemIndex = abstractButton.getDisplayedMnemonicIndex();
                SwingUIUtil.drawStringUnderlineCharAt(jComponent, graphics, text, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + fm.getAscent());
                if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && IsmRadioButtonUI.textRect.width > 0 && IsmRadioButtonUI.textRect.height > 0) {
                    this.paintFocus(graphics, textRect, size);
                }
            }
        }
    }

    private static void updateStaticSeize(AbstractButton abstractButton) {
        size = abstractButton.getSize(size);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = CommonUtil.convertObject(jComponent, AbstractButton.class);
        String text = abstractButton.getText();
        Icon buttonIconTemp = abstractButton.getIcon();
        if (buttonIconTemp == null) {
            buttonIconTemp = this.getDefaultIcon();
        }
        Font font = abstractButton.getFont();
        FontMetrics fm = IsmPlafUtils.getFontMetrics(jComponent, null, font);
        prefViewRect.setLocation(0, 0);
        IsmRadioButtonUI.prefViewRect.width = Short.MAX_VALUE;
        IsmRadioButtonUI.prefViewRect.height = Short.MAX_VALUE;
        IsmRadioButtonUI.prefIconRect.height = 0;
        IsmRadioButtonUI.prefIconRect.width = 0;
        IsmRadioButtonUI.prefTextRect.height = 0;
        IsmRadioButtonUI.prefTextRect.width = 0;
        prefIconRect.setLocation(0, 0);
        prefTextRect.setLocation(0, 0);
        SwingUtilities.layoutCompoundLabel(jComponent, fm, text, buttonIconTemp, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, text == null ? 0 : abstractButton.getIconTextGap());
        IsmRadioButtonUI.prefTextRect.width += 2;
        int x1 = Math.min((int)prefIconRect.getX(), (int)prefTextRect.getX());
        int x2 = Math.max((int)prefIconRect.getX() + IsmRadioButtonUI.prefIconRect.width, (int)prefTextRect.getX() + IsmRadioButtonUI.prefTextRect.width);
        int y1 = Math.min((int)prefIconRect.getY(), (int)prefTextRect.getY());
        int y2 = Math.max((int)prefIconRect.getY() + IsmRadioButtonUI.prefIconRect.height, (int)prefTextRect.getY() + IsmRadioButtonUI.prefTextRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        return new Dimension(width += IsmRadioButtonUI.prefInsets.left + IsmRadioButtonUI.prefInsets.right, height += IsmRadioButtonUI.prefInsets.top + IsmRadioButtonUI.prefInsets.bottom);
    }

    protected Icon getCurrentIcon() {
        return IsmIconFactory.getRadioButtonIcon();
    }

    @Override
    protected String getPropertyPrefix() {
        return PROPERTY_PREFIX;
    }

    @Override
    protected void paintFocus(Graphics graphics, Rectangle textRectTemp, Dimension dimension) {
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, (int)textRectTemp.getX(), (int)textRectTemp.getY(), textRectTemp.width, textRectTemp.height);
    }

    private Icon getCurrentUserDfinedIcon(AbstractButton abstractButton) {
        ButtonModel model = abstractButton.getModel();
        Icon icon = abstractButton.getIcon();
        if (!model.isEnabled()) {
            icon = model.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
        } else if (model.isPressed() && model.isArmed()) {
            icon = abstractButton.getPressedIcon();
            if (icon == null) {
                icon = abstractButton.getSelectedIcon();
            }
        } else if (model.isSelected()) {
            if (abstractButton.isRolloverEnabled() && model.isRollover()) {
                icon = abstractButton.getRolloverSelectedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else {
                icon = abstractButton.getSelectedIcon();
            }
        } else if (abstractButton.isRolloverEnabled() && model.isRollover()) {
            icon = abstractButton.getRolloverIcon();
        }
        if (icon == null) {
            icon = abstractButton.getIcon();
        }
        return icon;
    }
}

