/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.IsmScrollButton;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class IsmScrollBarUI
extends MetalScrollBarUI {
    public static ComponentUI createUI(JComponent c) {
        return new IsmScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollbar.setBlockIncrement(40);
        this.scrollbar.setUnitIncrement(20);
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new IsmScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new IsmScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle thumbBounds) {
        int gapY;
        IsmButtonStyle style = (IsmButtonStyle)UIManager.get("ScrollBarThumb.style");
        IsmButtonStyle.ButtonState buttonState = IsmButtonStyle.ButtonState.NORMAL;
        boolean isHorizontal = this.scrollbar.getOrientation() == 0;
        int gapX = isHorizontal ? 1 : 0;
        int n = gapY = isHorizontal ? 0 : 1;
        if (!jComponent.isEnabled()) {
            buttonState = IsmButtonStyle.ButtonState.DISABLED;
        } else if (this.isDragging) {
            buttonState = IsmButtonStyle.ButtonState.PRESSED;
        } else if (this.isThumbRollover()) {
            buttonState = IsmButtonStyle.ButtonState.ROLLOVER;
        }
        IsmPlafUtils.drawDualGradient((Component)jComponent, graphics, style.getGradientUL(buttonState), style.getGradientDR(buttonState), new Rectangle((int)thumbBounds.getX() + gapX, (int)thumbBounds.getY() + gapY, thumbBounds.width - 2 * gapX, thumbBounds.height - 2 * gapY), isHorizontal);
        IsmPlafUtils.drawButtonBorder(style, buttonState, graphics, new Rectangle((int)thumbBounds.getX() + gapX, (int)thumbBounds.getY() + gapY, thumbBounds.width - 2 * gapX, thumbBounds.height - 2 * gapY), false);
        Icon icDecor = null;
        icDecor = this.scrollbar.getOrientation() == 0 ? UIManager.getIcon("ScrollBar.horizontalThumbDecorIcon") : UIManager.getIcon("ScrollBar.verticalThumbDecorIcon");
        int iconWidth = icDecor.getIconWidth();
        int iconHeight = icDecor.getIconHeight();
        int xx = (int)thumbBounds.getX() + (thumbBounds.width - iconWidth) / 2;
        int yyy = (int)thumbBounds.getY() + (thumbBounds.height - iconHeight) / 2;
        int decorGap = 10;
        if (isHorizontal && thumbBounds.width >= iconWidth + decorGap || !isHorizontal && thumbBounds.height >= iconHeight + decorGap) {
            icDecor.paintIcon(jComponent, graphics, xx, yyy);
        }
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle trackBounds) {
        IsmPlafUtils.drawGradient((Component)jComponent, graphics, "ScrollBar.trackGradient", new Rectangle((int)trackBounds.getX(), (int)trackBounds.getY(), trackBounds.width, trackBounds.height), this.scrollbar.getOrientation() == 0);
    }
}

