/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmIconFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class IsmSpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent c) {
        return new IsmSpinnerUI();
    }

    @Override
    protected Component createPreviousButton() {
        ArrowButton arrowButton = new ArrowButton(5);
        arrowButton.setName("ISMV1R2_framework_IsmSipnnerUI_up");
        this.installPreviousButtonListeners(arrowButton);
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            arrowButton.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            arrowButton.setBorder(buttonBorder);
        }
        return arrowButton;
    }

    @Override
    protected Component createNextButton() {
        ArrowButton arrowButton = new ArrowButton(1);
        arrowButton.setName("ISMV1R2_framework_IsmSipnnerUI_down");
        this.installNextButtonListeners(arrowButton);
        Border buttonBorder = UIManager.getBorder("Spinner.arrowButtonBorder");
        if (buttonBorder instanceof UIResource) {
            arrowButton.setBorder(new CompoundBorder(buttonBorder, null));
        } else {
            arrowButton.setBorder(buttonBorder);
        }
        return arrowButton;
    }

    private static class ArrowButton
    extends JButton {
        private static final long serialVersionUID = 1L;
        private int directio;

        public ArrowButton(int direction) {
            this.directio = direction;
            this.setName("ISMV1R2_framework_IsmSipnnerUI_ArrowButton" + this.directio);
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            Icon icon = IsmIconFactory.getSpinnerNextIcon();
            if (this.directio == 5) {
                icon = IsmIconFactory.getSpinnerPreviousIcon();
            }
            int iconW = icon.getIconWidth();
            int iconH = icon.getIconHeight();
            icon.paintIcon(this, graphics, (this.getWidth() - iconW) / 2, (this.getHeight() - iconH) / 2);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }
    }
}

