/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.metal.MetalToolTipUI;
import javax.swing.text.View;

public class IsmToolTipUI
extends MetalToolTipUI {
    private static IsmToolTipUI instance = new IsmToolTipUI();
    private static volatile PropertyChangeListener sharedPropertyChangedListener;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent c) {
        return instance;
    }

    @Override
    protected void installListeners(JComponent jComponent) {
        this.propertyChangeListener = this.createPropertyChangeListener();
        jComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        FontUIResource font = IsmFontFactory.getDialogPlain();
        FontMetrics metrics = IsmPlafUtils.getFontMetrics(jComponent, graphics, font);
        Dimension size = jComponent.getSize();
        if (jComponent.isOpaque()) {
            this.paintBackground(graphics, jComponent);
        }
        graphics.setColor(jComponent.getForeground());
        graphics.setFont(font);
        String tipText = null;
        if (jComponent instanceof JToolTip) {
            tipText = ((JToolTip)jComponent).getTipText();
        }
        if (tipText == null) {
            tipText = "";
        }
        Insets insets = jComponent.getInsets();
        Rectangle paintTextR = new Rectangle(insets.left, insets.top, size.width - (insets.left + insets.right), size.height - (insets.top + insets.bottom));
        View clientProperty = (View)jComponent.getClientProperty("html");
        if (clientProperty != null) {
            clientProperty.paint(graphics, paintTextR);
        } else {
            BasicGraphicsUtils.drawString(graphics, tipText, 0, (int)paintTextR.getX() + 3, (int)paintTextR.getY() + metrics.getAscent());
        }
    }

    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        Dimension size = jComponent.getSize();
        Color background = jComponent.getBackground();
        graphics.setColor(background);
        graphics.fillRect(0, 0, size.width, size.height);
    }

    private PropertyChangeListener createPropertyChangeListener() {
        if (sharedPropertyChangedListener == null) {
            sharedPropertyChangedListener = new PropertyChangeHandler();
        }
        return sharedPropertyChangedListener;
    }

    private void componentChanged(JComponent jComponent) {
        JComponent comp = ((JToolTip)jComponent).getComponent();
        if (comp != null && !comp.isEnabled()) {
            Border border = UIManager.getBorder("ToolTip.borderInactive");
            if (null != border) {
                jComponent.setBorder(border);
            } else {
                jComponent.setBorder(UIManager.getBorder("ToolTip.border"));
            }
            if (UIManager.getColor("ToolTip.backgroundInactive") != null) {
                jComponent.setBackground(UIManager.getColor("ToolTip.backgroundInactive"));
                jComponent.setForeground(UIManager.getColor("ToolTip.foregroundInactive"));
            } else {
                jComponent.setBackground(UIManager.getColor("ToolTip.background"));
                jComponent.setForeground(UIManager.getColor("ToolTip.foreground"));
            }
        } else {
            LookAndFeel.installBorder(jComponent, "ToolTip.border");
            LookAndFeel.installColors(jComponent, "ToolTip.background", "ToolTip.foreground");
        }
    }

    private static class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JToolTip tip;
            String name = evt.getPropertyName();
            if (name.equals("tiptext") || "font".equals(name) || "foreground".equals(name)) {
                JToolTip tip2 = (JToolTip)evt.getSource();
                if (null == tip2) {
                    return;
                }
                String text = tip2.getTipText();
                if (!BasicHTML.isHTMLString(text)) {
                    BasicHTML.updateRenderer(tip2, "<html>" + text);
                } else {
                    BasicHTML.updateRenderer(tip2, text);
                }
            } else if ("component".equals(name) && (tip = (JToolTip)evt.getSource()).getUI() instanceof IsmToolTipUI) {
                ((IsmToolTipUI)tip.getUI()).componentChanged(tip);
            }
        }
    }
}

