/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.control.IsmComboBoxButton;
import com.huawei.ism.ui.swing.plaf.IsmComboBoxUI;
import com.huawei.ism.ui.swing.plaf.IsmComboPopup;
import com.huawei.ism.ui.swing.plaf.armor.ArmorBorders;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.ComboPopup;

public class ArmorComboBoxUI
extends IsmComboBoxUI {
    private static final Dimension BUTTON_SIZE = new Dimension(17, 17);

    public static ComponentUI createUI(JComponent c) {
        return new ArmorComboBoxUI();
    }

    @Override
    protected ListCellRenderer createRenderer() {
        return new ArmorComboBoxRenderer();
    }

    @Override
    protected ComboPopup createPopup() {
        return new ArmorComboBoxPopup(this.comboBox);
    }

    @Override
    protected JButton createArrowButton() {
        IsmComboBoxButton button = new IsmComboBoxButton(this.comboBox, UIManager.getIcon("ComboBox.arrowIcon"), true, this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 0, 1, 2));
        button.setBorder(ArmorBorders.getArmorButtonBorder(false));
        button.setFocusPainted(this.comboBox.isEditable());
        button.setMaximumSize(BUTTON_SIZE);
        button.setPreferredSize(BUTTON_SIZE);
        button.setMinimumSize(BUTTON_SIZE);
        return button;
    }

    public static class ArmorComboBoxPopup
    extends IsmComboPopup {
        private static final long serialVersionUID = -9076176265936112033L;

        public ArmorComboBoxPopup(JComboBox combo) {
            super(combo);
        }

        @Override
        protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            GraphicsConfiguration gc = this.comboBox.getGraphicsConfiguration();
            Point point = new Point();
            SwingUtilities.convertPointFromScreen(point, this.comboBox);
            Rectangle screenBounds = new Rectangle(point, toolkit.getScreenSize());
            if (gc != null) {
                Insets screenInsets = toolkit.getScreenInsets(gc);
                screenBounds = gc.getBounds();
                screenBounds.width -= screenInsets.left + screenInsets.right;
                screenBounds.height -= screenInsets.top + screenInsets.bottom;
                screenBounds.setLocation((int)screenBounds.getX() + (int)point.getX() + screenInsets.left, (int)screenBounds.getY() + (int)point.getY() + screenInsets.top);
            }
            Rectangle rect = new Rectangle(px, py, pw, ph);
            if (py + ph > (int)screenBounds.getY() + screenBounds.height && ph < screenBounds.height) {
                rect.setLocation((int)rect.getX(), -rect.height - 8);
            }
            return rect;
        }
    }

    protected static class ArmorComboBoxRenderer
    extends BasicComboBoxRenderer.UIResource {
        private static final long serialVersionUID = 1L;
        private static final EmptyBorder CELL_BORDER = new EmptyBorder(0, 5, 0, 5);

        public ArmorComboBoxRenderer() {
            this.setBorder(CELL_BORDER);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            return new Dimension(preferredSize.width, 23);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component listCellRendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!(listCellRendererComponent instanceof JComponent)) {
                return listCellRendererComponent;
            }
            JComponent jc = (JComponent)listCellRendererComponent;
            if (index == -1) {
                jc.setForeground(list.getForeground());
            }
            if (null != value) {
                jc.setToolTipText(value.toString());
            }
            if (isSelected) {
                Dimension preferredSize = jc.getPreferredSize();
                preferredSize.height -= 3;
                jc.setPreferredSize(preferredSize);
                jc.setMaximumSize(preferredSize);
            }
            return listCellRendererComponent;
        }
    }
}

