/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.IsmList;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;

public class ArmorListUI
extends BasicListUI {
    private RolloverRowMonitor monitor = new RolloverRowMonitor();

    public static ComponentUI createUI(JComponent list) {
        return new ArmorListUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.list.addMouseMotionListener(this.monitor);
        this.list.addMouseListener(this.monitor);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.list.removeMouseMotionListener(this.monitor);
        this.list.removeMouseListener(this.monitor);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        if (!jComponent.isEnabled()) {
            Color old = graphics.getColor();
            jComponent.setBackground(UIManager.getColor("IsmList.diableBackgroud"));
            graphics.setColor(old);
        }
    }

    public int locationToRow(Point point) {
        int size = this.list.getModel().getSize();
        if (size <= 0) {
            return -1;
        }
        Insets insets = this.list.getInsets();
        if (this.cellHeights == null) {
            int row;
            int n = row = this.cellHeight == 0 ? -1 : (point.y - insets.top) / this.cellHeight;
            if (row < 0 || row >= size) {
                row = -1;
            }
            return row;
        }
        if (size > this.cellHeights.length) {
            return -1;
        }
        return this.locationRow(point);
    }

    private int locationRow(Point point) {
        int size = this.list.getModel().getSize();
        Insets insets = this.list.getInsets();
        int top = insets.top;
        int leftEdge = insets.left;
        int rightEdge = this.list.getWidth() + insets.right;
        int row = -1;
        if ((int)point.getY() < top || (int)point.getX() < leftEdge || (int)point.getX() > rightEdge) {
            return row;
        }
        for (int i = 0; i < size; ++i) {
            if ((int)point.getY() >= top && (int)point.getY() < top + this.cellHeights[i]) {
                row = i;
                break;
            }
            top += this.cellHeights[i];
        }
        return row;
    }

    private final class RolloverRowMonitor
    extends MouseAdapter {
        private RolloverRowMonitor() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.findRolloverRow(mouseEvent);
        }

        private void findRolloverRow(MouseEvent mouseEvent) {
            if (!(ArmorListUI.this.list instanceof IsmList)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int rolloverRow = ArmorListUI.this.locationToRow(point);
            IsmList ismList = (IsmList)ArmorListUI.this.list;
            ismList.setRolloverRow(rolloverRow);
            ArmorListUI.this.list.repaint();
            ArmorListUI.this.list.invalidate();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.findRolloverRow(mouseEvent);
        }
    }
}

