/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmMenuUI;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ArmorMenuUI
extends IsmMenuUI {
    private static final int MENU_ITEM_HEIGHT = 30;
    private static final int DEFAULT_TEXT_ICON_GAP = 8;

    public static ComponentUI createUI(JComponent c) {
        return new ArmorMenuUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.defaultTextIconGap = 8;
    }

    @Override
    protected void paintBackground(Graphics grap, JMenuItem menuItem, Color bgColor) {
        ButtonModel btnModel = menuItem.getModel();
        if (!btnModel.isEnabled() || !(menuItem instanceof JMenu)) {
            return;
        }
        int menuW = menuItem.getWidth();
        int menuH = menuItem.getHeight();
        JMenu menu = (JMenu)menuItem;
        Insets margin = this.getMenuItemMargin(menuItem, btnModel, menu);
        int left = margin.left;
        int top = margin.top;
        int ww = menuW - margin.left - margin.right;
        int hh = menuH - margin.top - margin.bottom;
        if (menu.isTopLevelMenu()) {
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("ArmorToolBarButton.style");
            Color borderColor = style.getBorderColor(IsmButtonStyle.ButtonState.NORMAL);
            if (btnModel.isRollover()) {
                IsmPlafUtils.drawBorderStyle(grap, borderColor, borderColor, new Rectangle(left, top, ww, hh), true);
                grap.setColor(UIManager.getColor("IsmTopMenu.rolloverBackground"));
                grap.fillRect(left + 1, top + 1, ww - 2, hh - 2);
            } else if (btnModel.isArmed() || btnModel.isSelected()) {
                grap.setColor(borderColor);
                grap.fillRect(left + 2, top, ww - 4, 1);
                grap.fillRect(left, top + 2, 1, hh - 1);
                grap.fillRect(left + ww - 1, top + 2, 1, hh - 1);
                grap.fillRect(left, top + 1, 2, 1);
                grap.fillRect(left + 1, top, 1, 2);
                grap.fillRect(left + ww - 2, top + 1, 2, 1);
                grap.fillRect(left + ww - 2, top, 1, 2);
                Graphics2D g2d = (Graphics2D)grap;
                g2d.setColor(IsmPlafUtils.mixAlpha(UIManager.getColor("MenuItem.background"), UIManager.getInt("PopupMenu.alpha")));
                g2d.fillRect(left + 2, top + 1, ww - 4, 1);
                g2d.fillRect(left + 1, top + 2, 1, hh - 1);
                g2d.fillRect(left + ww - 2, top + 2, 1, hh - 1);
                g2d.fillRect(left + 2, top + 2, ww - 4, hh - 1);
            }
        } else {
            grap.setColor(UIManager.getColor("MenuItem.background"));
            grap.fillRect(0, 0, menuW, menuH);
            if (btnModel.isArmed() || btnModel.isSelected() || btnModel.isPressed() || btnModel.isRollover()) {
                grap.setColor(UIManager.getColor("IsmTopMenu.selectedColor"));
                grap.fillRect(0, 0, menuW, menuH);
            }
        }
    }

    private Insets getMenuItemMargin(JMenuItem menuItem, ButtonModel btnModel, JMenu menu) {
        Insets margin = menuItem.getMargin();
        if (menu.isTopLevelMenu()) {
            if (btnModel.isRollover()) {
                margin = UIManager.getInsets("IsmTopMenu.rolloverInset");
            } else if (btnModel.isArmed() || btnModel.isSelected()) {
                margin = UIManager.getInsets("IsmMenu.SelectedInsets");
            }
        }
        return margin;
    }

    @Override
    protected void paintText(Graphics grap, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = IsmPlafUtils.getFontMetrics(menuItem, grap);
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!model.isEnabled()) {
            super.paintText(grap, menuItem, textRect, text);
            return;
        }
        if (menuItem instanceof JMenu && !((JMenu)menuItem).isTopLevelMenu()) {
            grap.setColor(UIManager.getColor("MenuItem.foreground"));
        }
        if (model.isArmed() || menuItem instanceof JMenu && model.isSelected() || model.isRollover()) {
            grap.setColor(this.selectionForeground);
        }
        if (menuItem instanceof JMenu && ((JMenu)menuItem).isTopLevelMenu() && menuItem.isSelected()) {
            grap.setColor(UIManager.getColor("MenuItem.foreground"));
        }
        SwingUIUtil.drawStringUnderlineCharAt(menuItem, grap, text, mnemIndex, (int)textRect.getX(), (int)textRect.getY() + fm.getAscent());
    }

    @Override
    protected Dimension getPreferredMenuItemSize(JComponent jComponent, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenu menu;
        Dimension dim = super.getPreferredMenuItemSize(jComponent, checkIcon, arrowIcon, defaultTextIconGap);
        if (jComponent instanceof JMenu && !(menu = (JMenu)jComponent).isTopLevelMenu()) {
            dim.height = 30;
        }
        return dim;
    }
}

