/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class ArmorToggleButtonUI
extends BasicToggleButtonUI {
    private static final ArmorToggleButtonUI INSTANCE = new ArmorToggleButtonUI();

    public static ComponentUI createUI(JComponent b) {
        return INSTANCE;
    }

    @Override
    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.FALSE);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (!(jComponent instanceof AbstractButton)) {
            super.update(graphics, jComponent);
            return;
        }
        AbstractButton button = (AbstractButton)jComponent;
        if (jComponent.getBackground() instanceof UIResource && button.isContentAreaFilled() && jComponent.isEnabled()) {
            ButtonModel model = button.getModel();
            if (!model.isPressed() && model.isRollover()) {
                this.paintButtonRollover(graphics, button);
                this.paint(graphics, jComponent);
                return;
            }
            if (!model.isArmed() && !model.isPressed()) {
                this.paintButtonNormal(graphics, button);
                this.paint(graphics, jComponent);
                return;
            }
        }
        if (!jComponent.isEnabled()) {
            this.paintDiabledButton(graphics, jComponent);
        }
        super.update(graphics, jComponent);
    }

    protected void paintDiabledButton(Graphics g, JComponent c) {
    }

    @Override
    protected void paintFocus(Graphics graphics, AbstractButton button, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (null == button.getText() || "".equals(button.getText()) || !(button.getParent() instanceof JToolBar)) {
            return;
        }
        Rectangle buttonRect = button.getBounds();
        Rectangle focusRect = new Rectangle();
        focusRect.width = buttonRect.width - 4;
        focusRect.height = buttonRect.height - 4;
        focusRect.setLocation(2, 2);
        graphics.setColor(UIManager.getColor("IsmTheme.selectionBGGradientBG"));
        BasicGraphicsUtils.drawDashedRect(graphics, (int)focusRect.getX(), (int)focusRect.getY(), focusRect.width, focusRect.height);
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        LookAndFeel.installProperty(abstractButton, "opaque", Boolean.TRUE);
    }

    @Override
    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        this.drawButtonContentArea(graphics, abstractButton, "IsmButton.pressHighlight", "IsmButton.gradientPress");
    }

    protected void paintButtonRollover(Graphics graphics, AbstractButton button) {
        this.drawButtonContentArea(graphics, button, "IsmButton.rolloverHighlight", "IsmButton.gradientRollover");
    }

    protected void paintButtonNormal(Graphics graphics, AbstractButton button2) {
        if (!(button2.getParent() instanceof JToolBar)) {
            if (!button2.hasFocus()) {
                this.drawButtonNormalContentArea(graphics, button2, "IsmButton.normalHighlight", "IsmButton.normalFillBackground");
            } else {
                this.drawButtonContentArea(graphics, button2, "IsmButton.normalHighlight", "IsmButton.gradientRollover");
            }
        }
    }

    protected void drawButtonNormalContentArea(Graphics graphics, AbstractButton button1, String hightlightKey, String normalKey) {
        if (null != hightlightKey) {
            graphics.setColor(UIManager.getColor(hightlightKey));
            graphics.fillRect(0, 1, button1.getWidth() - 1, 2);
            graphics.setColor(UIManager.getColor(normalKey));
            graphics.fillRect(0, 3, button1.getWidth() - 1, button1.getHeight() - 4);
        } else {
            graphics.setColor(UIManager.getColor(normalKey));
            graphics.fillRect(0, 1, button1.getWidth() - 1, button1.getHeight() - 1);
        }
    }

    protected void drawButtonContentArea(Graphics graphics, AbstractButton button, String highlightKey, String grientKey) {
        graphics.setColor(UIManager.getColor(highlightKey));
        graphics.fillRect(0, 1, button.getWidth() - 1, 2);
        IsmPlafUtils.drawGradient((Component)button, graphics, grientKey, new Rectangle(0, 3, button.getWidth(), button.getHeight() - 4), true);
    }
}

