/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.flat;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmRGBButtonStyle;
import com.huawei.ism.ui.swing.plaf.armor.ArmorTheme;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class FlatTheme
extends ArmorTheme {
    public static final int COLOR_AUI_BLUE = 0x3399FF;
    public static final int COLOR_BUTTON_BG_NORMAL = 0xFFFFFF;
    public static final int COLOR_BUTTON_BG_PRESSED = 0xEFF7FF;
    public static final int COLOR_BUTTON_BORDER_NORMAL = 0xB1B1B1;
    public static final int COLOR_BUTTON_BORDER_ROLLOVER = 6599167;
    public static final int COLOR_BUTTON_BORDER_PRESSED = 876746;
    public static final int COLOR_TEXT_DEFAULT = 0x333333;
    public static final int COLOR_TEXT_HIGHLIGHT = 0x3399FF;
    public static final FontUIResource FONT12_PLAIN = new FontUIResource("Dialog", 0, 12);
    public static final FontUIResource FONT13_BOLD = new FontUIResource("Dialog", 1, 13);
    public static final int FRAME_TITLE_BAR_HEIGHT = 29;
    public static final int DIALOG_TITLE_BAR_HEIGHT = 32;

    @Override
    public ColorUIResource getHWBaseColor() {
        return new ColorUIResource(0x3399FF);
    }

    @Override
    public void addCustomEntriesToTable(UIDefaults table) {
        super.addCustomEntriesToTable(table);
        this.initFlatButtonUI(table);
        this.initFlatTitleBarUI(table);
        this.initRadioButtonUI(table);
        this.initCheckBoxUI(table);
    }

    private void initFlatTitleBarUI(UIDefaults table) {
        table.put("TitleBar.close_normal", this.makeFlatIcon("titleBar_close_normal.png"));
        table.put("TitleBar.close_selected", this.makeFlatIcon("titleBar_close_selected.png"));
        table.put("TitleBar.close_rollover", this.makeFlatIcon("titleBar_close_rollover.png"));
        table.put("TitleBar.minimize_normal", this.makeFlatIcon("titleBar_minimize_normal.png"));
        table.put("TitleBar.minimize_selected", this.makeFlatIcon("titleBar_minimize_selected.png"));
        table.put("TitleBar.minimize_rollover", this.makeFlatIcon("titleBar_minimize_rollover.png"));
        table.put("TitleBar.maximize_normal", this.makeFlatIcon("titleBar_maximize_normal.png"));
        table.put("TitleBar.maximize_selected", this.makeFlatIcon("titleBar_maximize_selected.png"));
        table.put("TitleBar.maximize_rollover", this.makeFlatIcon("titleBar_maximize_rollover.png"));
        table.put("TitleBar.restore_normal", this.makeFlatIcon("titleBar_restore_normal.png"));
        table.put("TitleBar.restore_selected", this.makeFlatIcon("titleBar_restore_selected.png"));
        table.put("TitleBar.restore_rollover", this.makeFlatIcon("titleBar_restore_rollover.png"));
        table.put("TitleBar.leftBackground", this.makeFlatIcon("titleBar_left_background.png"));
        table.put("TitleBar.rightBackground", this.makeFlatIcon("titleBar_right_background.png"));
        table.put("TitleBar.dialogBorderColor", new ColorUIResource(0x202122));
        table.put("TitleBar.dialog_background", this.makeFlatIcon("titleBar_dialog_background.png"));
        table.put("TitleBar.dialog_close_normal", this.makeFlatIcon("titleBar_dialog_close_normal.png"));
        table.put("TitleBar.dialog_close_selected", this.makeFlatIcon("titleBar_dialog_close_selected.png"));
        table.put("TitleBar.dialog_close_rollover", this.makeFlatIcon("titleBar_dialog_close_rollover.png"));
        table.put("IsmFrame.TitleBarHeight", (Object)29);
        table.put("IsmDialog.TitleBarHeight", (Object)32);
    }

    private void initFlatButtonUI(UIDefaults table) {
        table.put("Button.rollover", Boolean.TRUE);
        table.put("IsmButton.normalFillBackground", new ColorUIResource(0xFFFFFF));
        table.put("IsmButton.normalHighlight", new ColorUIResource(0xFFFFFF));
        List<Serializable> rolloverGradient = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(0xFFFFFF), null, new ColorUIResource(0xFFFFFF));
        table.put("IsmButton.gradientRollover", rolloverGradient);
        table.put("IsmButton.rolloverHighlight", new ColorUIResource(0xFFFFFF));
        List<Serializable> pressGradient = Arrays.asList(Float.valueOf(0.0f), Float.valueOf(0.0f), new ColorUIResource(0xEFF7FF), null, new ColorUIResource(0xEFF7FF));
        table.put("IsmButton.gradientPress", pressGradient);
        table.put("IsmButton.pressHighlight", new ColorUIResource(0xEFF7FF));
        IsmRGBButtonStyle borderStyle = new IsmRGBButtonStyle();
        borderStyle.setBorderColor(IsmButtonStyle.ButtonState.NORMAL, new ColorUIResource(0xB1B1B1));
        borderStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.NORMAL, new ColorUIResource(0xB1B1B1));
        borderStyle.setBorderColor(IsmButtonStyle.ButtonState.ROLLOVER, new ColorUIResource(0x3399FF));
        borderStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.ROLLOVER, new ColorUIResource(0x3399FF));
        borderStyle.setBorderColor(IsmButtonStyle.ButtonState.PRESSED, new ColorUIResource(876746));
        borderStyle.setBorderCornerColor(IsmButtonStyle.ButtonState.PRESSED, new ColorUIResource(876746));
        table.put("ArmorButton.style", borderStyle);
        table.put("Button.foreground", this.getSystemTextColor());
        table.put("Button.font", this.getControlTextFont());
    }

    private void initRadioButtonUI(UIDefaults table) {
        Object selectedEnabledIcon = this.makeFlatIcon("radiobutton_selected.png");
        Object selectedDisabledIcon = this.makeFlatIcon("radiobutton_selected_disabled.png");
        Object unselectedEnabledIcon = this.makeFlatIcon("radiobutton_normal.png");
        Object unselectedDisabledIcon = this.makeFlatIcon("radiobutton_normal_disabled.png");
        Object unselectedRolloverIcon = this.makeFlatIcon("radiobutton_normal_rollover.png");
        Object selectedRolloverIcon = this.makeFlatIcon("radiobutton_selected_rollover.png");
        Object unselectedPressedIcon = this.makeFlatIcon("radiobutton_normal_pressed.png");
        Object selectedPressedIcon = this.makeFlatIcon("radiobutton_selected_pressed.png");
        table.put("RadioButton.icon", unselectedEnabledIcon);
        table.put("RadioButton.selectedEnabledIcon", selectedEnabledIcon);
        table.put("RadioButton.selectedDisabledIcon", selectedDisabledIcon);
        table.put("RadioButton.unselectedEnabledIcon", unselectedEnabledIcon);
        table.put("RadioButton.unselectedDisabledIcon", unselectedDisabledIcon);
        table.put("RadioButton.unselectedRolloverIcon", unselectedRolloverIcon);
        table.put("RadioButton.selectedRolloverIcon", selectedRolloverIcon);
        table.put("RadioButton.unselectedPressedIcon", unselectedPressedIcon);
        table.put("RadioButton.selectedPressedIcon", selectedPressedIcon);
        table.put("RadioButton.rollover", Boolean.TRUE);
    }

    private void initCheckBoxUI(UIDefaults table) {
        Object selectedEnabledIcon = this.makeFlatIcon("checkbox_selected.png");
        Object selectedDisabledIcon = this.makeFlatIcon("checkbox_selected_disabled.png");
        Object unselectedEnabledIcon = this.makeFlatIcon("checkbox_normal.png");
        Object unselectedDisabledIcon = this.makeFlatIcon("checkbox_normal_disabled.png");
        Object unselectedRolloverIcon = this.makeFlatIcon("checkbox_normal_rollover.png");
        Object selectedRolloverIcon = this.makeFlatIcon("checkbox_selected_rollover.png");
        Object unselectedPressedIcon = this.makeFlatIcon("checkbox_normal_pressed.png");
        Object selectedPressedIcon = this.makeFlatIcon("checkbox_selected_pressed.png");
        Object partialEnabledIcon = this.makeFlatIcon("checkbox_patial.png");
        Object partialDisabledIcon = this.makeFlatIcon("checkbox_patial_disabled.png");
        Object partialRolloverIcon = this.makeFlatIcon("checkbox_patial_rollover.png");
        Object partialPressedIcon = this.makeFlatIcon("checkbox_patial_pressed.png");
        table.put("CheckBox.partialEnabledIcon", partialEnabledIcon);
        table.put("CheckBox.partialDisabledIcon", partialDisabledIcon);
        table.put("CheckBox.partialRolloverIcon", partialRolloverIcon);
        table.put("CheckBox.partialPressedIcon", partialPressedIcon);
        table.put("CheckBox.icon", unselectedEnabledIcon);
        table.put("CheckBox.selectedEnabledIcon", selectedEnabledIcon);
        table.put("CheckBox.selectedDisabledIcon", selectedDisabledIcon);
        table.put("CheckBox.unselectedEnabledIcon", unselectedEnabledIcon);
        table.put("CheckBox.unselectedDisabledIcon", unselectedDisabledIcon);
        table.put("CheckBox.unselectedRolloverIcon", unselectedRolloverIcon);
        table.put("CheckBox.selectedRolloverIcon", selectedRolloverIcon);
        table.put("CheckBox.unselectedPressedIcon", unselectedPressedIcon);
        table.put("CheckBox.selectedPressedIcon", selectedPressedIcon);
        table.put("CheckBox.rollover", Boolean.TRUE);
    }

    protected Object makeFlatIcon(String iconName) {
        String iconPackage = "icons/";
        return LookAndFeel.makeIcon(FlatTheme.class, iconPackage + iconName);
    }

    @Override
    public FontUIResource getControlTextFont() {
        return FONT12_PLAIN;
    }

    @Override
    public FontUIResource getSystemTextFont() {
        return FONT12_PLAIN;
    }

    @Override
    public FontUIResource getUserTextFont() {
        return FONT12_PLAIN;
    }

    @Override
    public FontUIResource getMenuTextFont() {
        return FONT12_PLAIN;
    }

    @Override
    public FontUIResource getWindowTitleFont() {
        return FONT13_BOLD;
    }

    @Override
    public FontUIResource getSubTextFont() {
        return this.getMenuTextFont();
    }

    @Override
    public ColorUIResource getSystemTextColor() {
        return new ColorUIResource(0x333333);
    }

    @Override
    public ColorUIResource getUserTextColor() {
        return new ColorUIResource(0x333333);
    }
}

