/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.unify.UnifyIconFactory;
import com.huawei.ism.ui.swing.plaf.unify.UnifyScrollButton;
import com.huawei.ism.util.SwingUIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalScrollBarUI;

public class UnifyScrollBarUI
extends MetalScrollBarUI {
    private static final int THUMB_HEIGHT = 22;

    public static ComponentUI createUI(JComponent c) {
        return new UnifyScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollbar.setBlockIncrement(58);
        this.scrollbar.setUnitIncrement(29);
        if (this.scrollbar.getOrientation() == 1) {
            this.minimumThumbSize = (Dimension)UIManager.get("ScrollBar.minimumVThumbSize");
            this.maximumThumbSize = (Dimension)UIManager.get("ScrollBar.maximumVThumbSize");
        } else {
            this.minimumThumbSize = (Dimension)UIManager.get("ScrollBar.minimumHThumbSize");
            this.maximumThumbSize = (Dimension)UIManager.get("ScrollBar.maximumHThumbSize");
        }
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        this.decreaseButton = new UnifyScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        this.increaseButton = new UnifyScrollButton(orientation, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void setThumbBounds(int xx, int yy, int width, int height) {
        if ((int)this.thumbRect.getX() == xx && (int)this.thumbRect.getY() == yy && this.thumbRect.width == width && this.thumbRect.height == height) {
            return;
        }
        int py = 0;
        if (this.thumbRect.height != height) {
            py = 4;
        }
        int minX = Math.min(xx, (int)this.thumbRect.getX());
        int minY = Math.min(yy, (int)this.thumbRect.getY());
        int maxX = Math.max(xx + width, (int)this.thumbRect.getX() + this.thumbRect.width);
        int maxY = Math.max(yy + height, (int)this.thumbRect.getY() + this.thumbRect.height);
        this.thumbRect.setBounds(xx, yy - py, width, 22);
        this.scrollbar.repaint(minX, minY, maxX - minX, maxY - minY);
        this.setThumbRollover(false);
    }

    private boolean cptVShowThumb() {
        int thumbH;
        Dimension sbSize = this.scrollbar.getSize();
        Insets sbInsets = this.scrollbar.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        boolean squareButtons = SwingUIUtil.getBoolean(this.scrollbar, "ScrollBar.squareButtons", false);
        int decrButtonH = squareButtons ? itemW : this.decrButton.getPreferredSize().height;
        int incrButtonH = squareButtons ? itemW : this.incrButton.getPreferredSize().height;
        int incrGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decrGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButtonH + incrButtonH;
        int gaps = decrGap + incrGap;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH) - gaps;
        float min = this.scrollbar.getMinimum();
        float extent = this.scrollbar.getVisibleAmount();
        float range = (float)this.scrollbar.getMaximum() - min;
        int n = thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        return thumbH < (int)trackH;
    }

    private boolean cptHShowThumb() {
        int thumbW;
        Dimension sbSize = this.scrollbar.getSize();
        Insets sbInsets = this.scrollbar.getInsets();
        int incrGap = UIManager.getInt("ScrollBar.incrementButtonGap");
        int decrGap = UIManager.getInt("ScrollBar.decrementButtonGap");
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        boolean ltr = this.scrollbar.getComponentOrientation().isLeftToRight();
        boolean squareButtons = SwingUIUtil.getBoolean(this.scrollbar, "ScrollBar.squareButtons", false);
        int leftButtonW = squareButtons ? itemH : this.decrButton.getPreferredSize().width;
        int rightButtonW = squareButtons ? itemH : this.incrButton.getPreferredSize().width;
        int leftGap = ltr ? decrGap : incrGap;
        int rightGap = ltr ? incrGap : decrGap;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = leftButtonW + rightButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW) - (leftGap + rightGap);
        float min = this.scrollbar.getMinimum();
        float max = this.scrollbar.getMaximum();
        float extent = this.scrollbar.getVisibleAmount();
        float range = max - min;
        int n = thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        return thumbW < (int)trackW;
    }

    @Override
    protected Rectangle getThumbBounds() {
        Rectangle bounds = super.getThumbBounds();
        bounds.height = 22;
        return bounds;
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle thumbBounds) {
        graphics.translate((int)thumbBounds.getX(), (int)thumbBounds.getY());
        boolean isHorizontal = this.scrollbar.getOrientation() == 0;
        UnifyIconFactory.ScrollBarBlockIcon icon = null;
        icon = isHorizontal ? UnifyIconFactory.getScrollBarHBlockIcon() : UnifyIconFactory.getScrollBarVBlockIcon();
        IsmButtonStyle.ButtonState buttonState = IsmButtonStyle.ButtonState.NORMAL;
        if (!jComponent.isEnabled()) {
            buttonState = IsmButtonStyle.ButtonState.DISABLED;
        } else if (this.isDragging || this.isThumbRollover()) {
            buttonState = IsmButtonStyle.ButtonState.ROLLOVER;
        }
        if (isHorizontal) {
            if (this.cptHShowThumb()) {
                icon.paintIcon(jComponent, graphics, 0, thumbBounds.height - icon.getIconHeight() + 1 >> 1, buttonState);
            }
        } else if (this.cptVShowThumb()) {
            icon.paintIcon(jComponent, graphics, thumbBounds.width - icon.getIconWidth() >> 1, 0, buttonState);
        }
        graphics.translate(-((int)thumbBounds.getX()), -((int)thumbBounds.getY()));
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle trackBounds) {
        boolean isHorizontal;
        int trackBarWidth = UIManager.getInt("ScrollBar.TrackBarWidth");
        int width = trackBounds.width;
        int height = trackBounds.height;
        Color oldColor = graphics.getColor();
        graphics.translate((int)trackBounds.getX(), (int)trackBounds.getY());
        boolean bl = isHorizontal = this.scrollbar.getOrientation() == 0;
        if (isHorizontal) {
            int startY = this.scrollBarWidth - trackBarWidth >> 1;
            graphics.setColor(UIManager.getColor("ScrollBar.TrackBarBG"));
            graphics.fillRect(0, startY, width, trackBarWidth);
        } else {
            int startX = this.scrollBarWidth - trackBarWidth >> 1;
            graphics.setColor(UIManager.getColor("ScrollBar.TrackBarBG"));
            graphics.fillRect(startX, 0, trackBarWidth, height);
        }
        graphics.setColor(oldColor);
        graphics.translate(-((int)trackBounds.getX()), -((int)trackBounds.getY()));
    }
}

