/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class UnifyTextAreaUI
extends BasicTextAreaUI {
    private MixLisstenerImp mixedListener;

    public static ComponentUI createUI(JComponent c) {
        return new UnifyTextAreaUI();
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        IsmTextArea textField;
        JTextComponent textComponent = this.getComponent();
        if (!textComponent.isEditable()) {
            super.paintBackground(graphics);
            return;
        }
        if (textComponent instanceof IsmTextArea && (textField = (IsmTextArea)textComponent).isShowErrorToolTip() && textField.isEnabled()) {
            graphics.setColor(UIManager.getColor("TextComponent.errBackground"));
            graphics.fillRect(0, 0, textComponent.getWidth(), textComponent.getHeight());
            return;
        }
        graphics.setColor(textComponent.getBackground());
        graphics.fillRect(0, 0, textComponent.getWidth(), textComponent.getHeight());
        graphics.setColor(UIManager.getColor("TextField.backgroundTopHighlighter"));
        graphics.drawLine(1, 1, textComponent.getWidth() - 2, 1);
        int gradientHeight = UIManager.getInt("TextField.backgroundGradientHeight");
        String gradientKey = "TextField.backgroundNormalGradient";
        if (!textComponent.isEnabled() || !textComponent.isEditable()) {
            gradientKey = "TextField.backgroundDisabledGradient";
        }
        IsmPlafUtils.drawGradient((Component)textComponent, graphics, gradientKey, new Rectangle(1, 1, textComponent.getWidth() - 2, gradientHeight), true);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.mixedListener = new MixLisstenerImp();
        this.getComponent().addMouseListener(this.mixedListener);
        this.getComponent().addFocusListener(this.mixedListener);
        this.getComponent().addKeyListener(this.mixedListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeMouseListener(this.mixedListener);
        this.getComponent().removeFocusListener(this.mixedListener);
        this.getComponent().removeKeyListener(this.mixedListener);
    }

    private class MixLisstenerImp
    extends MouseAdapter
    implements FocusListener,
    KeyListener {
        private MixLisstenerImp() {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.refresh();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.refresh();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.refresh();
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.refresh();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.refresh();
        }

        protected void refresh() {
            Container ancestor = SwingUtilities.getAncestorOfClass(JScrollPane.class, UnifyTextAreaUI.this.getComponent());
            if (null != ancestor) {
                ancestor.repaint();
            } else if (UnifyTextAreaUI.this.getComponent().getParent() != null) {
                UnifyTextAreaUI.this.getComponent().getParent().repaint();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.refresh();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.refresh();
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.refresh();
        }
    }
}

