/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.SerialSet;
import com.huawei.ism.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IsmAbstractTableModel
extends AbstractTableModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmAbstractTableModel.class);
    private static final long serialVersionUID = 1L;
    private SerialSet<TableRow> rowList = new SerialSet();
    private Map<Integer, Class<?>> columnClass = new HashMap(0);
    private List<Integer> visibleColIds = new ArrayList<Integer>(0);
    private List<Integer> fixedVisibleColumnID = new ArrayList<Integer>(0);
    private String[] allColumnNames;

    public IsmAbstractTableModel(String[] columnNames, int ... visibleColumnIds) {
        if (null == columnNames) {
            this.allColumnNames = new String[0];
        } else {
            this.allColumnNames = new String[columnNames.length];
            System.arraycopy(columnNames, 0, this.allColumnNames, 0, this.allColumnNames.length);
        }
        int[] validVisibleColumnIds = visibleColumnIds;
        if (null == validVisibleColumnIds || validVisibleColumnIds.length == 0) {
            validVisibleColumnIds = new int[this.allColumnNames.length];
            for (int i = 0; i < this.allColumnNames.length; ++i) {
                validVisibleColumnIds[i] = i;
            }
        }
        this.setVisibleColumns(validVisibleColumnIds);
        this.setFixedVisableColumns(0);
    }

    public IsmAbstractTableModel(String[] columnNames, int[] visibleColumnIdsForever, int ... visibleColumnIds) {
        this(columnNames, visibleColumnIds);
        this.setFixedVisableColumns(visibleColumnIdsForever);
    }

    public void setFixedVisableColumns(int ... fixedVisibleColumnIDs) {
        if (this.visibleColIds.isEmpty()) {
            return;
        }
        if (Utils.isNullArray(fixedVisibleColumnIDs)) {
            this.fixedVisibleColumnID.add(this.visibleColIds.get(0));
            return;
        }
        for (int i = 0; i < fixedVisibleColumnIDs.length; ++i) {
            if (!this.visibleColIds.contains(i)) {
                throw new IllegalArgumentException("the visibleColumnIdsForever must be in the visibleColumnIds");
            }
            this.fixedVisibleColumnID.add(i);
        }
    }

    public void setVisibleColumns(int ... visibleColumnIds) {
        if (null != visibleColumnIds && visibleColumnIds.length > 0) {
            this.visibleColIds.clear();
            for (int visibleColumnId : visibleColumnIds) {
                if (visibleColumnId >= this.allColumnNames.length) {
                    throw new ArrayIndexOutOfBoundsException(visibleColumnId);
                }
                this.visibleColIds.add(visibleColumnId);
            }
            this.fireTableStructureChanged();
        }
    }

    public void setCustomVisibleColumns(int ... visibleColumnIds) {
        if (null != visibleColumnIds) {
            this.visibleColIds.clear();
            if (0 == visibleColumnIds.length) {
                for (int i = 0; i < this.allColumnNames.length; ++i) {
                    this.visibleColIds.add(i);
                }
            } else {
                for (int visibleColumnId : visibleColumnIds) {
                    if (visibleColumnId >= this.allColumnNames.length) {
                        throw new ArrayIndexOutOfBoundsException(visibleColumnId);
                    }
                    this.visibleColIds.add(visibleColumnId);
                }
            }
            this.fireTableStructureChanged();
        }
    }

    public int[] getVisibleColumns() {
        int[] visibleColumnIds = new int[this.visibleColIds.size()];
        for (int i = 0; i < this.visibleColIds.size(); ++i) {
            visibleColumnIds[i] = this.visibleColIds.get(i);
        }
        return visibleColumnIds;
    }

    public int[] getFixedVisiableColumn() {
        int[] visibleColumnIdsForever = new int[this.fixedVisibleColumnID.size()];
        for (int i = 0; i < this.fixedVisibleColumnID.size(); ++i) {
            visibleColumnIdsForever[i] = this.fixedVisibleColumnID.get(i);
        }
        return visibleColumnIdsForever;
    }

    public int getAllColumnCount() {
        return this.allColumnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        int id = -1;
        if (column < this.visibleColIds.size() && column >= 0) {
            id = this.visibleColIds.get(column);
        }
        if (id < 0) {
            return this.allColumnNames[column];
        }
        return this.allColumnNames[id];
    }

    @Override
    public int getColumnCount() {
        return this.visibleColIds.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            int column = 0;
            if (columnIndex < this.visibleColIds.size() && columnIndex >= 0) {
                column = this.visibleColIds.get(columnIndex);
            }
            return this.getRow(rowIndex).getValueAt(column);
        }
        catch (Throwable t) {
            LOGGER.error("", t);
            return null;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        super.setValueAt(aValue, rowIndex, columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.rowList.size();
    }

    public TableRow getRow(int rowIndex) {
        return this.rowList.get(rowIndex);
    }

    public abstract void removeAll();

    public List<TableRow> getAllRows() {
        return new ArrayList<TableRow>(this.rowList);
    }

    public void updateRow(TableRow ... targetRows) {
        if (null == targetRows || targetRows.length == 0) {
            return;
        }
        int firstRow = -1;
        int lastRow = -1;
        int currentRow = 0;
        for (TableRow targetRow : targetRows) {
            if (!this.rowList.contains(targetRow) || -1 == (currentRow = this.rowList.indexOf(targetRow))) continue;
            if (firstRow < 0 || lastRow < 0) {
                lastRow = firstRow = currentRow;
            } else {
                firstRow = Math.min(firstRow, currentRow);
                lastRow = Math.max(lastRow, currentRow);
            }
            this.rowList.set(currentRow, targetRow);
        }
        if (firstRow >= 0 && lastRow >= 0) {
            this.fireTableRowsUpdated(firstRow, lastRow);
        }
    }

    public abstract void removeRow(TableRow ... var1);

    public abstract void addRow(TableRow ... var1);

    public void setTableData(TableRow ... targetRows) {
        if (null == targetRows) {
            return;
        }
        LinkedList<TableRow> rowToBeRemoved = new LinkedList<TableRow>();
        LinkedList<TableRow> rowToBeUpdated = new LinkedList<TableRow>();
        LinkedList<TableRow> rowToBeAdded = new LinkedList<TableRow>();
        HashSet newIdentifierSet = new HashSet(0);
        Object identifier = null;
        for (TableRow targetRow : targetRows) {
            identifier = targetRow.getIdentifier();
            newIdentifierSet.add(identifier);
            if (this.rowList.contains(targetRow)) {
                rowToBeUpdated.add(targetRow);
                continue;
            }
            rowToBeAdded.add(targetRow);
        }
        rowToBeRemoved.addAll(this.rowList);
        Iterator tableRowIter = rowToBeRemoved.iterator();
        TableRow tableRow = null;
        while (tableRowIter.hasNext()) {
            tableRow = (TableRow)tableRowIter.next();
            if (!newIdentifierSet.contains(tableRow.getIdentifier())) continue;
            tableRowIter.remove();
        }
        this.removeRow(rowToBeRemoved.toArray(new TableRow[rowToBeRemoved.size()]));
        this.updateRow(rowToBeUpdated.toArray(new TableRow[rowToBeUpdated.size()]));
        this.addRow(rowToBeAdded.toArray(new TableRow[rowToBeAdded.size()]));
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Object value = this.getValueAt(rowIndex, columnIndex);
        if (value instanceof IsmTableCell) {
            IsmTableCell cell = (IsmTableCell)value;
            return null != cell.getEditor();
        }
        return false;
    }

    public int getRowIndex(Object rowIdentifier) {
        int rowCount = this.getRowCount();
        TableRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.getRow(i);
            if (!row.getIdentifier().equals(rowIdentifier)) continue;
            return i;
        }
        return -1;
    }

    public int getRowIndex(TableRow row) {
        return this.rowList.indexOf(row);
    }

    public TableRow<?, ?> getTableRowBy(Object rowIdentifier) {
        int rowCount = this.getRowCount();
        TableRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.getRow(i);
            if (null == row.getIdentifier() || !row.getIdentifier().equals(rowIdentifier)) continue;
            return row;
        }
        return null;
    }

    public List<TableRow> getTableRows(Object ... rowIdentifiers) {
        ArrayList<TableRow> tableRows = new ArrayList<TableRow>(0);
        TableRow<?, ?> tableRow = null;
        for (Object object : rowIdentifiers) {
            tableRow = this.getTableRowBy(object);
            if (null == tableRow) continue;
            tableRows.add(tableRow);
        }
        return tableRows;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        Class<?> clazz;
        int column = 0;
        if (columnIndex < this.visibleColIds.size() && columnIndex >= 0) {
            column = this.visibleColIds.get(columnIndex);
        }
        if (null == (clazz = this.columnClass.get(column))) {
            Object cell = null;
            try {
                if (this.getRowCount() > 0) {
                    cell = this.getRow(0).getValueAt(column);
                }
                if (null != cell) {
                    clazz = cell.getClass();
                    this.columnClass.put(column, clazz);
                }
            }
            catch (Throwable t) {
                LOGGER.error("", t);
            }
        }
        if (null != clazz) {
            return clazz;
        }
        return super.getColumnClass(columnIndex);
    }

    public void reset(List<TableRow> targetRows, IsmTable table) {
        int[] selRows;
        SerialSet allId = new SerialSet();
        for (int row : selRows = table.getSelectedRows()) {
            allId.add(this.getRow(table.convertRowIndexToModel(row)).getIdentifier());
        }
        SerialSet<TableRow> newList = new SerialSet<TableRow>(targetRows);
        this.rowList = newList;
        this.fireTableDataChanged();
        if (selRows.length == 0) {
            return;
        }
        int startIndex = -1;
        int endIndex = -1;
        Object id = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            id = this.getRow(i).getIdentifier();
            if (!allId.contains(id)) continue;
            int rowIndexToView = table.convertRowIndexToView(i);
            if (startIndex == -1) {
                startIndex = rowIndexToView;
                endIndex = rowIndexToView;
                continue;
            }
            if (rowIndexToView - 1 == endIndex) {
                endIndex = rowIndexToView;
                continue;
            }
            table.addRowSelectionInterval(startIndex, endIndex);
            startIndex = rowIndexToView;
            endIndex = rowIndexToView;
        }
        if (startIndex != -1 && endIndex != -1) {
            table.addRowSelectionInterval(startIndex, endIndex);
        }
    }

    public final void addRow(List<TableRow> tableRows) {
        if (null == tableRows || tableRows.isEmpty()) {
            return;
        }
        this.addRow(tableRows.toArray(new TableRow[tableRows.size()]));
    }

    public final void updateRow(List<TableRow> tableRows) {
        if (null == tableRows || tableRows.isEmpty()) {
            return;
        }
        this.updateRow(tableRows.toArray(new TableRow[tableRows.size()]));
    }

    public final void removeRow(List<TableRow> tableRows) {
        if (null == tableRows || tableRows.isEmpty()) {
            return;
        }
        this.removeRow(tableRows.toArray(new TableRow[tableRows.size()]));
    }

    public final void setTableData(List<TableRow> tableRows) {
        if (null == tableRows) {
            return;
        }
        this.setTableData(tableRows.toArray(new TableRow[tableRows.size()]));
    }

    public String[] getAllColumnNames() {
        return this.copyAllColum(this.allColumnNames);
    }

    private String[] copyAllColum(String[] toBeCopy) {
        if (toBeCopy == null) {
            return new String[0];
        }
        return (String[])toBeCopy.clone();
    }

    public void setAllColumnNames(String[] allColumnNames) {
        this.allColumnNames = this.copyAllColum(allColumnNames);
    }

    public List<Integer> getVisibleColIds() {
        return this.visibleColIds;
    }

    public void setVisibleColIds(List<Integer> visibleColIds) {
        this.visibleColIds = visibleColIds;
    }

    public SerialSet<TableRow> getRowList() {
        return this.rowList;
    }

    public void setRowList(SerialSet<TableRow> rowList) {
        this.rowList = rowList;
    }
}

