/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import com.huawei.ism.ui.swing.text.IPAddressField;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Unit;
import com.huawei.ism.util.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.EventObject;
import java.util.Objects;
import java.util.TimeZone;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IsmTableCell
implements Comparable<IsmTableCell>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(IsmTableCell.class);
    private static final int NUM_15 = 15;
    private Color color;

    public abstract String toString();

    public IsmTableCell clone() {
        try {
            return (IsmTableCell)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return this;
        }
    }

    public abstract TableCellRenderer getRender();

    public TableCellEditor getEditor() {
        return null;
    }

    public ActionListener getAction() {
        return null;
    }

    public boolean isMouseInBounds(MouseEvent e, Rectangle rect) {
        return true;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public int compareTo(IsmTableCell o) {
        if (this.equals(o)) {
            return 0;
        }
        String oStr = o == null ? "" : o.toString();
        return this.toString().compareTo(oStr);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public static class ComboCell
    extends IsmTableCell {
        private static final long serialVersionUID = 3437596994348375009L;
        private static ComboCellRender render = new ComboCellRender();
        private IsmTableCell[] subCells;
        private int marginValue = 4;

        public ComboCell(IsmTableCell ... cells) {
            this.subCells = cells;
        }

        public ComboCell(int margin, IsmTableCell ... cells) {
            this(cells);
            this.marginValue = margin;
        }

        public void setMargin(int margin) {
            this.marginValue = margin;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof ComboCell)) {
                return -1;
            }
            ComboCell other = (ComboCell)o;
            int minLength = this.subCells.length < other.subCells.length ? this.subCells.length : other.subCells.length;
            int weight = 0;
            for (int count = 0; count < minLength; ++count) {
                weight = weight * 10 + this.subCells[count].compareTo(other.subCells[count]);
            }
            return weight;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ComboCell)) {
                return false;
            }
            ComboCell other = (ComboCell)obj;
            if (this.subCells.length != other.subCells.length) {
                return false;
            }
            for (int count = 0; count < this.subCells.length; ++count) {
                if (this.subCells[count].equals(other.subCells[count])) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (IsmTableCell cell : this.subCells) {
                hashCode += cell.hashCode();
            }
            return hashCode;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (IsmTableCell cell : this.subCells) {
                sb = sb.append(":").append(cell.toString());
            }
            String desc = sb.toString();
            if (desc.endsWith(":")) {
                desc = desc.substring(0, desc.length() - 1);
            }
            return desc;
        }

        private static class ComboCellRender
        extends CustomTableCellRender {
            private static final long serialVersionUID = 7057533522462966382L;

            private ComboCellRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof ComboCell) {
                    ComboCell cell = (ComboCell)value;
                    IsmTableCell[] subCells = cell.subCells;
                    Component[] subCellRendererComps = new Component[subCells.length];
                    for (int index = 0; index < subCells.length; ++index) {
                        IsmTableCell subCell = subCells[index];
                        subCellRendererComps[index] = subCell.getRender().getTableCellRendererComponent(table, subCell, isSelected, hasFocus, row, column);
                    }
                    JComponent renderedComp = this.renderComponent(UCD.buildHBoxLeft(cell.marginValue, subCellRendererComps));
                    this.setBackGround(table, isSelected, row, renderedComp);
                    return renderedComp;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
    }

    public static class LabelCell
    extends IsmTableCell {
        private static final long serialVersionUID = 3548873361020318758L;
        private static LabelCellRender render = new LabelCellRender();
        private String contentValue = "";
        private Color fontColor;
        private String toolTip = "";

        public LabelCell(String content) {
            this.contentValue = content;
        }

        public LabelCell(String content, Color fontColor) {
            this(content);
            this.fontColor = fontColor;
        }

        public Color getFontColor() {
            return this.fontColor;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof LabelCell)) {
                return -1;
            }
            LabelCell other = (LabelCell)o;
            return this.contentValue.compareTo(other.contentValue);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof LabelCell)) {
                return false;
            }
            LabelCell other = (LabelCell)obj;
            return this.contentValue.equals(other.contentValue);
        }

        @Override
        public int hashCode() {
            return this.contentValue.hashCode();
        }

        @Override
        public String toString() {
            return this.contentValue;
        }

        public void setLabelTips(String tips) {
            this.toolTip = tips;
        }

        private static class LabelCellRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = -2164948676975652444L;
            private Color fColor;

            private LabelCellRender() {
            }

            public Color getfColor() {
                return this.fColor;
            }

            public void setfColor(Color color) {
                this.fColor = color;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof LabelCell) {
                    LabelCell cell = (LabelCell)value;
                    JLabel label = new JLabel(cell.contentValue);
                    if (!StringUtils.isNULLStr(cell.toolTip)) {
                        label.setToolTipText(cell.toolTip);
                    }
                    label.setOpaque(true);
                    if (isSelected) {
                        label.setBackground(table.getSelectionBackground());
                    }
                    this.setBackGround(table, isSelected, row, label);
                    if (null != cell.getFontColor()) {
                        label.setForeground(cell.getFontColor());
                    }
                    return label;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
    }

    public static class CustomLabelCell
    extends LabelCell {
        private Comparable sorterCell;

        public CustomLabelCell(String content, Comparable sorterCell) {
            super(content);
            this.sorterCell = sorterCell;
        }

        @Override
        public int compareTo(IsmTableCell cell) {
            if (!(cell instanceof LabelCell)) {
                return -1;
            }
            CustomLabelCell other = (CustomLabelCell)cell;
            return this.sorterCell.compareTo(other.sorterCell);
        }
    }

    public static class IPV4TextCell
    extends IsmTableCell {
        private static final long serialVersionUID = 1145433133914435406L;
        private IPAddressField ipAddressField = new IPAddressField();
        private IPV4TextCellRenderer render = new IPV4TextCellRenderer();
        private IPV4TextCellEditor editor = new IPV4TextCellEditor();

        public IPV4TextCell() {
        }

        public IPV4TextCell(IPAddressField ipAddressField) {
            this.ipAddressField = ipAddressField;
        }

        @Override
        public TableCellRenderer getRender() {
            return this.render;
        }

        @Override
        public TableCellEditor getEditor() {
            return this.editor;
        }

        public IPAddressField getEditorComponent() {
            return this.ipAddressField;
        }

        @Override
        public String toString() {
            return this.getIPText();
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof IPV4TextCell)) {
                return -1;
            }
            IPV4TextCell that = (IPV4TextCell)o;
            return this.getIPText().compareTo(that.getIPText());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IPV4TextCell)) {
                return false;
            }
            IPV4TextCell that = (IPV4TextCell)obj;
            return this.getIPText().equals(that.getIPText());
        }

        @Override
        public int hashCode() {
            return this.getIPText().hashCode();
        }

        public String getIPText() {
            if (CommonUtil.isNullIPv4Address(this.ipAddressField.getIPText())) {
                return "";
            }
            return this.ipAddressField.getIPText();
        }

        public void setIPText(String ip) {
            this.ipAddressField.setIPText(ip);
        }

        private class IPV4TextCellEditor
        extends AbstractCellEditor
        implements TableCellEditor {
            private static final long serialVersionUID = 8314008359749307477L;

            private IPV4TextCellEditor() {
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return IPV4TextCell.this.ipAddressField;
            }

            @Override
            public Object getCellEditorValue() {
                return IPV4TextCell.this.getIPText();
            }
        }

        private class IPV4TextCellRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = -2305281663016497767L;

            private IPV4TextCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!(value instanceof IPV4TextCell)) {
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                IPV4TextCell cell = (IPV4TextCell)value;
                if (!isSelected) {
                    String ipText = CommonUtil.isNullIPv4Address(IPV4TextCell.this.ipAddressField.getIPText()) ? "" : IPV4TextCell.this.ipAddressField.getIPText();
                    Component component = super.getTableCellRendererComponent(table, ipText, isSelected, hasFocus, row, column);
                    return component;
                }
                return cell.ipAddressField;
            }
        }
    }

    protected static class CustomTableCellRender
    extends IsmTableCellRenderer {
        private static final long serialVersionUID = 1L;

        protected CustomTableCellRender() {
        }

        protected JComponent renderComponent(JComponent comp) {
            JPanel cellAfterRendered = new JPanel(){
                private static final long serialVersionUID = -6426201552005499860L;

                @Override
                public void paint(Graphics graphics) {
                    if (IsmPlafUtils.isUnifyStyle() && this.isRollover()) {
                        IsmPlafUtils.drawGradient((Component)this, graphics, "Table.rolloverGradient", new Rectangle(0, 0, this.getWidth(), this.getHeight()), true);
                    }
                    super.paint(graphics);
                }
            };
            cellAfterRendered.setLayout(new BoxLayout(cellAfterRendered, 1));
            cellAfterRendered.add(Box.createVerticalGlue());
            cellAfterRendered.add(comp);
            cellAfterRendered.add(Box.createVerticalGlue());
            cellAfterRendered.setOpaque(true);
            return cellAfterRendered;
        }

        @Override
        protected void setBackGround(JTable table, boolean isSelected, int row, JComponent comp) {
            if (!(table instanceof IsmTable)) {
                return;
            }
            IsmTable ismTable = (IsmTable)table;
            if (!isSelected) {
                this.setRollover(row == ismTable.getCurRolloverRow());
                if (!ismTable.isEnabled()) {
                    comp.setBackground(UIManager.getColor("Table.disabledBackgound"));
                } else if (this.isRollover()) {
                    if (!IsmPlafUtils.isUnifyStyle()) {
                        comp.setBackground(UIManager.getColor("Table.rolloverColor"));
                    } else {
                        comp.setOpaque(false);
                    }
                } else if (row % 2 != 0) {
                    comp.setBackground(UIManager.getColor("Table.alternateRowColor"));
                } else {
                    comp.setBackground(UIManager.getColor("Table.backgound"));
                }
            } else {
                comp.setBackground(UIManager.getColor("Table.selectionBackground"));
            }
        }
    }

    public static class ColorTableCell
    extends IsmTableCell {
        private static final long serialVersionUID = 1808111220086856741L;
        private static ColorTableCellRenderer render = new ColorTableCellRenderer();
        private transient Color colorValue;
        private String descStr;

        public ColorTableCell(Color colorValue) {
            this.colorValue = colorValue;
        }

        public ColorTableCell() {
        }

        @Override
        public final void setColor(Color color) {
            this.colorValue = color;
        }

        @Override
        public Color getColor() {
            return this.colorValue;
        }

        public final void setDescription(String desc) {
            this.descStr = null == desc ? "" : desc;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public String toString() {
            return this.descStr;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof ColorTableCell)) {
                return false;
            }
            ColorTableCell colorLabelCell = (ColorTableCell)obj;
            return this.colorValue.equals(colorLabelCell.colorValue);
        }

        @Override
        public int hashCode() {
            return this.colorValue.hashCode();
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            stream.defaultWriteObject();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }

        private static class ColorTableCellRenderer
        extends CustomTableCellRender {
            private static final long serialVersionUID = -435505213294813444L;
            private JLabel label = new JLabel();

            public ColorTableCellRenderer() {
                this.label.setOpaque(true);
                this.label.setHorizontalAlignment(2);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.label.setMinimumSize(new Dimension(1, 4));
                this.label.setPreferredSize(new Dimension(this.label.getPreferredSize().width, 4));
                this.label.setMaximumSize(new Dimension(Short.MAX_VALUE, 4));
                JComponent component = this.renderComponent(this.label);
                this.setBackGround(table, isSelected, row, component);
                if (value instanceof ColorTableCell) {
                    ColorTableCell cell = (ColorTableCell)value;
                    this.label.setBackground(cell.colorValue);
                    this.label.setText(cell.descStr);
                }
                return component;
            }
        }
    }

    public static class ColorfulComboBoxCell
    extends ComboBoxCell {
        private static final long serialVersionUID = -6532824685987186391L;
        private static final IsmTableCellRenderer RENDERER = new ColComboBoxCellRender();

        public ColorfulComboBoxCell(ColComEntity[] values, ColComEntity selecteditem) {
            super(values, selecteditem);
        }

        private static ColComEntity[] getItemEntities(Object[] os, Color[] cs, ImageIcon[] icons) {
            if (os == null) {
                throw new IllegalArgumentException("os is null.");
            }
            int size = Math.min(Math.min(cs == null ? Integer.MAX_VALUE : cs.length, os.length), icons == null ? Integer.MAX_VALUE : icons.length);
            if (size == 0) {
                throw new IllegalArgumentException("os is empty");
            }
            ColComEntity[] values = new ColComEntity[size];
            for (int index = 0; index < size; ++index) {
                Object o = os[index];
                Color c = cs == null || cs[index] == null ? Color.BLACK : cs[index];
                values[index] = new ColComEntity(o == null ? "" : o, c, icons == null ? null : icons[index]);
            }
            return values;
        }

        public static ColorfulComboBoxCell create(Object[] os, Color[] cs, ImageIcon[] icons, int selectIndex) {
            ColComEntity[] values = ColorfulComboBoxCell.getItemEntities(os, cs, icons);
            int size = Math.min(os.length, cs.length);
            return new ColorfulComboBoxCell(values, values[Math.max(Math.min(size - 1, selectIndex), 0)]);
        }

        public static ColorfulComboBoxCell create(Object[] os, Color[] cs, ImageIcon[] icons, Object selectItem, Color selectColor) {
            ColComEntity[] values = ColorfulComboBoxCell.getItemEntities(os, cs, icons);
            return new ColorfulComboBoxCell(values, new ColComEntity(selectItem, selectColor));
        }

        public static ColorfulComboBoxCell create(Object[] os, Color[] cs, ImageIcon[] icons, Object selectItem) {
            return ColorfulComboBoxCell.create(os, cs, icons, selectItem, Color.blue);
        }

        @Override
        public TableCellRenderer getRender() {
            return RENDERER;
        }

        @Override
        public Object getSelectedItem() {
            DefaultCellEditor editor = this.getEditor();
            if (null != editor) {
                editor.stopCellEditing();
            }
            return super.getSelectedItem();
        }

        public static class ColComboBoxCellRender
        extends ComboBoxCell.ComBoxRender {
            private static final long serialVersionUID = 7927142009012598859L;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Object o;
                Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!(value instanceof ComboBoxCell)) {
                    return res;
                }
                ComboBoxCell cell = (ComboBoxCell)value;
                if (!isSelected && (o = cell.getSelectedItem()) instanceof ColComEntity) {
                    ColComEntity entity = (ColComEntity)o;
                    res.setForeground(entity.getColor());
                    if (res instanceof JLabel) {
                        ((JLabel)res).setIcon(entity.getIcon());
                    }
                }
                return res;
            }
        }

        public static class ColComEntity {
            private Object object;
            private Color color;
            private ImageIcon icon;

            public ColComEntity(Object object, Color color, ImageIcon icon) {
                this(object, color);
                this.icon = icon;
            }

            public ColComEntity(Object object, Color color) {
                this.object = object;
                this.color = color;
            }

            public Object getObject() {
                return this.object;
            }

            public Color getColor() {
                return this.color;
            }

            public void setObject(Object object) {
                this.object = object;
            }

            public void setColor(Color color) {
                this.color = color;
            }

            public String toString() {
                return this.object == null ? "" : Objects.toString(this.object);
            }

            public ImageIcon getIcon() {
                return this.icon;
            }

            public void setIcon(ImageIcon icon) {
                this.icon = icon;
            }
        }
    }

    public static class ComboBoxCell
    extends IsmTableCell {
        private static final long serialVersionUID = -5299829748480670107L;
        private static TableCellRenderer render = new ComBoxRender();
        private DefaultCellEditor editor = new ComboBoxEditor();
        private JComboBox comboBox = null;
        private transient ActionListener actionListener = null;
        private transient ItemListener itemListener = null;
        private Object[] valuesObj;
        private Object selectedItem;
        private Object rendererItem;
        private boolean differentiateStatus = true;

        public ComboBoxCell(Object[] values, Object selecteditem) {
            this.valuesObj = Arrays.copyOf(values, values.length);
            this.selectedItem = selecteditem;
            this.addItems(values, selecteditem);
        }

        public ComboBoxCell(Object[] values, Object selecteditem, ActionListener action) {
            this(values, selecteditem);
            this.actionListener = action;
        }

        public ComboBoxCell(Object[] values, Object selecteditem, ItemListener item) {
            this(values, selecteditem);
            this.setItemListener(item);
        }

        private void addItems(Object[] values, Object selecteditem) {
            this.comboBox = (JComboBox)this.getEditor().getComponent();
            for (Object value : values) {
                this.comboBox.addItem(value);
            }
            this.comboBox.setSelectedItem(selecteditem);
        }

        public void updateItems(String[] values, String selecteditem) {
            this.comboBox = (JComboBox)this.getEditor().getComponent();
            this.comboBox.removeAllItems();
            for (String value : values) {
                this.comboBox.addItem(value);
            }
            this.comboBox.setSelectedItem(selecteditem);
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public DefaultCellEditor getEditor() {
            return this.editor;
        }

        @Override
        public ActionListener getAction() {
            return this.actionListener;
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }

        public void setSelectedItem(Object obj) {
            JComboBox cbBox = (JComboBox)this.getEditor().getComponent();
            this.selectedItem = obj;
            cbBox.setSelectedItem(obj);
        }

        public void setDifferentiateStatus(boolean differentiateStatus) {
            this.differentiateStatus = differentiateStatus;
        }

        public boolean isDifferentiateStatus() {
            return this.differentiateStatus;
        }

        public void setRendererItem(Object item) {
            this.rendererItem = item;
        }

        public Object getRendererItem() {
            return this.rendererItem;
        }

        @Override
        public String toString() {
            return this.selectedItem.toString();
        }

        protected Object readResolve() throws ObjectStreamException {
            return new ComboBoxCell(this.valuesObj, this.selectedItem);
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof ComboBoxCell)) {
                return -1;
            }
            ComboBoxCell that = (ComboBoxCell)o;
            if (this.selectedItem instanceof Comparable && that.selectedItem instanceof Comparable) {
                Comparable comp1 = (Comparable)this.selectedItem;
                Comparable comp2 = (Comparable)that.selectedItem;
                return comp1.compareTo(comp2);
            }
            return Collator.getInstance().compare(this.selectedItem.toString(), that.selectedItem.toString());
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ComboBoxCell)) {
                return false;
            }
            ComboBoxCell that = (ComboBoxCell)object;
            return this.selectedItem.equals(that.selectedItem);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.valuesObj);
        }

        public void setActionListener(ActionListener actionListener) {
            this.actionListener = actionListener;
            this.comboBox.addActionListener(actionListener);
        }

        public void setItemListener(ItemListener itemListener) {
            this.itemListener = itemListener;
            this.comboBox.addItemListener(itemListener);
        }

        public JComboBox getComboBox() {
            return this.comboBox;
        }

        public void setEditable(boolean flag) {
            this.comboBox.setEnabled(flag);
        }

        static class ComboBoxEditor
        extends DefaultCellEditor {
            private static final long serialVersionUID = -5472194580313352567L;
            private ComboBoxCell cell;

            public ComboBoxEditor() {
                super(new JComboBox());
            }

            public ComboBoxEditor(JComboBox comboBox) {
                super(comboBox);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (value instanceof ComboBoxCell) {
                    this.cell = (ComboBoxCell)value;
                    Object obj = this.cell.selectedItem;
                    this.addItems(this.cell.valuesObj);
                    ((JComboBox)this.getComponent()).setSelectedItem(obj);
                }
                return this.editorComponent;
            }

            private void addItems(Object[] items) {
                JComboBox comboBox = (JComboBox)this.getComponent();
                if (comboBox.getItemCount() > 0) {
                    return;
                }
                for (Object item : items) {
                    comboBox.addItem(item);
                }
            }

            @Override
            public boolean stopCellEditing() {
                boolean isStop = super.stopCellEditing();
                if (null != this.cell && isStop) {
                    JComboBox comboBox = (JComboBox)this.getComponent();
                    this.cell.selectedItem = comboBox.getSelectedItem();
                }
                return isStop;
            }
        }

        static class ComBoxRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 725238083212111020L;
            private JComboBox combox = new JComboBox();

            ComBoxRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!(value instanceof ComboBoxCell)) {
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                ComboBoxCell cell = (ComboBoxCell)value;
                if (cell.isDifferentiateStatus() && !isSelected) {
                    if (cell.getRendererItem() == null) {
                        return super.getTableCellRendererComponent(table, cell.getSelectedItem(), isSelected, hasFocus, row, column);
                    }
                    return super.getTableCellRendererComponent(table, cell.getSelectedItem() + cell.getRendererItem().toString(), isSelected, hasFocus, row, column);
                }
                if (cell.getRendererItem() == null) {
                    this.combox.removeAllItems();
                    this.combox.addItem(cell.getSelectedItem());
                    this.combox.setSelectedItem(cell.getSelectedItem());
                } else {
                    this.combox.removeAllItems();
                    this.combox.addItem(cell.getSelectedItem() + cell.getRendererItem().toString());
                    this.combox.setSelectedItem(cell.getSelectedItem() + cell.getRendererItem().toString());
                }
                return this.combox;
            }
        }
    }

    public static class LabelAndHyperlinkCell
    extends IsmTableCell {
        private static final long serialVersionUID = 1808112220086856741L;
        private static final Color COLOR_MOUSE_OVER = new Color(4359891);
        private static final Color COLOR_AFTER_CLICK = new Color(26879);
        private static LabelAndHyperlinkRenderer render = new LabelAndHyperlinkRenderer();
        private String description;
        private JLabel label = new JLabel();
        private JLabel linkLabel = new JLabel();
        private Color labelColor = Color.black;
        private transient ActionListener acListener = null;

        public LabelAndHyperlinkCell(String labelDesc, String linkDesc, ActionListener action) {
            this.label.setText(labelDesc);
            this.setLinkDesc(linkDesc);
            this.acListener = action;
        }

        public LabelAndHyperlinkCell(String labelDesc, String linkDesc, ActionListener action, Color labelColor) {
            this.label.setText(labelDesc);
            this.setLinkDesc(linkDesc);
            this.acListener = action;
            this.labelColor = labelColor;
        }

        public LabelAndHyperlinkCell(String labelDesc, ActionListener action) {
            this.label.setText(labelDesc);
            this.acListener = action;
        }

        public final void setLinkDesc(String desc) {
            this.description = null == desc ? "" : desc;
            this.linkLabel.setText(desc);
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public ActionListener getAction() {
            return this.acListener;
        }

        @Override
        public boolean isMouseInBounds(MouseEvent mouseEvent, Rectangle rect) {
            Rectangle bounds = this.linkLabel.getBounds();
            Point tableCellLocation = rect.getLocation();
            Point mousePosition = mouseEvent.getPoint();
            Point mouseRelativeLocation = new Point();
            mouseRelativeLocation.setLocation(mousePosition.getX() - tableCellLocation.getX(), mousePosition.getY() - tableCellLocation.getY());
            return bounds.contains(mouseRelativeLocation);
        }

        @Override
        public String toString() {
            return this.description;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof LabelAndHyperlinkCell)) {
                return -1;
            }
            String thisVal = this.label.getText();
            String thatVal = ((LabelAndHyperlinkCell)o).label.getText();
            return thisVal.compareTo(thatVal);
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof LabelAndHyperlinkCell)) {
                return false;
            }
            LabelAndHyperlinkCell cell = (LabelAndHyperlinkCell)obj;
            return this.label.getText().equals(cell.label.getText()) && this.description.equals(cell.description);
        }

        @Override
        public int hashCode() {
            return this.label.getText().hashCode();
        }

        protected Object readResolve() throws ObjectStreamException {
            return new LabelAndHyperlinkCell(this.label.getText(), "", null);
        }

        public JLabel getLabel() {
            return this.label;
        }

        public void setLabel(JLabel label) {
            this.label = label;
        }

        private static class LabelAndHyperlinkRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = -872602276192708959L;
            private static final int LABEL_LINK_SEP = 5;

            public LabelAndHyperlinkRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(2);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lable = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!(table instanceof IsmTable)) {
                    return lable;
                }
                IsmTable ismTable = (IsmTable)table;
                if (value instanceof LabelAndHyperlinkCell) {
                    JPanel jPanel = new JPanel();
                    LabelAndHyperlinkCell cell = (LabelAndHyperlinkCell)value;
                    jPanel.setLayout(new BoxLayout(jPanel, 0));
                    jPanel.add(cell.label);
                    jPanel.add(Box.createHorizontalStrut(5));
                    jPanel.add(cell.linkLabel);
                    cell.label.setForeground(cell.labelColor);
                    if (ismTable.getCurRolloverRow() == row && ismTable.getCurRolloverColumn() == column) {
                        cell.linkLabel.setForeground(COLOR_AFTER_CLICK);
                    } else {
                        cell.linkLabel.setForeground(COLOR_MOUSE_OVER);
                    }
                    if (isSelected) {
                        jPanel.setBackground(table.getSelectionBackground());
                        if (Color.black.equals(cell.labelColor)) {
                            cell.label.setForeground(Color.white);
                        }
                    }
                    this.setBackGround(table, isSelected, row, jPanel);
                    return jPanel;
                }
                return lable;
            }
        }
    }

    public static class HyperlinkIconCell
    extends IsmTableCell {
        private static final long serialVersionUID = 1808112220086856741L;
        private static HyperlinkIconRenderer render = new HyperlinkIconRenderer();
        private String description;
        private String rolLink;
        private transient Icon icon = null;
        private String basicLink;
        private transient ActionListener acListener = null;

        public HyperlinkIconCell(String desc, Icon image, ActionListener action) {
            this.setDescription(desc);
            this.icon = image;
            this.acListener = action;
        }

        public final void setDescription(String desc) {
            this.description = null == desc ? "" : desc;
            this.rolLink = "<html><font color=#0068ff>" + this.description;
            this.basicLink = "<html><font color=#4286d3>" + this.description;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public ActionListener getAction() {
            return this.acListener;
        }

        @Override
        public String toString() {
            return this.description;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof HyperlinkIconCell)) {
                return 1;
            }
            String thisVal = this.description;
            String thatVal = ((HyperlinkIconCell)o).description;
            return thisVal.compareTo(thatVal);
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof HyperlinkIconCell)) {
                return false;
            }
            HyperlinkIconCell cell = (HyperlinkIconCell)obj;
            return this.description.equals(cell.description);
        }

        @Override
        public int hashCode() {
            return this.description.hashCode();
        }

        protected Object readResolve() throws ObjectStreamException {
            return new HyperlinkIconCell(this.description, this.icon, null);
        }

        private static class HyperlinkIconRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = -872602276192708959L;

            public HyperlinkIconRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(2);
            }

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lable = (JLabel)super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, column);
                if (!(jTable instanceof IsmTable)) {
                    return lable;
                }
                IsmTable ismTable = (IsmTable)jTable;
                if (value instanceof HyperlinkIconCell) {
                    HyperlinkIconCell cell = (HyperlinkIconCell)value;
                    if (ismTable.getCurRolloverRow() == row && ismTable.getCurRolloverColumn() == column) {
                        lable.setText(cell.rolLink);
                        lable.setIcon(cell.icon);
                    } else {
                        lable.setText(cell.basicLink);
                        lable.setIcon(cell.icon);
                    }
                }
                return lable;
            }
        }
    }

    public static class HyperlinkCell
    extends IsmTableCell {
        private static final long serialVersionUID = 1808111220086856741L;
        public static final Color ROLLOVER_COLOR = new Color(26879);
        public static final Color NORMAL_COLOR = new Color(4359891);
        private static HyperlinkRenderer render = new HyperlinkRenderer();
        private String descStr;
        private String rolloverHLink;
        private String normalHLink;
        private int wrapLine = 0;
        private transient ActionListener actionListener = null;
        private String tips;

        public HyperlinkCell(String desc, ActionListener action) {
            this(desc, action, 0);
        }

        public HyperlinkCell(String desc, ActionListener action, int wrapLine) {
            this.setDescription(desc);
            this.actionListener = action;
            this.wrapLine = wrapLine;
        }

        public HyperlinkCell(String desc) {
            this.descStr = null == desc ? "" : desc;
            this.rolloverHLink = "<html>" + this.descStr;
            this.normalHLink = "<html>" + this.descStr;
        }

        public final void setDescription(String desc) {
            this.setDescription(desc, null);
        }

        public final void setDescription(String desc, String norMalcolor) {
            this.descStr = null == desc ? "" : desc;
            this.rolloverHLink = "<html><font color=#0068ff>" + this.descStr;
            this.normalHLink = "<html><font color=" + (norMalcolor == null ? "#4286d3" : norMalcolor) + ">" + this.descStr;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public ActionListener getAction() {
            return this.actionListener;
        }

        @Override
        public String toString() {
            return this.descStr;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof HyperlinkCell)) {
                return -1;
            }
            String thisVal = this.descStr;
            String thatVal = ((HyperlinkCell)o).descStr;
            return thisVal.compareTo(thatVal);
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof HyperlinkCell)) {
                return false;
            }
            HyperlinkCell cell = (HyperlinkCell)obj;
            return this.descStr.equals(cell.descStr);
        }

        @Override
        public int hashCode() {
            return this.descStr.hashCode();
        }

        protected Object readResolve() throws ObjectStreamException {
            return new HyperlinkCell(this.descStr, null);
        }

        public int getWrapLine() {
            return this.wrapLine;
        }

        public String getDescStr() {
            return this.descStr;
        }

        public void setTips(String tip) {
            this.tips = tip;
        }

        public String getTips() {
            return this.tips;
        }

        private static class HyperlinkRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = -872602276192708959L;

            public HyperlinkRenderer() {
                this.setOpaque(true);
                this.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel lable = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!(table instanceof IsmTable)) {
                    return lable;
                }
                IsmTable ismTable = (IsmTable)table;
                if (value instanceof HyperlinkCell) {
                    String tip;
                    int width;
                    HyperlinkCell cell = (HyperlinkCell)value;
                    if (ismTable.getCurRolloverRow() == row && ismTable.getCurRolloverColumn() == column) {
                        if (cell.getWrapLine() > 0) {
                            width = this.getAvailableWidth(ismTable, column);
                            String showText = UCD.wrapTextWithHTML(lable.getFontMetrics(lable.getFont()), cell.getDescStr(), width > 15 ? width - 15 : width, cell.getWrapLine());
                            lable.setText(showText);
                            lable.setForeground(ROLLOVER_COLOR);
                        } else {
                            lable.setText(cell.rolloverHLink);
                        }
                    } else if (cell.getWrapLine() > 0) {
                        width = this.getAvailableWidth(ismTable, column);
                        String showText = UCD.wrapTextWithHTML(lable.getFontMetrics(lable.getFont()), cell.getDescStr(), width > 15 ? width - 15 : width, cell.getWrapLine());
                        lable.setText(showText);
                        lable.setForeground(NORMAL_COLOR);
                    } else {
                        lable.setText(cell.normalHLink);
                    }
                    if (null != cell.getColor()) {
                        lable.setBackground(cell.getColor());
                    }
                    if (!StringUtils.isNULLObjectOrNullStr(tip = cell.getTips())) {
                        lable.setToolTipText(tip);
                    }
                }
                return lable;
            }
        }
    }

    public static class IconCell
    extends IsmTableCell {
        private static final long serialVersionUID = 1808111220086856741L;
        private static IconRenderer render = new IconRenderer();
        private transient Comparable comparable;
        private transient Icon iconValue;
        private String descStr;
        private int textAlignValue = 11;
        private int cellAlignValue = 2;
        private transient ActionListener actionListener;

        public IconCell(Icon icon, String desc) {
            this(icon, desc, (Comparable)((Object)desc));
        }

        public IconCell(Icon icon, String desc, Comparable comp) {
            this.setIcon(icon);
            this.setDescription(desc);
            this.comparable = comp;
        }

        public IconCell(Icon icon, String desc, ActionListener action, int textAlign) {
            this(icon, desc, (Comparable)((Object)desc));
            this.actionListener = action;
            this.textAlignValue = textAlign;
        }

        public final void setIcon(Icon icon) {
            this.iconValue = icon;
        }

        public final void setDescription(String desc) {
            this.descStr = null == desc ? "" : desc;
        }

        @Override
        public ActionListener getAction() {
            if (null == this.actionListener) {
                return super.getAction();
            }
            return this.actionListener;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        public void setCellAlign(int align) {
            this.cellAlignValue = align;
        }

        @Override
        public String toString() {
            return this.descStr;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof IconCell)) {
                return -1;
            }
            Comparable thisVal = this.comparable;
            Comparable thatVal = ((IconCell)o).comparable;
            return thisVal.compareTo(thatVal);
        }

        protected Object readResolve() throws ObjectStreamException {
            return new IconCell(null, this.descStr, (Comparable)((Object)this.descStr));
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof IconCell)) {
                return false;
            }
            IconCell iconCell = (IconCell)obj;
            return this.comparable.equals(iconCell.comparable);
        }

        @Override
        public int hashCode() {
            return this.comparable.hashCode();
        }

        private static class IconRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 1838867602833336191L;

            public IconRenderer() {
                this.setOpaque(true);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!(table instanceof IsmTable)) {
                    return comp;
                }
                this.setValue(value, comp);
                return comp;
            }

            private void setValue(Object value, JLabel comp) {
                if (value instanceof IconCell) {
                    IconCell cell = (IconCell)value;
                    comp.setIcon(cell.iconValue);
                    comp.setText(cell.descStr);
                    comp.setHorizontalTextPosition(cell.textAlignValue);
                    comp.setHorizontalAlignment(cell.cellAlignValue);
                }
            }
        }
    }

    public static class CheckBoxCell
    extends IsmTableCell {
        private static final long serialVersionUID = 952142792300517820L;
        private static TableCellRenderer render = new CheckBoxRenderer();
        private static TableCellEditor editor = new CheckBoxEditor();
        private boolean selected;

        public CheckBoxCell(boolean isSelect) {
            this.selected = isSelect;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public TableCellEditor getEditor() {
            return editor;
        }

        @Override
        public String toString() {
            return "";
        }

        @Override
        public int compareTo(IsmTableCell o) {
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CheckBoxCell)) {
                return false;
            }
            CheckBoxCell that = (CheckBoxCell)obj;
            return this.selected == that.selected;
        }

        @Override
        public int hashCode() {
            return this.selected ? 1 : 0;
        }

        private static class CheckBoxRenderer
        implements TableCellRenderer {
            private static final long serialVersionUID = 1L;
            private JCheckBox checkBox;
            private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

            public CheckBoxRenderer() {
                this.checkBox = new JCheckBox();
                this.checkBox.setHorizontalAlignment(0);
                this.checkBox.setBorderPainted(true);
                this.checkBox.setOpaque(true);
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!(value instanceof CheckBoxCell)) {
                    return this.checkBox;
                }
                if (!(table instanceof IsmTable)) {
                    return this.checkBox;
                }
                CheckBoxCell cell = (CheckBoxCell)value;
                IsmTable ismTable = (IsmTable)table;
                this.checkBox.setEnabled(table.isEnabled());
                if (isSelected) {
                    this.checkBox.setBackground(table.getSelectionBackground());
                } else if (!table.isEnabled()) {
                    this.checkBox.setBackground(UIManager.getColor("Table.disabledBackgound"));
                } else if (ismTable.getCurRolloverRow() == row) {
                    this.checkBox.setBackground(UIManager.getColor("Table.rolloverColor"));
                } else if (row % 2 != 0) {
                    this.checkBox.setBackground(UIManager.getColor("Table.alternateRowColor"));
                } else {
                    this.checkBox.setBackground(UIManager.getColor("Table.backgound"));
                }
                this.checkBox.setSelected(cell.selected);
                this.checkBox.setBorder(this.noFocusBorder);
                return this.checkBox;
            }
        }

        static class CheckBoxEditor
        extends DefaultCellEditor {
            private static final long serialVersionUID = 1L;

            public CheckBoxEditor() {
                super(new JCheckBox());
                JCheckBox checkBox = (JCheckBox)this.getComponent();
                checkBox.setHorizontalAlignment(0);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.setValue(value);
                TableCellRenderer renderer = table.getCellRenderer(row, column);
                Component c = renderer.getTableCellRendererComponent(table, value, isSelected, true, row, column);
                if (c != null) {
                    this.editorComponent.setOpaque(true);
                    this.editorComponent.setBackground(c.getBackground());
                    if (c instanceof JComponent) {
                        this.editorComponent.setBorder(((JComponent)c).getBorder());
                    }
                } else {
                    this.editorComponent.setOpaque(false);
                }
                return this.editorComponent;
            }

            public void setValue(Object value) {
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (value instanceof String) {
                    selected = value.equals("true");
                } else if (value instanceof CheckBoxCell) {
                    selected = ((CheckBoxCell)value).isSelected();
                }
                ((JCheckBox)this.getComponent()).setSelected(selected);
            }
        }
    }

    public static class ProgressCell
    extends IsmTableCell {
        private static final long serialVersionUID = 2612835114424245620L;
        private static TableCellRenderer proRender = new ProgressCellRender();
        private static TableCellRenderer defRender = new IsmTableCellRenderer();
        private int progressValue = -1;
        private int maxProgress = 100;
        private String strProgress;

        public ProgressCell(int progress) {
            this.setProgress(progress);
        }

        public ProgressCell(int progress, int max) {
            this.maxProgress = max;
            this.setProgress(progress);
        }

        public final void setProgress(int progress) {
            this.progressValue = progress;
            if (this.isProgressValid()) {
                this.strProgress = String.valueOf(this.progressValue);
            } else {
                this.progressValue = -1;
            }
        }

        public final int getProgress() {
            return this.progressValue;
        }

        @Override
        public TableCellRenderer getRender() {
            if (this.isProgressValid()) {
                return proRender;
            }
            return defRender;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof ProgressCell)) {
                return -1;
            }
            int thisVal = this.progressValue;
            int thatVal = ((ProgressCell)o).progressValue;
            return thisVal < thatVal ? -1 : (thisVal == thatVal ? 0 : 1);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ProgressCell)) {
                return false;
            }
            ProgressCell that = (ProgressCell)obj;
            return this.progressValue == that.progressValue;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        private boolean isProgressValid() {
            return 0 <= this.progressValue && this.progressValue <= this.maxProgress;
        }

        @Override
        public String toString() {
            if (this.isProgressValid()) {
                return this.strProgress;
            }
            return "--";
        }

        private static class ProgressCellRender
        extends CustomTableCellRender {
            private static final long serialVersionUID = -5349538963044586067L;
            private JProgressBar progressBar = new JProgressBar();

            private ProgressCellRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.progressBar.setMinimumSize(new Dimension(1, 14));
                this.progressBar.setPreferredSize(new Dimension(this.progressBar.getPreferredSize().width, 14));
                if (value instanceof ProgressCell) {
                    ProgressCell cell = (ProgressCell)value;
                    this.progressBar.setMaximum(cell.maxProgress);
                    if (cell.isProgressValid()) {
                        this.progressBar.setStringPainted(true);
                        this.progressBar.setValue(cell.progressValue);
                    } else {
                        this.progressBar.setStringPainted(false);
                        this.progressBar.setValue(0);
                    }
                }
                JComponent renderedComp = this.renderComponent(this.progressBar);
                this.setBackGround(table, isSelected, row, renderedComp);
                return this.progressBar;
            }
        }
    }

    public static class DateCell
    extends IsmTableCell {
        private static final long serialVersionUID = 2908302654849526723L;
        private static TableCellRenderer render = new DateRenderer();
        private long dateValue;
        private String localDate;

        public DateCell(long date, TimeZone timeZone) {
            this.setDate(date, timeZone);
        }

        public DateCell(long date) {
            this(date, null);
        }

        public void setDate(long date, TimeZone timeZone) {
            if (date <= 0L) {
                this.localDate = "";
                this.dateValue = 0L;
            } else {
                this.localDate = TimeUtil.gmtToString(date, null != timeZone ? timeZone : TimeZone.getDefault());
                this.dateValue = date;
            }
        }

        public long getDate() {
            return this.dateValue;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public String toString() {
            return this.localDate;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof DateCell)) {
                return -1;
            }
            long thisVal = this.dateValue;
            long thatVal = ((DateCell)o).dateValue;
            return thisVal < thatVal ? -1 : (thisVal == thatVal ? 0 : 1);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DateCell)) {
                return false;
            }
            DateCell that = (DateCell)obj;
            return this.dateValue == that.dateValue;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        private static class DateRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 1L;

            private DateRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                DateCell cell = (DateCell)value;
                String txt = "";
                if (null != cell) {
                    txt = cell.localDate;
                    this.setText(txt);
                    this.setHorizontalAlignment(4);
                }
                return super.getTableCellRendererComponent(table, txt, isSelected, hasFocus, row, column);
            }
        }
    }

    public static class HexCell
    extends IsmTableCell {
        private static final long serialVersionUID = 1301099298444266359L;
        private static TableCellRenderer render = new HexRenderer();
        private long value;
        private String hexVal;

        public HexCell(long val) {
            this.setValue(val);
        }

        public void setValue(long val) {
            this.value = val;
            this.hexVal = "0x" + Long.toHexString(val).toUpperCase(ResourceManager.getLocale());
        }

        public long getValue() {
            return this.value;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public String toString() {
            return this.hexVal;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof HexCell)) {
                return -1;
            }
            long thisVal = this.value;
            long thatVal = ((HexCell)o).value;
            return thisVal < thatVal ? -1 : (thisVal == thatVal ? 0 : 1);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof HexCell)) {
                return false;
            }
            HexCell that = (HexCell)obj;
            return this.value == that.value;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        private static class HexRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 1L;

            private HexRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component ret;
                HexCell cell = (HexCell)value;
                String txt = "";
                if (null != cell) {
                    txt = cell.hexVal;
                    this.setText(txt);
                }
                if ((ret = super.getTableCellRendererComponent(table, txt, isSelected, hasFocus, row, column)) instanceof JLabel) {
                    JLabel label = (JLabel)ret;
                    label.setHorizontalAlignment(2);
                }
                return ret;
            }
        }
    }

    public static class MsgTextCell
    extends TextCell {
        private static final long serialVersionUID = 3339548415230346819L;
        private String emptyMsg;
        private static TableCellRenderer cellRenderer = new MsgTextCellRender();

        public MsgTextCell(JTextField textField, String value, String emptyMsg) {
            super(textField, value, null);
            this.emptyMsg = emptyMsg;
        }

        @Override
        public String toString() {
            return this.getValue() == null ? "" : this.getValue();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.emptyMsg == null ? 0 : this.emptyMsg.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof MsgTextCell)) {
                return false;
            }
            MsgTextCell other = (MsgTextCell)obj;
            return !(this.emptyMsg == null ? other.emptyMsg != null : !this.emptyMsg.equals(other.emptyMsg));
        }

        @Override
        public TableCellRenderer getRender() {
            return cellRenderer;
        }

        static class MsgTextCellRender
        extends TextCell.TextFieldRender {
            private static final long serialVersionUID = -2926896877368703316L;

            MsgTextCellRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component res = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof MsgTextCell && !isSelected) {
                    MsgTextCell cell = (MsgTextCell)value;
                    if (Utils.isNullStr(cell.getValue())) {
                        res = super.getTableCellRendererComponent(table, cell.emptyMsg, isSelected, hasFocus, row, column);
                        Font font = res.getFont();
                        res.setFont(new Font(font.getName(), 2, font.getSize()));
                        res.setForeground(Color.GRAY);
                    } else {
                        res.setForeground(Color.BLACK);
                    }
                }
                return res;
            }
        }
    }

    public static class MultiLineTextCell
    extends TextCell {
        private static final long serialVersionUID = 1L;
        private static final TableCellRenderer RENDERER = new MultiLinetextCellRender();
        private int line;

        public MultiLineTextCell(String value, int line) {
            super(value);
            this.line = line;
        }

        @Override
        public TableCellRenderer getRender() {
            return RENDERER;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.line;
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof MultiLineTextCell)) {
                return false;
            }
            MultiLineTextCell other = (MultiLineTextCell)obj;
            if (this.line != other.line) {
                return false;
            }
            if (this.getValue() == null) {
                return other.getValue() == null;
            }
            return this.getValue().equals(other.getValue());
        }

        static class MultiLinetextCellRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 1L;

            MultiLinetextCellRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!(value instanceof MultiLineTextCell)) {
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                MultiLineTextCell cell = (MultiLineTextCell)value;
                JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                int width = this.getAvailableWidth(table, column);
                String showText = UCD.wrapTextWithHTML(this.getFontMetrics(this.getFont()), cell.getValue(), width > 15 ? width - 15 : width, cell.getLine());
                comp.setText(showText);
                return comp;
            }
        }
    }

    public static class TextIconCell
    extends IsmTableCell {
        private static final long serialVersionUID = -5299829748480670107L;
        private static TableCellRenderer render = new TextIconRender();
        private transient Comparable comparable = null;
        private transient Icon iconImg = null;
        private String desc;
        private String tips;
        private int textPosition = 2;

        public TextIconCell(String desc, Icon iconImg) {
            this(desc, iconImg, (Comparable)((Object)desc));
        }

        public TextIconCell(String desc, Icon iconImg, int textPosition) {
            this(desc, iconImg, (Comparable)((Object)desc));
            this.textPosition = textPosition;
        }

        public TextIconCell(String desc, Icon iconImg, Comparable comp) {
            this.desc = desc;
            this.iconImg = iconImg;
            this.comparable = desc;
        }

        public void setTips(String tips) {
            this.tips = tips;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof TextIconCell)) {
                return -1;
            }
            Comparable thisVal = this.comparable;
            Comparable thatVal = ((TextIconCell)o).comparable;
            return thisVal.compareTo(thatVal);
        }

        @Override
        public String toString() {
            return this.desc;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return false;
            }
            if (!(obj instanceof TextIconCell)) {
                return false;
            }
            TextIconCell textIconCell = (TextIconCell)obj;
            return this.comparable.equals(textIconCell.comparable);
        }

        @Override
        public int hashCode() {
            return this.comparable.hashCode();
        }

        static class TextIconRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 1L;

            TextIconRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel comp = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!(table instanceof IsmTable)) {
                    return comp;
                }
                if (value instanceof TextIconCell) {
                    TextIconCell cell = (TextIconCell)value;
                    this.setValue(cell, comp);
                    if (null != cell.getColor()) {
                        comp.setBackground(cell.getColor());
                    }
                    if (!StringUtils.isNULLStr(cell.tips)) {
                        comp.setToolTipText(cell.tips);
                    }
                }
                return comp;
            }

            private void setValue(TextIconCell cell, JLabel comp) {
                comp.setIcon(cell.iconImg);
                comp.setText(cell.desc);
                comp.setHorizontalTextPosition(cell.textPosition);
            }
        }
    }

    public static class TextCell
    extends IsmTableCell {
        private static final long serialVersionUID = -5299829748480670107L;
        private static TableCellRenderer render = new TextCellRenderer();
        private static TableCellEditor editor = new TextEditor();
        private static TableCellRenderer customRender = new TextFieldRender();
        private boolean isEditableBool;
        private String valueStr;
        private transient Comparable comparable;
        private TableCellEditor customEditor = null;
        private transient ActionListener action = null;
        private JTextField customTextField;
        public static final int DEFAULT_H_ALIGNMENT = -1;
        private int horizontalAlignment = -1;

        public JTextField getCustomTextField() {
            return this.customTextField;
        }

        public void setCustomTextField(JTextField customTextField) {
            this.customTextField = customTextField;
        }

        public TextCell(Number num) {
            if (num.doubleValue() == -2.147483648E9 || -9.223372036854776E18 == num.doubleValue() || 4.294967295E9 == num.doubleValue()) {
                this.comparable = Double.valueOf(-1.0);
                this.valueStr = "--";
            } else {
                this.comparable = Double.valueOf(num.doubleValue());
                this.valueStr = num.toString();
            }
            this.isEditableBool = false;
        }

        public TextCell(String value) {
            this(value, false);
        }

        public TextCell(String value, boolean isEditable) {
            this(value, isEditable, -1);
        }

        public TextCell(String value, boolean isEditable, int horizontalAlignment) {
            this.valueStr = value;
            this.isEditableBool = isEditable;
            this.horizontalAlignment = horizontalAlignment;
        }

        public TextCell(String value, Comparable comp) {
            this(value);
            this.comparable = comp;
        }

        public TextCell(JTextField textField, String value, ActionListener action) {
            this(value, true);
            this.customTextField = textField;
            this.customEditor = new TextEditor(textField);
            this.action = action;
        }

        @Override
        public TableCellRenderer getRender() {
            if (null != this.customTextField) {
                return customRender;
            }
            return render;
        }

        @Override
        public TableCellEditor getEditor() {
            if (null != this.customTextField) {
                return this.customEditor;
            }
            if (this.isEditableBool) {
                return editor;
            }
            return null;
        }

        public void setEditor(TableCellEditor editor) {
            TextCell.setStaticEditor(editor);
        }

        private static void setStaticEditor(TableCellEditor editorParam) {
            editor = editorParam;
        }

        @Override
        public ActionListener getAction() {
            return this.action;
        }

        public void setText(String text) {
            this.valueStr = text;
            if (this.getEditor() != null) {
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)this.getEditor();
                JTextField textField = (JTextField)defaultCellEditor.getComponent();
                textField.setText(text);
            }
        }

        @Override
        public String toString() {
            if (Utils.isNullStr(this.valueStr)) {
                return "--";
            }
            return this.valueStr;
        }

        public String getValue() {
            return this.valueStr;
        }

        protected Object readResolve() throws ObjectStreamException {
            return new TextCell(this.valueStr, null);
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof TextCell)) {
                return -1;
            }
            TextCell that = (TextCell)o;
            if (null == this.comparable || null == ((TextCell)o).comparable) {
                String val1 = that.valueStr;
                String val2 = this.valueStr;
                if (null == val1 || null == val2) {
                    return -1;
                }
                return Collator.getInstance().compare(val2, val1);
            }
            Comparable thisVal = this.comparable;
            Comparable thatVal = that.comparable;
            return thisVal.compareTo(thatVal);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof TextCell)) {
                return false;
            }
            TextCell that = (TextCell)object;
            return this.valueStr.equals(that.valueStr);
        }

        @Override
        public int hashCode() {
            return this.valueStr.hashCode();
        }

        public int getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public void setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
        }

        public void setEditable(boolean flag) {
            this.customTextField.setEditable(flag);
        }

        static class TextEditor
        extends DefaultCellEditor {
            private static final long serialVersionUID = 1L;
            private TextCell currentCell;

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                return true;
            }

            public TextEditor(JTextField textField) {
                super(textField);
            }

            public TextEditor() {
                super(new JTextField());
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                String val = "";
                if (value instanceof TextCell) {
                    this.currentCell = (TextCell)value;
                    val = this.currentCell.valueStr;
                }
                ((JTextField)this.getComponent()).setText(val);
                return this.editorComponent;
            }

            @Override
            public boolean stopCellEditing() {
                boolean success = this.delegate.stopCellEditing();
                if (success) {
                    this.currentCell.valueStr = ((JTextField)this.getComponent()).getText();
                }
                return success;
            }
        }

        static class TextFieldRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 725238083212111020L;

            TextFieldRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (!(value instanceof TextCell)) {
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
                TextCell cell = (TextCell)value;
                if (!isSelected) {
                    Component component = super.getTableCellRendererComponent(table, cell.customTextField.getText(), isSelected, hasFocus, row, column);
                    if (component instanceof JLabel) {
                        JLabel label = (JLabel)component;
                        label.setHorizontalAlignment(cell.customTextField.getHorizontalAlignment());
                    }
                    return component;
                }
                return cell.customTextField;
            }
        }

        static class TextCellRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 1L;

            TextCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                TextCell cell;
                JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof TextCell && null != (cell = (TextCell)value).getColor()) {
                    comp.setBackground(cell.getColor());
                }
                return comp;
            }
        }
    }

    public static class TimeCell<T extends Number>
    extends IsmTableCell {
        private static final long serialVersionUID = 3593268772807062814L;
        private String strVal;
        private Long number;

        public TimeCell(T num, Unit.TimeUnit timeUnit) {
            this.number = (Long)Unit.convert(num, (Unit.Scaleble)timeUnit, (Unit.Scaleble)Unit.TimeUnit.SECOND);
            this.strVal = Unit.adaptTimeConvert(this.number, Unit.TimeUnit.SECOND);
        }

        @Override
        public TableCellRenderer getRender() {
            IsmTableCellRenderer renderer = new IsmTableCellRenderer(){
                private static final long serialVersionUID = 2674656577722047724L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    this.setHorizontalAlignment(4);
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
            return renderer;
        }

        @Override
        public String toString() {
            return this.strVal;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (o instanceof TimeCell) {
                return this.number.compareTo(((TimeCell)o).number);
            }
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TimeCell)) {
                return false;
            }
            TimeCell other = (TimeCell)obj;
            return this.strVal.equals(other.strVal);
        }

        @Override
        public int hashCode() {
            return this.number.hashCode();
        }
    }

    public static class EventTimeCell
    extends IsmTableCell {
        private static final long serialVersionUID = 5033845650388569377L;
        private Event event = null;
        private TimeZone zone = null;

        public EventTimeCell(Event event, TimeZone zone) {
            this.event = event;
            this.zone = zone;
        }

        @Override
        public TableCellRenderer getRender() {
            MycustIsmRender renderer = new MycustIsmRender();
            return renderer;
        }

        @Override
        public String toString() {
            Launcher launcher = CommonUtil.getLauncher(this.event.getIdentifier().getDeviceID());
            long timeLong = this.event.getStartTime();
            if (null != launcher && DeviceType.C3.equals((Object)launcher.getDevContext().getDeviceType())) {
                timeLong *= 1000L;
            }
            return TimeUtil.gmtToString(timeLong, this.zone);
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (o instanceof EventTimeCell) {
                EventTimeCell timeCell = (EventTimeCell)o;
                if (this.event.getStartTime() < timeCell.getEvent().getStartTime()) {
                    return -1;
                }
                if (this.event.getStartTime() == timeCell.getEvent().getStartTime()) {
                    if (this.event.getIdentifier().getEventSN() < timeCell.getEvent().getIdentifier().getEventSN()) {
                        return -1;
                    }
                    if (this.event.getIdentifier().getEventSN() == timeCell.getEvent().getIdentifier().getEventSN()) {
                        return 0;
                    }
                }
                return 1;
            }
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EventTimeCell)) {
                return false;
            }
            EventTimeCell other = (EventTimeCell)obj;
            return this.event.equals(other.getEvent());
        }

        @Override
        public int hashCode() {
            return this.event.hashCode();
        }

        public Event getEvent() {
            return this.event;
        }

        private static final class MycustIsmRender
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = -2742087459669157000L;

            private MycustIsmRender() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowNum, int columnNum) {
                this.setHorizontalAlignment(4);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowNum, columnNum);
            }
        }
    }

    public static class NumberCell<T extends Number>
    extends IsmTableCell {
        private static final long serialVersionUID = 1387989423412967555L;
        private static TableCellRenderer render = new NumberRenderer();
        private String strVal;
        private Double number;

        public NumberCell(T num) {
            this.number = ((Number)num).doubleValue();
            this.formatRenderValue(num);
        }

        public NumberCell(T num, String render) {
            this.number = ((Number)num).doubleValue();
            this.formatRenderValue(num);
            if (null != render && !render.isEmpty()) {
                this.strVal = render;
            }
        }

        public NumberCell(T num, Unit.DataUnit srcUnit) {
            this.number = Unit.convert(Double.valueOf(((Number)num).doubleValue()), (Unit.Scaleble)srcUnit, (Unit.Scaleble)Unit.DataUnit.BYTE);
            this.strVal = Unit.adaptConvert2(num, srcUnit);
        }

        public NumberCell(T num, Unit.DataUnit srcUnit, boolean needShowOldValue) {
            this.number = Unit.convert(Double.valueOf(((Number)num).doubleValue()), (Unit.Scaleble)srcUnit, (Unit.Scaleble)Unit.DataUnit.BYTE);
            this.strVal = needShowOldValue ? Unit.adaptConvert(num, srcUnit) : Unit.adaptConvert2(num, srcUnit);
        }

        public NumberCell(T num, Unit.Scaleble srcUnit, Unit.Scaleble targetUnit) {
            this.number = ((Number)Unit.convert(num, srcUnit, targetUnit)).doubleValue();
            this.strVal = this.number + " " + targetUnit.toString();
        }

        public NumberCell(T num, NumberUnit unit) {
            this(num);
            if (unit == NumberUnit.Percentage) {
                NumberFormat formater = NumberFormat.getPercentInstance();
                formater.setMaximumFractionDigits(2);
                this.strVal = formater.format(((Number)num).doubleValue() / 100.0);
            } else {
                this.strVal = this.strVal + unit.getValue();
            }
        }

        private void formatRenderValue(T num) {
            this.strVal = ((Number)num).doubleValue() == -2.147483648E9 || -9.223372036854776E18 == ((Number)num).doubleValue() || 4.294967295E9 == ((Number)num).doubleValue() ? "--" : num.toString();
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public String toString() {
            return this.strVal;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof NumberCell)) {
                return -1;
            }
            if (this.number != null) {
                Comparable com = CommonUtil.convertObject(this.number, Comparable.class);
                Double comToBe = CommonUtil.convertObject((Object)o, NumberCell.class).number;
                return com.compareTo(comToBe);
            }
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof NumberCell)) {
                return false;
            }
            NumberCell that = (NumberCell)obj;
            return this.strVal.equals(that.strVal);
        }

        @Override
        public int hashCode() {
            return this.number.hashCode();
        }

        private static class NumberRenderer
        extends IsmTableCellRenderer {
            private static final long serialVersionUID = 1L;

            private NumberRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component ret;
                this.setHorizontalAlignment(4);
                NumberCell cell = (NumberCell)value;
                String txt = "";
                if (null != cell) {
                    txt = cell.strVal;
                    this.setText(txt);
                }
                if ((ret = super.getTableCellRendererComponent(table, txt, isSelected, hasFocus, row, column)) instanceof JLabel) {
                    JLabel label = (JLabel)ret;
                    label.setHorizontalAlignment(4);
                }
                return ret;
            }
        }

        public static enum NumberUnit {
            Percentage("%"),
            SPEEDUNITG("Gb/s"),
            SPEEDUNITM("Mb/s"),
            SPEEDUNITK("Kb/s"),
            SPEEDUNITKB("(KBytes/s)"),
            SPEEDUNITMB("(MBytes/s)"),
            SPEEDUNITGB("(GBytes/s)");

            private String value = "";

            private NumberUnit(String unit) {
                this.value = unit;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    public static class SequenceNumberCell
    extends IsmTableCell {
        private static final long serialVersionUID = 1387985483412967555L;
        private static TableCellRenderer render = new SequenceNumberRenderer();
        private String strVal;
        private int indexValue;

        public SequenceNumberCell(int index) {
            this.setValue(index);
        }

        public void setValue(int index) {
            this.indexValue = index;
            this.strVal = String.valueOf(index);
        }

        public int getValue() {
            return this.indexValue;
        }

        @Override
        public TableCellRenderer getRender() {
            return render;
        }

        @Override
        public String toString() {
            return this.strVal;
        }

        @Override
        public int compareTo(IsmTableCell o) {
            if (!(o instanceof SequenceNumberCell)) {
                return -1;
            }
            int thisVal = this.indexValue;
            int thatVal = ((SequenceNumberCell)o).indexValue;
            if (thisVal > thatVal) {
                return 1;
            }
            if (thisVal < thatVal) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SequenceNumberCell)) {
                return false;
            }
            SequenceNumberCell that = (SequenceNumberCell)obj;
            return this.strVal.equals(that.strVal);
        }

        @Override
        public int hashCode() {
            return this.indexValue;
        }

        private static class SequenceNumberRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = 1L;

            private SequenceNumberRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.setHorizontalAlignment(0);
                this.setBackground(UIManager.getColor("IsmTableRowHeader.backgroud"));
                SequenceNumberCell cell = (SequenceNumberCell)value;
                String txt = "";
                if (null != cell) {
                    txt = cell.strVal;
                    this.setText(txt);
                }
                int availableWidth = table.getColumnModel().getColumn(column).getWidth();
                availableWidth = (int)((double)availableWidth - table.getIntercellSpacing().getWidth());
                Insets borderInsets = this.getBorder().getBorderInsets(this);
                String cellText = this.getText();
                FontMetrics fm = this.getFontMetrics(this.getFont());
                if (fm.stringWidth(cellText) > (availableWidth -= borderInsets.left + borderInsets.right)) {
                    this.setToolTipText(UCD.wrapTextWithHTML(fm, cellText, 300));
                } else {
                    this.setToolTipText(null);
                }
                return this;
            }
        }
    }
}

