/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.table;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import javax.swing.RowFilter;
import javax.swing.table.TableModel;

public class KeywordRowFilter
extends RowFilter<TableModel, Integer> {
    private int[] columns;
    private String keyFor;

    public KeywordRowFilter(String key, int ... columns) {
        this.columns = new int[columns.length];
        System.arraycopy(columns, 0, columns, 0, columns.length);
        this.keyFor = null == key ? "" : key.toLowerCase(ResourceManager.getLocale());
    }

    protected boolean include(RowFilter.Entry<? extends Object, ? extends Object> value, int index) {
        String content = value.getStringValue(index).toLowerCase(ResourceManager.getLocale());
        return content.contains(this.keyFor);
    }

    @Override
    public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
        int valueCount = entry.getValueCount();
        if (this.columns.length > 0) {
            int index = 0;
            for (int i = this.columns.length - 1; i >= 0; --i) {
                index = this.columns[i];
                if (index >= valueCount || !this.include(entry, index)) continue;
                return true;
            }
        } else {
            while (--valueCount >= 0) {
                if (!this.include(entry, valueCount)) continue;
                return true;
            }
        }
        return false;
    }
}

