/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressRegexDocument
extends PlainDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressRegexDocument.class);
    private static final long serialVersionUID = 6399790018053633024L;
    private transient Matcher matcher;
    private Pattern pattern;
    private int inputNumberimit;

    public AddressRegexDocument() {
    }

    public AddressRegexDocument(String regex, int inputNumberLimit) {
        this.inputNumberimit = inputNumberLimit;
        this.initial(regex);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        super.remove(offs, len);
    }

    @Override
    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        if (chng.getOffset() == 0) {
            String proposedInsert;
            try {
                proposedInsert = this.getText(chng.getLength(), chng.getDocument().getLength() - chng.getLength());
            }
            catch (BadLocationException e) {
                LOGGER.error("bad location exception:", (Throwable)e);
                return;
            }
            if (null != this.matcher && !proposedInsert.equals("")) {
                this.matcher.reset(proposedInsert);
                if (!this.matcher.matches()) {
                    return;
                }
            }
        }
        super.removeUpdate(chng);
    }

    @Override
    public void insertString(int offs, String newContent, AttributeSet attr) {
        try {
            String actualNewContent = newContent.replaceAll("\"", "");
            if (attr == null || !attr.isDefined(StyleConstants.ComposedTextAttribute)) {
                String proposedInsert;
                try {
                    proposedInsert = this.getText(0, offs) + actualNewContent + this.getText(offs, this.getLength() - offs);
                }
                catch (BadLocationException e1) {
                    LOGGER.error("BadLocationException", (Throwable)e1);
                    return;
                }
                if (proposedInsert.startsWith("-")) {
                    return;
                }
                if (this.inputNumberimit < proposedInsert.getBytes("UTF8").length) {
                    return;
                }
                if (null != this.matcher) {
                    this.matcher.reset(actualNewContent);
                    if (!this.matcher.matches()) {
                        return;
                    }
                }
            }
            super.insertString(offs, actualNewContent, attr);
        }
        catch (BadLocationException e) {
            LOGGER.error("bad location exception:", (Throwable)e);
            return;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("getBytes exception:", (Throwable)e);
        }
    }

    private void initial(String regex) {
        this.pattern = Pattern.compile(regex);
        try {
            this.matcher = this.pattern.matcher(this.getText(0, this.getLength()));
            if (!this.matcher.matches()) {
                this.remove(0, this.getLength());
            }
        }
        catch (BadLocationException badLocationException) {
            LOGGER.error("", (Throwable)badLocationException);
        }
    }
}

