/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.IsmGradientPanel;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.RolloverButton;
import com.huawei.ism.ui.swing.control.IsmGradientSeperator;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.unify.UnifyBorders;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextPane;
import com.huawei.ism.ui.templets.ArrayListGeter;
import com.huawei.ism.ui.templets.PropertyPaneAction;
import com.huawei.ism.ui.templets.TabPane;
import com.huawei.ism.ui.templets.TableMenuHandler;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTablePropertyPane
extends PropertyPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTablePropertyPane.class);
    private static final long serialVersionUID = 1L;
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private JComboBox subDeviceComboBox;
    private boolean isSubPaneFix;
    private boolean hasSubDevices;
    private IsmTable table;
    private TableScrollPane tablePanel;
    private JTabbedPane tabbedPane;
    private Box buttonBox;
    private ArrayListGeter arrayListGeter;
    private List<PropertyPaneAction> actionList = new ArrayList<PropertyPaneAction>(0);
    private DefaultTableModel topTableModel;
    private List<String> deviceIdentiferList = new LinkedList<String>();
    private List<TabPane> tabPaneList = new ArrayList<TabPane>(0);
    private List<String> allColumnNames = new ArrayList<String>(0);

    protected AbstractTablePropertyPane(boolean hasSubDevice, List<String> deviceIDList, boolean isSubPaneFixed, String[] columnNames, int ... visibleColumnIds) {
        this(hasSubDevice, deviceIDList, isSubPaneFixed, columnNames, new int[0], visibleColumnIds);
    }

    protected AbstractTablePropertyPane(boolean hasSubDevice, ArrayListGeter arrayGetter, boolean isSubPaneFixed, String[] columnNames, int ... visibleColumnIds) {
        this(hasSubDevice, arrayGetter, isSubPaneFixed, columnNames, new int[0], visibleColumnIds);
    }

    protected AbstractTablePropertyPane(boolean hasSubDevice, ArrayListGeter arrayGetter, boolean isSubPaneFixed, String[] columnNames, int[] visibleColumnIdsForever, int ... visibleColumnIds) {
        List<String> subArrayList;
        this.arrayListGeter = arrayGetter;
        if (null != arrayGetter && null != (subArrayList = arrayGetter.getArrayList())) {
            for (String id : subArrayList) {
                if (id == null) continue;
                this.deviceIdentiferList.add(id);
            }
        }
        this.init(hasSubDevice, isSubPaneFixed, columnNames, visibleColumnIdsForever, visibleColumnIds);
    }

    protected AbstractTablePropertyPane(boolean hasSubDevice, List<String> deviceIDList, boolean isSubPaneFixed, String[] columnNames, int[] visibleColumnIdsForever, int ... visibleColumnIds) {
        if (null != deviceIDList) {
            for (String id : deviceIDList) {
                if (id == null) continue;
                this.deviceIdentiferList.add(id);
            }
        }
        this.init(hasSubDevice, isSubPaneFixed, columnNames, visibleColumnIdsForever, visibleColumnIds);
    }

    private void init(boolean hasSubDevice, boolean isSubPaneFixed, String[] columnNames, int[] visibleColumnIdsForever, int ... visibleColumnIds) {
        this.hasSubDevices = hasSubDevice;
        if (null != columnNames) {
            for (String columnName : columnNames) {
                this.allColumnNames.add(columnName);
            }
        }
        this.isSubPaneFix = isSubPaneFixed;
        this.topTableModel = new DefaultTableModel(columnNames, visibleColumnIdsForever, visibleColumnIds);
        this.initComponents();
        this.initListeners();
    }

    private void updateCombox(List<String> arrayList) {
        List<String> exsitArrays = this.getExsitSubDevice();
        if (null != arrayList) {
            Pair<String, DeviceNameWraper> pair = null;
            for (String string : arrayList) {
                if (string == null || exsitArrays.contains(string)) continue;
                pair = new Pair<String, DeviceNameWraper>(string, new DeviceNameWraper(string));
                this.subDeviceComboBox.addItem(pair);
            }
        }
    }

    private List<String> getExsitSubDevice() {
        ArrayList<String> exsitSubDevices = new ArrayList<String>(0);
        if (null != this.subDeviceComboBox) {
            ComboBoxModel model = this.subDeviceComboBox.getModel();
            int size = model.getSize();
            Pair pair = null;
            for (int i = 0; i < size; ++i) {
                pair = (Pair)this.subDeviceComboBox.getItemAt(i);
                exsitSubDevices.add((String)pair.getKey());
            }
        }
        return exsitSubDevices;
    }

    public final void addButton(PropertyPaneAction ... actions) {
        if (null == actions || 0 == actions.length) {
            return;
        }
        RolloverButton button = null;
        for (PropertyPaneAction action : actions) {
            action.setDeviceID(this.getDeviceID());
            this.actionList.add(action);
            button = new RolloverButton(action);
            this.buttonBox.add(button);
        }
    }

    public final void addButton(JButton ... buttons) {
        if (null == buttons || 0 == buttons.length) {
            return;
        }
        for (JButton button : buttons) {
            this.buttonBox.add(button);
        }
    }

    public final void addGroupButton(String groupName, PropertyPaneAction ... actions) {
        Action[] propertyPaneActions = actions;
        RolloverButton button = new RolloverButton(groupName, propertyPaneActions);
        this.buttonBox.add(button);
        this.buttonBox.add(Box.createHorizontalStrut(12));
        for (PropertyPaneAction propertyPaneAction : actions) {
            propertyPaneAction.setDeviceID(this.getDeviceID());
            this.actionList.add(propertyPaneAction);
        }
    }

    public final void addGroupButton(String groupName, List<PropertyPaneAction> threeLevelActions, PropertyPaneAction ... actions) {
        Action[] propertyPaneActions = actions;
        RolloverButton button = new RolloverButton(groupName, threeLevelActions, propertyPaneActions);
        this.buttonBox.add(button);
        this.buttonBox.add(Box.createHorizontalStrut(12));
        for (PropertyPaneAction propertyPaneAction : actions) {
            propertyPaneAction.setDeviceID(this.getDeviceID());
            this.actionList.add(propertyPaneAction);
        }
        this.actionList.add(threeLevelActions.get(1));
    }

    public final void addGroupButtonAndAddListener(String groupName, ActionListener listener, PropertyPaneAction ... actions) {
        Action[] propertyPaneActions = actions;
        RolloverButton button = new RolloverButton(groupName, propertyPaneActions);
        button.addActionListener(listener);
        this.buttonBox.add(button);
        this.buttonBox.add(Box.createHorizontalStrut(12));
        for (PropertyPaneAction propertyPaneAction : actions) {
            propertyPaneAction.setDeviceID(this.getDeviceID());
            this.actionList.add(propertyPaneAction);
        }
    }

    public int getDeviceSize() {
        return this.deviceIdentiferList.size();
    }

    protected void updateProperty(List<TableRow> topRows, int updateMode, boolean refreshState) {
        if (!refreshState) {
            int selectedTabIndex = this.tabbedPane.getSelectedIndex();
            if (0 == updateMode || topRows.isEmpty()) {
                this.topTableModel.reset(topRows, this.table);
            } else {
                this.topTableModel.setTableData(topRows);
            }
            int count = this.tabbedPane.getTabCount();
            if (selectedTabIndex >= 0 && count > 0 && selectedTabIndex < count) {
                this.tabbedPane.setSelectedIndex(selectedTabIndex);
            }
        } else {
            this.topTableModel.removeAll();
            this.topTableModel.reset(topRows, this.table);
        }
        this.degradeForMethodUpdateProperty();
        if (this.topTableModel.getRowCount() > 0 && this.table.getSelectedRowCount() == 0 && updateMode != 1) {
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        }
        this.updateActions();
    }

    private void degradeForMethodUpdateProperty() {
        if (this.table.getSelectedRows().length == 1) {
            int modelIndex = this.table.convertRowIndexToModel(this.table.getSelectedRow());
            TableRow selectRow = this.topTableModel.getRow(modelIndex);
            this.updateSubPane(selectRow, false);
        } else {
            this.updateSubPane(null, false);
        }
    }

    protected void updateSubDeviceCombBox() {
        if (null == this.arrayListGeter) {
            return;
        }
        List<String> arrayLists = this.arrayListGeter.getArrayList();
        if (null != arrayLists && arrayLists.size() != this.deviceIdentiferList.size()) {
            this.deviceIdentiferList = arrayLists;
            this.updateCombox(this.deviceIdentiferList);
        }
    }

    protected abstract int getTabCount(TableRow var1);

    protected abstract List<TableRow> getTopTableRows();

    protected abstract String getTabNameAt(int var1, TableRow var2);

    protected abstract TabPane.TabType getTabTypeAt(int var1, TableRow var2);

    protected String[] getTableHeaderNamesAt(int tabIndex, TableRow source) {
        return new String[0];
    }

    protected int[] getVisbleTableColumnIDsAt(int tabIndex, TableRow source) {
        return new int[0];
    }

    protected List<Pair<String, IsmTextPane>> getPairDatasAt(int tabIndex, TableRow source) {
        if (0 == tabIndex) {
            ArrayList<Pair<String, IsmTextPane>> datas = new ArrayList<Pair<String, IsmTextPane>>(0);
            if (null == source) {
                return datas;
            }
            int columnCount = source.getColumnCount();
            if (this.allColumnNames.size() != columnCount) {
                return datas;
            }
            Object cellValue = null;
            String name = null;
            IsmTextPane label = null;
            for (int column = 0; column < columnCount; ++column) {
                cellValue = source.getValueAt(column);
                name = this.allColumnNames.get(column) + ':';
                if (cellValue instanceof IsmTextPane) {
                    label = (IsmTextPane)cellValue;
                    label.setEditable(false);
                    if (label.getText().trim().equals("")) {
                        label.setText("--");
                    }
                    datas.add(new Pair<String, IsmTextPane>(name, (IsmTextPane)cellValue));
                    continue;
                }
                if (null == cellValue || "".equals(cellValue.toString())) {
                    cellValue = "--";
                }
                label = new IsmTextPane(cellValue.toString());
                label.setEditable(false);
                datas.add(new Pair<String, IsmTextPane>(name, label));
            }
            return datas;
        }
        return new ArrayList<Pair<String, IsmTextPane>>(0);
    }

    protected TabPane getUserDefineTabPane(int tabIndex, TableRow source) {
        return null;
    }

    protected TabPane getTableTabPane(int tabIndex) {
        return null;
    }

    private void initComponents() {
        this.subDeviceComboBox = new JComboBox();
        this.subDeviceComboBox.setPreferredSize(new Dimension(150, 20));
        this.subDeviceComboBox.setMaximumSize(new Dimension(150, 20));
        this.subDeviceComboBox.setToolTipText(ResourceManager.getString("COMMON.TXT.SELECT_DEVICE"));
        this.updateCombox(this.deviceIdentiferList);
        this.tablePanel = this.createTablePane();
        JPanel toolBar = this.createToolBar();
        JPanel bottomPane = new JPanel(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabPlacement(1);
        this.tabbedPane.setMinimumSize(new Dimension(100, 200));
        JSplitPane splitPane = this.createSplitPane();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.blue) {
            bottomPane.add((Component)this.tabbedPane, "Center");
            bottomPane.setBorder(UCD.createEmptyBorder(8));
            splitPane.setTopComponent(this.tablePanel);
            splitPane.setBottomComponent(bottomPane);
        } else {
            splitPane.setDividerLocation(260);
            JPanel bottomBorderPane = this.createBorderPane();
            bottomPane.add((Component)bottomBorderPane, "North");
            bottomPane.add((Component)this.tabbedPane, "Center");
            bottomPane.setBorder(UnifyBorders.getScrollPaneBorder());
            JPanel topPane = new JPanel(new BorderLayout());
            JPanel topBorderPane = this.createBorderPane();
            topPane.add(this.tablePanel);
            topPane.add((Component)topBorderPane, "South");
            splitPane.setTopComponent(topPane);
            splitPane.setBottomComponent(bottomPane);
        }
        Box toolBarBox = Box.createVerticalBox();
        toolBarBox.add(Box.createHorizontalStrut(870));
        toolBarBox.add(toolBar);
        this.setLayout(new BorderLayout());
        this.add((Component)toolBarBox, "North");
        this.add((Component)splitPane, "Center");
        this.setBackground(Color.WHITE);
    }

    private TableScrollPane createTablePane() {
        this.table = new IsmTable(this.topTableModel);
        this.table.setSelectionMode(2);
        TableScrollPane tablePane = new TableScrollPane(this.table, true, true);
        tablePane.setMinimumSize(new Dimension(100, 80));
        tablePane.setOpaque(true);
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor || IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            tablePane.setBackground(Color.WHITE);
        } else {
            tablePane.setBackground(new Color(15725560));
        }
        return tablePane;
    }

    private JSplitPane createSplitPane() {
        JSplitPane splitPane = new JSplitPane(0);
        splitPane.setContinuousLayout(true);
        splitPane.setBorder(EMPTY_BORDER);
        splitPane.setResizeWeight(0.3);
        splitPane.setDividerLocation(250);
        return splitPane;
    }

    private JPanel createToolBar() {
        this.buttonBox = Box.createHorizontalBox();
        Box hBox = Box.createHorizontalBox();
        hBox.add(Box.createHorizontalStrut(8));
        hBox.add(this.buttonBox);
        hBox.add(Box.createGlue());
        if (this.hasSubDevices) {
            hBox.add(new JLabel(ResourceManager.getString("COMMON.TXT.ARRAY_FILTER") + ":"));
            hBox.add(Box.createHorizontalStrut(12));
            hBox.add(this.subDeviceComboBox);
            hBox.add(Box.createHorizontalStrut(8));
        }
        hBox.add(Box.createHorizontalStrut(8));
        hBox.add(Box.createRigidArea(new Dimension(0, 32)));
        JPanel toolPane = new IsmGradientPanel();
        toolPane.setLayout(new BorderLayout());
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor || IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
            toolPane = new JPanel();
            toolPane.setLayout(new BorderLayout());
            toolPane.setBackground(Color.WHITE);
            IsmGradientSeperator gradienPane = new IsmGradientSeperator();
            gradienPane.setOpaque(true);
            toolPane.add((Component)gradienPane, "South");
        }
        toolPane.add((Component)hBox, "Center");
        return toolPane;
    }

    private JPanel createBorderPane() {
        MyCustJPanell borderPane = new MyCustJPanell();
        UCD.setJComponentSize(borderPane, borderPane.getPreferredSize().width, 2);
        return borderPane;
    }

    private void updateActions() {
        int[] selectedRowIndics = this.table.getSelectedRows();
        ArrayList rowData = new ArrayList(0);
        TableRow row = null;
        for (int selectedRowIndic : selectedRowIndics) {
            row = this.topTableModel.getRow(this.table.convertRowIndexToModel(selectedRowIndic));
            rowData.add(row.getUserObject());
        }
        Object allPaneData = this.getAllPaneData();
        for (PropertyPaneAction action : this.actionList) {
            action.setUserObject(rowData);
            action.setAssocitedData("AssotiatedRow", allPaneData);
            action.setDeviceID(this.getDeviceID());
            action.update();
        }
    }

    protected Object getAllPaneData() {
        return null;
    }

    private void initListeners() {
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                TableMenuHandler.popMenu(mouseEvent, AbstractTablePropertyPane.this.actionList);
            }
        });
        this.subDeviceComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    if (AbstractTablePropertyPane.this.hasSubDevices) {
                        AbstractTablePropertyPane.this.subDeviceComboBox.repaint();
                    }
                    List<TableRow> topRows = AbstractTablePropertyPane.this.getTopTableRows();
                    AbstractTablePropertyPane.this.updateProperty(topRows, 0, false);
                }
            }
        });
        ListSelectionModel selectionModel = this.table.getSelectionModel();
        selectionModel.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (AbstractTablePropertyPane.this.table.isStructureChanged()) {
                    return;
                }
                AbstractTablePropertyPane.this.updateActions();
                if (AbstractTablePropertyPane.this.table.getSelectedRow() != -1 && AbstractTablePropertyPane.this.table.getSelectedRowCount() == 1) {
                    int modelIndex = AbstractTablePropertyPane.this.table.convertRowIndexToModel(AbstractTablePropertyPane.this.table.getSelectedRow());
                    TableRow selectRow = AbstractTablePropertyPane.this.topTableModel.getRow(modelIndex);
                    AbstractTablePropertyPane.this.updateSubPane(selectRow, true);
                } else {
                    AbstractTablePropertyPane.this.updateSubPane(null, true);
                }
            }
        });
    }

    private void updateSubPane(TableRow source, boolean refreshState) {
        if (null == source) {
            this.tabPaneList.clear();
            this.tabbedPane.removeAll();
            return;
        }
        int curTab = this.tabbedPane.getSelectedIndex();
        if (curTab < 0) {
            curTab = 0;
        }
        if (!this.isSubPaneFix && refreshState) {
            this.tabPaneList.clear();
            this.tabbedPane.removeAll();
        }
        if (this.tabPaneList.isEmpty()) {
            this.createSubPane(source);
        }
        for (TabPane tabPane : this.tabPaneList) {
            tabPane.setDatas(source);
        }
        if (this.tabPaneList.size() > curTab) {
            this.tabbedPane.setSelectedIndex(curTab);
        }
    }

    private void createSubPane(TableRow source) {
        int tabCount = this.getTabCount(source);
        String tabName = null;
        TabPane.TabType type = null;
        PairTabPane pairPane = null;
        TabPane tablePane = null;
        TabPane userDefinePane = null;
        block5: for (int i = 0; i < tabCount; ++i) {
            tabName = this.getTabNameAt(i, source);
            if (CommonUtil.isNullStr(tabName)) continue;
            type = this.getTabTypeAt(i, source);
            if (type == null) {
                LOGGER.error("get tab type failed . i =" + i + "  source=" + source);
                return;
            }
            switch (type) {
                case KVPair: {
                    pairPane = new PairTabPane(i);
                    this.tabbedPane.add(tabName, pairPane);
                    this.tabPaneList.add(pairPane);
                    continue block5;
                }
                case Table: {
                    tablePane = this.getTableTabPane(i);
                    this.tabbedPane.add(tabName, tablePane);
                    this.tabPaneList.add(tablePane);
                    continue block5;
                }
                case UserDefine: {
                    userDefinePane = this.getUserDefineTabPane(i, source);
                    this.tabbedPane.add(tabName, userDefinePane);
                    this.tabPaneList.add(userDefinePane);
                    continue block5;
                }
            }
        }
    }

    public Box getButtonBox() {
        return this.buttonBox;
    }

    public IsmTable getTable() {
        return this.table;
    }

    public DefaultTableModel getTopTableModel() {
        return this.topTableModel;
    }

    @Override
    public String getDeviceID() {
        Pair selectionItem;
        String selectionDeviceID = null;
        if (this.hasSubDevices && null != (selectionItem = (Pair)this.subDeviceComboBox.getSelectedItem())) {
            selectionDeviceID = (String)selectionItem.getKey();
        }
        if (null == selectionDeviceID && !this.deviceIdentiferList.isEmpty()) {
            selectionDeviceID = this.deviceIdentiferList.get(0);
        }
        return selectionDeviceID;
    }

    private static class DeviceNameWraper {
        private String deviceIdentifer;

        public DeviceNameWraper(String deviceID) {
            this.deviceIdentifer = deviceID;
        }

        public String toString() {
            if (null == this.deviceIdentifer) {
                return "";
            }
            return CommonUtil.getDeviceName(this.deviceIdentifer);
        }
    }

    protected class PairTabPane
    extends TabPane {
        private static final long serialVersionUID = 1L;
        private JPanel contentPane;

        public PairTabPane(int tabIndex) {
            super(tabIndex);
            this.contentPane = new JPanel();
            this.contentPane.setLayout(new BoxLayout(this.contentPane, 0));
            this.contentPane.setBackground(new Color(16119546));
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor || IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
                this.contentPane.setBackground(Color.WHITE);
            }
            JScrollPane scrollPane = new JScrollPane(this.contentPane);
            scrollPane.setOpaque(false);
            scrollPane.setBorder(new EmptyBorder(5, 16, 5, 5));
            this.add((Component)scrollPane, "Center");
        }

        @Override
        public void setDatas(TableRow source) {
            this.contentPane.removeAll();
            List<Pair<String, IsmTextPane>> pairs = AbstractTablePropertyPane.this.getPairDatasAt(this.getTabIndex(), source);
            int size = pairs.size();
            Dimension valDim = new Dimension(190, 20);
            JPanel leftPane = new JPanel();
            JPanel rightPane = new JPanel();
            this.setLayoutAndColor(leftPane);
            this.setLayoutAndColor(rightPane);
            GridBagConstraints leftGBC = this.getGridBagConstraint(0, 0.1);
            GridBagConstraints rightGBC = this.getGridBagConstraint(1, 0.4);
            Pair<String, IsmTextPane> pair = null;
            IsmTextPane keyLabel = null;
            IsmTextPane valLabel = null;
            for (int i = 0; i < size; ++i) {
                pair = pairs.get(i);
                keyLabel = new IsmTextPane(pair.getKey());
                this.setColor(keyLabel);
                valLabel = pair.getValue();
                this.setColor(valLabel);
                valLabel.setPreferredSize(valDim);
                if (i < size / 2) {
                    leftPane.add((Component)keyLabel, leftGBC);
                    leftPane.add((Component)valLabel, rightGBC);
                    continue;
                }
                rightPane.add((Component)keyLabel, leftGBC);
                rightPane.add((Component)valLabel, rightGBC);
            }
            this.setLayoutAndContentPanel(leftPane, rightPane);
        }

        private void setLayoutAndContentPanel(JPanel leftPane, JPanel rightPane) {
            JPanel kvPanel = new JPanel();
            this.setLayoutAndColor(kvPanel);
            GridBagConstraints gbcL = this.getGridBagConstraint(0, 1.0);
            GridBagConstraints gbcR = this.getGridBagConstraint(1, 1.0);
            kvPanel.add((Component)leftPane, gbcL);
            kvPanel.add((Component)rightPane, gbcR);
            JPanel contentPanel = new JPanel(){
                private static final long serialVersionUID = 3941083995006670990L;

                @Override
                public void scrollRectToVisible(Rectangle aRect) {
                }
            };
            this.setLayoutAndColor(contentPanel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            contentPanel.add((Component)kvPanel, gridBagConstraints);
            this.contentPane.add(contentPanel);
            this.contentPane.validate();
        }

        private void setLayoutAndColor(JPanel pane) {
            pane.setLayout(new GridBagLayout());
            this.setColor(pane);
        }

        private void setColor(JComponent component) {
            component.setBackground(new Color(16119546));
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor || IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
                component.setBackground(Color.WHITE);
            }
        }

        public GridBagConstraints getGridBagConstraint(int gridx, double wightx) {
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 12;
            constraints.fill = 2;
            constraints.gridx = gridx;
            constraints.weightx = wightx;
            return constraints;
        }
    }

    private static final class MyCustJPanell
    extends JPanel {
        private static final long serialVersionUID = 3935200735666046043L;

        private MyCustJPanell() {
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.unify) {
                this.setBackground(Color.WHITE);
            } else {
                this.setBackground(UIManager.getColor("IsmArmorStyle.BaseColor"));
            }
        }
    }
}

