/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.exception.IsmException;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.module.command.Command;
import com.huawei.ism.ui.module.command.CommandUtils;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.ui.templets.ValueChangeHandler;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.ValueMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TabbedDialog
extends IsmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TabbedDialog.class);
    private static final long serialVersionUID = -1308036266216227760L;
    private JTabbedPane tabbedPane;
    private Object initDatas;

    public TabbedDialog(Window parent, Object initDatas, boolean batchCommands) {
        this(parent, initDatas, batchCommands, 0);
    }

    public TabbedDialog(Window parent, Object initDatas, boolean batchCommands, int selectedTab) {
        super(parent, "", new IsmDialog.ECommonButton[0]);
        this.initDatas = initDatas;
        this.doLayoutUI();
        List<TabPagePane> tabPages = this.getTabPagePanes();
        this.doInitTask(tabPages);
        this.addTabPages(tabPages);
        this.setSelectedTab(selectedTab);
        this.addHandler(tabPages);
        this.beforeShow();
    }

    protected abstract List<TabPagePane> getTabPagePanes();

    protected Object getInitDatas() {
        return this.initDatas;
    }

    protected void doInitTask(List<TabPagePane> tabPages) {
        Assert.notNullList(tabPages);
        ArrayList<MyCustInitTask> tasks = new ArrayList<MyCustInitTask>(0);
        MyCustInitTask task = null;
        for (TabPagePane pagePane : tabPages) {
            task = new MyCustInitTask(pagePane);
            tasks.add(task);
        }
        List<?> results = AsyncExcutor.execute(this.getOwner(), tasks.toArray(new Callable[tasks.size()]));
        if (null == results) {
            return;
        }
        IsmException ismException = null;
        for (Object result : results) {
            if (!(result instanceof Exception)) continue;
            ismException = null;
            if (result instanceof IsmException) {
                ismException = (IsmException)result;
            } else {
                LOGGER.error("", result);
                ismException = new IsmException(-1L);
            }
            throw ismException;
        }
    }

    private void doLayoutUI() {
        this.tabbedPane = new PropertyTabbedPane();
        JPanel contentPane = UCD.createTransparentPane(new BorderLayout());
        contentPane.add((Component)this.tabbedPane, "Center");
        this.addContentPane(contentPane);
    }

    private void addTabPages(List<TabPagePane> tabPages) {
        Assert.notNullList(tabPages);
        for (TabPagePane pagePane : tabPages) {
            this.tabbedPane.add(pagePane.getTabName(), pagePane);
        }
    }

    private void addHandler(List<TabPagePane> tabPages) {
        for (TabPagePane pagePane : tabPages) {
            pagePane.addHandler();
        }
    }

    private void setSelectedTab(int selectedTab) {
        if (-1 == selectedTab) {
            return;
        }
        this.tabbedPane.setSelectedIndex(selectedTab);
    }

    @Override
    protected String getHelpKey() {
        TabPagePane page = (TabPagePane)this.tabbedPane.getSelectedComponent();
        return page.getHelpKey();
    }

    void valueChanged() {
        boolean changed = false;
        Component[] components = this.tabbedPane.getComponents();
        TabPagePane page = null;
        for (Component component : components) {
            page = (TabPagePane)component;
            changed |= page.getValueMonitor().isValueChanged();
        }
        this.setButtonState(IsmDialog.ECommonButton.Apply, changed);
    }

    @Override
    protected void doApplyTask() {
        if (!this.passPreCheck()) {
            return;
        }
        if (!this.doSendTask()) {
            return;
        }
        super.setButtonState(IsmDialog.ECommonButton.Apply, false);
        Component[] components = this.tabbedPane.getComponents();
        TabPagePane page = null;
        for (Component component : components) {
            page = (TabPagePane)component;
            page.getValueMonitor().flushValue();
        }
    }

    @Override
    protected final void doConfirmTask() {
        if (this.getButtonBy(IsmDialog.ECommonButton.Apply).isEnabled()) {
            if (!this.passPreCheck()) {
                return;
            }
            if (!this.doSendTask()) {
                return;
            }
        }
        this.doCloseTask();
    }

    protected boolean doSendTask() {
        List<Command> commands = this.getAllCommands();
        if (commands.isEmpty()) {
            return true;
        }
        AsyncExcutor.execute((Window)this, commands.toArray(new Command[commands.size()]));
        this.afterCommandsExecuted(commands);
        return CommandUtils.isSucceededWith(commands);
    }

    protected boolean passPreCheck() {
        boolean passed = true;
        Component[] components = this.tabbedPane.getComponents();
        TabPagePane page = null;
        boolean pageCheckResult = false;
        for (Component component : components) {
            page = (TabPagePane)component;
            pageCheckResult = page.passPreCheck();
            if (pageCheckResult) continue;
            passed = false;
            break;
        }
        return passed;
    }

    protected List<Command> getAllCommands() {
        ArrayList<Command> commands = new ArrayList<Command>(0);
        Component[] components = this.tabbedPane.getComponents();
        TabPagePane page = null;
        List<Command> pageCommands = null;
        for (Component component : components) {
            page = (TabPagePane)component;
            pageCommands = page.getCommands();
            if (pageCommands.isEmpty()) continue;
            commands.addAll(pageCommands);
        }
        return commands;
    }

    protected void afterCommandsExecuted(List<Command> commands) {
    }

    public static abstract class TabPagePane
    extends JPanel
    implements ValueChangeHandler.IValueChangeListener {
        private ValueMonitor valueMonitor = new ValueMonitor();
        private ValueChangeHandler handler = new ValueChangeHandler();

        public TabPagePane() {
            this.handler.addValueChangeListener(this);
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            JComponent contentPane = this.getContentPane();
            Assert.notNull(contentPane);
            contentPane.setBorder(UCD.createEmptyBorder(3));
            this.add((Component)contentPane, "Center");
        }

        protected abstract String getTabName();

        protected abstract JComponent getContentPane();

        protected abstract boolean doInitTask() throws IsmException;

        protected abstract void addHandler();

        protected boolean passPreCheck() {
            return true;
        }

        protected String getHelpKey() {
            return null;
        }

        protected final ValueMonitor getValueMonitor() {
            return this.valueMonitor;
        }

        @Override
        public final void valueChanged() {
            Window window = this.getOwnerWindow();
            if (window instanceof TabbedDialog) {
                TabbedDialog dlg = (TabbedDialog)window;
                dlg.valueChanged();
            }
        }

        protected final Window getOwnerWindow() {
            Window ownerDlg = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
            return ownerDlg;
        }

        protected List<Command> getCommands() {
            return Collections.emptyList();
        }

        protected void monitorEventSource(JComponent source, ValueMonitor.IValueParser<JComponent, ?> parser) {
            Assert.notNull(parser);
            this.valueMonitor.addCheckpoint(source, parser);
            this.handler.addEventSource(source);
        }

        protected void monitorEventSource(JComponent ... sources) {
            Assert.notNull(sources);
            for (JComponent source : sources) {
                this.valueMonitor.addCheckpoint(source);
                this.handler.addEventSource(source);
            }
        }
    }

    private static final class PropertyTabbedPane
    extends JTabbedPane {
        private static final long serialVersionUID = -6395600681122125142L;

        private PropertyTabbedPane() {
        }

        @Override
        public void setSelectedIndex(int index) {
            int selectedIndex = this.getSelectedIndex();
            if (-1 == selectedIndex) {
                super.setSelectedIndex(index);
                return;
            }
            TabPagePane page = (TabPagePane)this.getSelectedComponent();
            if (!page.passPreCheck()) {
                return;
            }
            super.setSelectedIndex(index);
            ((TabPagePane)this.getSelectedComponent()).setFocusable(false);
        }
    }

    private static final class MyCustInitTask
    implements Callable<Boolean> {
        private final TabPagePane pagePane;

        private MyCustInitTask(TabPagePane pagePane) {
            this.pagePane = pagePane;
        }

        @Override
        public Boolean call() {
            return this.pagePane.doInitTask();
        }
    }
}

