/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.templets.AbstractTablePropertyPane;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class TabbedPropertyPane
extends PropertyPane {
    private static final long serialVersionUID = 1L;
    private String deviceID;
    private List<PropertyPane> subPropertyPanes;
    private JTabbedPane tabbedPane;
    private boolean isInited = false;

    public TabbedPropertyPane(String deviceID) {
        this.deviceID = deviceID;
        this.subPropertyPanes = new LinkedList<PropertyPane>();
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setBorder(new EmptyBorder(8, -1, 0, 0));
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            this.tabbedPane.setBorder(new EmptyBorder(-1, -1, -1, -1));
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPane, "Center");
        this.setBackground(Color.WHITE);
    }

    protected abstract Pair<String, PropertyPane> getTabPane(int var1);

    protected abstract int getTabCount();

    @Override
    public String getDeviceID() {
        return this.deviceID;
    }

    @Override
    public final void updateProperty(int updateMode) {
        if (!this.isInited) {
            this.init();
            this.isInited = true;
        }
        PropertyPane subPropertyPane = (PropertyPane)this.tabbedPane.getSelectedComponent();
        subPropertyPane.updateProperty(updateMode);
    }

    public final void init() {
        int tabCount = this.getTabCount();
        this.subPropertyPanes.clear();
        this.tabbedPane.removeAll();
        Pair<String, PropertyPane> pair = null;
        String tabName = null;
        PropertyPane tabPane = null;
        for (int i = 0; i < tabCount; ++i) {
            pair = this.getTabPane(i);
            if (null == pair) continue;
            tabName = pair.getKey();
            tabPane = pair.getValue();
            if (tabPane != null && IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
                tabPane.setDrawBorderMark(false);
                tabPane.setBorder(UCD.createEmptyBorder(0));
            }
            if (null == tabName || null == tabPane) continue;
            this.subPropertyPanes.add(tabPane);
            this.tabbedPane.addTab(tabName, tabPane);
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AbstractTablePropertyPane subPropertyPane = (AbstractTablePropertyPane)TabbedPropertyPane.this.tabbedPane.getSelectedComponent();
                subPropertyPane.updateProperty(1);
            }
        });
    }
}

