/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.util.Assert;
import com.huawei.ism.util.CommonUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;

public final class ValueChangeHandler
extends MouseAdapter
implements ActionListener,
ItemListener,
ChangeListener,
CaretListener,
TableModelListener,
ListDataListener,
PropertyChangeListener {
    private Collection<IValueChangeListener> vcListeners = new ArrayList<IValueChangeListener>(0);
    private List<JComponent> eventSouces = new ArrayList<JComponent>(0);

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireValueChanged();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireValueChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireValueChanged();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.fireValueChanged();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.fireValueChanged();
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.fireValueChanged();
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.fireValueChanged();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.fireValueChanged();
    }

    public void addEventSource(JComponent source) {
        if (this.eventSouces.contains(source)) {
            return;
        }
        if (source instanceof JTextComponent) {
            JTextComponent textSource = CommonUtil.convertObject(source, JTextComponent.class);
            textSource.addCaretListener(this);
            textSource.addPropertyChangeListener("enabled", this);
            this.eventSouces.add(source);
        } else if (source instanceof JToggleButton) {
            JToggleButton btnSource = CommonUtil.convertObject(source, JToggleButton.class);
            btnSource.addItemListener(this);
            btnSource.addPropertyChangeListener("enabled", this);
            this.eventSouces.add(source);
        } else if (source instanceof JComboBox) {
            JComboBox comboBoxSource = CommonUtil.convertObject(source, JComboBox.class);
            comboBoxSource.addItemListener(this);
            comboBoxSource.addPropertyChangeListener("enabled", this);
            this.eventSouces.add(source);
        } else if (source instanceof JList) {
            JList listSource = CommonUtil.convertObject(source, JList.class);
            listSource.getModel().addListDataListener(this);
            listSource.addPropertyChangeListener("enabled", this);
            this.eventSouces.add(source);
        } else if (source instanceof JTable) {
            JTable tableSource = CommonUtil.convertObject(source, JTable.class);
            tableSource.getModel().addTableModelListener(this);
            tableSource.addPropertyChangeListener("enabled", this);
            this.eventSouces.add(source);
        } else if (source instanceof JSpinner) {
            JSpinner spinner = CommonUtil.convertObject(source, JSpinner.class);
            spinner.getModel().addChangeListener(this);
            spinner.addPropertyChangeListener("enabled", this);
            this.eventSouces.add(source);
        } else if (source instanceof JSlider) {
            JSlider slider = CommonUtil.convertObject(source, JSlider.class);
            slider.getModel().addChangeListener(this);
            slider.addPropertyChangeListener("enabled", this);
            this.eventSouces.add(source);
        }
    }

    public void addValueChangeListener(IValueChangeListener ... changeListeners) {
        Assert.notNullArray(changeListeners);
        this.vcListeners.addAll(Arrays.asList(changeListeners));
    }

    private void fireValueChanged() {
        for (IValueChangeListener listener : this.vcListeners) {
            listener.valueChanged();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.fireValueChanged();
    }

    public static interface IValueChangeListener {
        public void valueChanged();
    }
}

