/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.mainframe.device;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.entity.Type;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.control.ImgsAssembledPane;
import com.huawei.ism.ui.swing.dialog.ConfirmDialog;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.ui2.mainframe.device.DevicePane;
import com.huawei.ism.ui2.mainframe.device.FeatureModulePane;
import com.huawei.ism.ui2.module.featuremanager.FeatureItem;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.LicenseUtils;
import com.huawei.ism.util.NetUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class FeatureGroupPane
extends FeatureModulePane {
    private static final long serialVersionUID = -7702212186089377845L;
    private List<ItemPane> allItemPanes = new ArrayList<ItemPane>(0);

    public FeatureGroupPane(String deviceID) {
        super(deviceID);
        this.doLayoutUI();
        SwingUtil.setName(this);
    }

    private void doLayoutUI() {
        int groupMargin = 20;
        Box taskItemsBox = Box.createVerticalBox();
        List<TaskGroup> taskGroups = this.getTaskGroups();
        TaskGroupPane itemGroupPan = null;
        for (TaskGroup taskGroup : taskGroups) {
            itemGroupPan = new TaskGroupPane(this.getDeviceID(), taskGroup);
            taskItemsBox.add(itemGroupPan);
            taskItemsBox.add(Box.createVerticalStrut(20));
        }
        Box featureItemsBox = Box.createVerticalBox();
        List<ItemGroup> itemGroups = this.getItemGroups();
        int group = 0;
        String title = null;
        ItemGroupPane itemGroupPane = null;
        for (ItemGroup itemGroup : itemGroups) {
            ++group;
            if (taskGroups.isEmpty() && 1 == itemGroups.size()) {
                itemGroup.setTitle(null);
            }
            if (null == (title = itemGroup.getTitle()) || title.isEmpty()) {
                featureItemsBox.add(Box.createVerticalStrut(20));
            }
            itemGroupPane = new ItemGroupPane(itemGroup);
            featureItemsBox.add(itemGroupPane);
            this.allItemPanes.addAll(itemGroupPane.getItemPanes());
            if (group != itemGroups.size()) continue;
            featureItemsBox.add(Box.createVerticalStrut(20));
        }
        featureItemsBox.add(Box.createVerticalGlue());
        JPanel contentPane = UCD.createBoxLayoutPane(1);
        contentPane.add(taskItemsBox);
        contentPane.add(featureItemsBox);
        contentPane.add(Box.createVerticalGlue());
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.add((Component)contentPane, "North");
    }

    public void refreshLicense() {
        for (ItemPane itemPane : this.allItemPanes) {
            itemPane.doLayoutUI();
        }
    }

    @Override
    public void updateProperty(int updateMode) {
        if (0 == updateMode) {
            super.updateProperty(updateMode);
            this.refreshLicense();
        }
    }

    protected List<ItemGroup> getItemGroups() {
        return new ArrayList<ItemGroup>(0);
    }

    protected List<TaskGroup> getTaskGroups() {
        return new ArrayList<TaskGroup>(0);
    }

    private static class TaskPane
    extends JPanel {
        private static final long serialVersionUID = 7110275738166313481L;
        private transient TaskItem task;

        public TaskPane(TaskItem task) {
            this.task = task;
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            JLabel nameLabel = new JLabel(this.task.getName(), 10);
            TaskNameHandler handler = new TaskNameHandler();
            nameLabel.addMouseListener(handler);
            nameLabel.setFont(new Font("Dialog", 1, 14));
            nameLabel.setIcon(this.task.getIcon());
            this.setLayout(new BorderLayout());
            this.add((Component)UCD.buildHBoxLeft(nameLabel), "Center");
            this.setBorder(new EmptyBorder(0, 40, 0, 0));
            this.setOpaque(false);
        }

        private final class TaskNameHandler
        extends MouseAdapter {
            private TaskNameHandler() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TaskPane.this.task.getAction().actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, null));
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                JComponent label = (JComponent)mouseEvent.getSource();
                label.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                JComponent label = (JComponent)mouseEvent.getSource();
                label.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private static class ItemPane
    extends JPanel
    implements MouseListener {
        private static final long serialVersionUID = 7146422497808923729L;
        private static final ImageIcon LEFT_BG_ICON = ResourceManager.getImage("itempane_leftBG.png");
        private static final ImageIcon CENTER_BG_ICON = ResourceManager.getImage("itempane_centerBG.png");
        private static final ImageIcon RIGHT_BG_ICON = ResourceManager.getImage("itempane_rightBG.png");
        private transient FeatureItem featureItem;
        private boolean isRollover = false;

        public ItemPane(FeatureItem featureItem) {
            this.featureItem = featureItem;
            this.doLayoutUI();
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, LEFT_BG_ICON.getIconHeight()));
            this.setOpaque(false);
        }

        public void doLayoutUI() {
            ImageIcon imageIcon = this.featureItem.getNormalIcon();
            JLabel iconLabel = new JLabel(imageIcon);
            JLabel nameLabel = new JLabel(this.featureItem.getName());
            nameLabel.setFont(new Font("Dialog", 1, 14));
            IsmTextArea detailsLabel = UCD.createTextArea(this.featureItem.getDetails());
            JPanel rightInfoPane = UCD.createTransparentPane(new BorderLayout(4, 0));
            rightInfoPane.add((Component)nameLabel, "North");
            rightInfoPane.add((Component)detailsLabel, "Center");
            JPanel itemPane = UCD.createTransparentPane(new BorderLayout(8, 0));
            itemPane.add((Component)UCD.buildVBoxTop(iconLabel), "West");
            itemPane.add((Component)rightInfoPane, "Center");
            this.initiLicenseState(itemPane);
            List<Type.LicenseFuncFeatureType> types = this.featureItem.getLicenseFeature();
            String msg = LicenseUtils.partialExisted(this.featureItem.getDeviceID(), types);
            if (null != msg) {
                Icon diabledIcon = UIManager.getLookAndFeel().getDisabledIcon(iconLabel, imageIcon);
                iconLabel.setIcon(diabledIcon);
                nameLabel.setEnabled(false);
                detailsLabel.setEnabled(false);
                this.setEnabled(false);
                this.setTooltip(iconLabel, nameLabel, detailsLabel, msg);
            } else {
                this.setEnabled(true);
                msg = LicenseUtils.overdue(this.featureItem.getDeviceID(), types);
                if (null != msg) {
                    this.setTooltip(iconLabel, nameLabel, detailsLabel, msg);
                }
                iconLabel.addMouseListener(this);
                nameLabel.addMouseListener(this);
                detailsLabel.addMouseListener(this);
            }
        }

        private void initiLicenseState(JPanel itemPane) {
            this.setToolTipText(null);
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add((Component)itemPane, "Center");
            this.setBorder(new EmptyBorder(15, 40, 10, 40));
        }

        private void setTooltip(JLabel iconLabel, JLabel nameLabel, JTextArea detailsLabel, String msg) {
            this.setToolTipText(msg);
            iconLabel.setToolTipText(msg);
            nameLabel.setToolTipText(msg);
            detailsLabel.setToolTipText(msg);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            List<Type.LicenseFuncFeatureType> types = this.featureItem.getLicenseFeature();
            String msg = LicenseUtils.partialExisted(this.featureItem.getDeviceID(), types);
            if (null != msg) {
                return;
            }
            if (null != this.featureItem.getAction()) {
                this.featureItem.getAction().actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, null));
            } else if (this.featureItem.isURLLink()) {
                NetUtil.browseURL(this.featureItem.getURLLink());
            } else {
                this.openPane(mouseEvent);
            }
        }

        private void openPane(MouseEvent mouseEvent) {
            boolean confirm;
            DevicePane devicePane = (DevicePane)SwingUtilities.getAncestorOfClass(DevicePane.class, this);
            if (null == devicePane) {
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(mouseEvent.getComponent());
            List<Type.LicenseFuncFeatureType> types = this.featureItem.getLicenseFeature();
            String msg = LicenseUtils.toBeOverdue(this.featureItem.getDeviceID(), types);
            if (null != msg && !(confirm = ConfirmDialog.showDialog(window, ConfirmDialog.Level.WARNING, msg, "", "", ""))) {
                return;
            }
            FeatureGroupPane groupPane = (FeatureGroupPane)SwingUtilities.getAncestorOfClass(FeatureGroupPane.class, this);
            this.featureItem.setParent(groupPane.getFeatureItem());
            devicePane.setFeaturePane(this.featureItem);
            this.isRollover = false;
            this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            Cursor handCursor = Cursor.getPredefinedCursor(12);
            this.setCursor(handCursor);
            this.isRollover = true;
            this.repaint();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setCursor(Cursor.getDefaultCursor());
            this.isRollover = false;
            this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (!this.isRollover || !this.isEnabled()) {
                super.paintComponent(graphics);
                return;
            }
            int w = this.getWidth();
            graphics.drawImage(LEFT_BG_ICON.getImage(), 0, 0, LEFT_BG_ICON.getIconWidth(), LEFT_BG_ICON.getIconHeight(), this);
            graphics.drawImage(CENTER_BG_ICON.getImage(), LEFT_BG_ICON.getIconWidth(), 0, w - LEFT_BG_ICON.getIconWidth() - RIGHT_BG_ICON.getIconWidth(), CENTER_BG_ICON.getIconHeight(), this);
            graphics.drawImage(RIGHT_BG_ICON.getImage(), w - RIGHT_BG_ICON.getIconWidth(), 0, RIGHT_BG_ICON.getIconWidth(), RIGHT_BG_ICON.getIconHeight(), this);
        }
    }

    public static class TaskGroupPane
    extends JPanel {
        private static final long serialVersionUID = 1259355185658846100L;
        private transient TaskGroup taskGroup;
        private String deviceID;

        public TaskGroupPane(String deviceID, TaskGroup taskGroup) {
            this.taskGroup = taskGroup;
            this.deviceID = deviceID;
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.setOpaque(false);
            List<TaskItem> items = this.taskGroup.getItems();
            JPanel itemsPane = null;
            itemsPane = items.size() < 3 ? UCD.createTransparentPane(new GridLayout(0, items.size(), 15, 15)) : UCD.createTransparentPane(new GridLayout(0, 3, 15, 15));
            itemsPane.setBorder(new EmptyBorder(5, 15, 0, 15));
            BaseAction action = null;
            TaskPane itemPane = null;
            for (TaskItem item : this.taskGroup.getItems()) {
                action = item.getAction();
                if (null != action) {
                    action.setDeviceID(this.deviceID);
                }
                itemPane = new TaskPane(item);
                itemsPane.add(itemPane);
            }
            String title = this.taskGroup.getTitle();
            JLabel groupTitleLabel = new JLabel();
            groupTitleLabel.setFont(new Font("Dialog", 1, 12));
            groupTitleLabel.setText(title);
            Box titleBox = UCD.buildHBoxLeft(groupTitleLabel);
            titleBox.setBorder(new EmptyBorder(5, 15, 0, 0));
            int width = groupTitleLabel.getPreferredSize().width;
            ImgsAssembledPane.HorizonalSeparator seperator = new ImgsAssembledPane.HorizonalSeparator();
            seperator.setPreferredWidth(width + 300);
            Box northBox = UCD.buildVBoxTop(5, titleBox, UCD.buildHBoxLeft(seperator));
            this.setLayout(new BorderLayout());
            this.add((Component)northBox, "North");
            this.add((Component)UCD.layComponentToTop(itemsPane), "Center");
        }
    }

    private static class ItemGroupPane
    extends JPanel {
        private static final long serialVersionUID = 1259355185658846100L;
        private List<ItemPane> itemPanes = new ArrayList<ItemPane>(0);
        private transient ItemGroup itemGroup;

        public ItemGroupPane(ItemGroup itemGroup) {
            this.itemGroup = itemGroup;
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            JPanel itemsPane = UCD.createBoxLayoutPane(1);
            itemsPane.setBorder(new EmptyBorder(5, 15, 0, 15));
            int count = 0;
            GridLayout gridLayout = new GridLayout(0, 2, 0, 0);
            JPanel rowPane = UCD.createTransparentPane(gridLayout);
            itemsPane.add(rowPane);
            ItemPane itemPane = null;
            for (FeatureItem item : this.itemGroup.getItems()) {
                ++count;
                itemPane = new ItemPane(item);
                rowPane.add(itemPane);
                this.itemPanes.add(itemPane);
                if (2 != count) continue;
                count = 0;
                rowPane = UCD.createTransparentPane(gridLayout);
                itemsPane.add(rowPane);
            }
            Box northBox = null;
            String title = this.itemGroup.getTitle();
            if (null != title && !title.isEmpty()) {
                JLabel groupTitleLabel = new JLabel();
                groupTitleLabel.setFont(new Font("Dialog", 1, 12));
                groupTitleLabel.setText(title);
                Box titleBox = UCD.buildHBoxLeft(groupTitleLabel);
                titleBox.setBorder(new EmptyBorder(5, 15, 0, 0));
                ImgsAssembledPane.HorizonalSeparator seperator = new ImgsAssembledPane.HorizonalSeparator();
                northBox = UCD.buildVBoxTop(5, titleBox, seperator);
            }
            this.setLayout(new BorderLayout());
            if (null != northBox) {
                this.add(northBox, "North");
            }
            this.add((Component)UCD.layComponentToTop(itemsPane), "Center");
            this.setOpaque(false);
        }

        public List<ItemPane> getItemPanes() {
            return this.itemPanes;
        }
    }

    public static abstract class TaskAction
    extends BaseAction {
        private static final long serialVersionUID = 3976000040207867591L;
        private Window parentWindo = null;

        @Override
        public final void actionPerformed(ActionEvent actionEvent) {
            if (null == actionEvent) {
                return;
            }
            Object source = actionEvent.getSource();
            if (null != source && source instanceof Component) {
                this.parentWindo = (Window)SwingUtilities.getAncestorOfClass(Window.class, (Component)source);
            }
            if (!CommonUtil.checkSystem(this.parentWindo, this.getDeviceID())) {
                return;
            }
            this.doTask(actionEvent);
        }

        protected abstract void doTask(ActionEvent var1);

        public Window getParentWindow() {
            if (null == this.parentWindo) {
                return Framework.getInstance().getMainFrame();
            }
            return this.parentWindo;
        }
    }

    public static class TaskItem {
        private String nameKey;
        private String detailsKey;
        private BaseAction action;
        private String iconFileName;

        public TaskItem(String nameKey, String detailsKey, String iconFileName, TaskAction action) {
            Assert.notNull(nameKey);
            Assert.notNull(action);
            this.nameKey = nameKey;
            this.detailsKey = detailsKey;
            this.iconFileName = iconFileName;
            this.action = action;
        }

        public BaseAction getAction() {
            return this.action;
        }

        public String getDetails() {
            return ResourceManager.getString(this.detailsKey);
        }

        public String getName() {
            return ResourceManager.getString(this.nameKey);
        }

        public Icon getIcon() {
            return ResourceManager.getImage(this.iconFileName);
        }
    }

    public static class TaskGroup {
        private String titleKey;
        private List<TaskItem> items;

        public TaskGroup(String titleKey, TaskItem ... items) {
            Assert.notNullArray(items);
            this.titleKey = titleKey;
            this.items = Arrays.asList(items);
        }

        public TaskGroup(TaskItem ... items) {
            Assert.notNullArray(items);
            this.items = Arrays.asList(items);
        }

        public String getTitle() {
            if (null == this.titleKey) {
                return ResourceManager.getString("ITEMGROUP.TITLE.TASK");
            }
            return ResourceManager.getString(this.titleKey);
        }

        public List<TaskItem> getItems() {
            return this.items;
        }
    }

    public static class ItemGroup {
        private String title;
        private List<FeatureItem> items;

        public ItemGroup(String titleKey, FeatureItem ... items) {
            Assert.notNullArray(items);
            this.title = null == titleKey || titleKey.isEmpty() ? ResourceManager.getString("ITEMGROUP.TITLE.FEATURE") : ResourceManager.getString(titleKey);
            this.items = Arrays.asList(items);
        }

        public ItemGroup(FeatureItem ... items) {
            Assert.notNullArray(items);
            this.title = ResourceManager.getString("ITEMGROUP.TITLE.FEATURE");
            this.items = Arrays.asList(items);
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public List<FeatureItem> getItems() {
            return this.items;
        }
    }
}

