/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.module.featuremanager;

import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.entity.Type;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.ui.widgets.propertypane.ProgressingPropertyPane;
import com.huawei.ism.util.Assert;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;

public class FeatureItem {
    private String deviceID;
    private String freatureName;
    private String url = null;
    private String freatureDetails;
    private String tooltipText;
    private String normalIconFile;
    private String rolloverIconFile;
    private String selectedIconFile;
    private SoftReference<PropertyPane> propertyPaneRef = null;
    private FeatureItem parent = null;
    private BaseAction<Object> itemAction = null;
    private DeviceType deviceType;
    private boolean topFeatureItemn = false;
    private boolean expandItem;
    private List<Type.LicenseFuncFeatureType> types = new ArrayList<Type.LicenseFuncFeatureType>(0);

    public FeatureItem(String deviceID, String normalIconFile, String name, DeviceType deviceType) {
        this(deviceID, normalIconFile, name, null, deviceType);
    }

    public FeatureItem(String deviceID, String normalIconFile, String name, String urlLink, DeviceType deviceType) {
        Assert.notNull(name);
        this.deviceID = deviceID;
        this.normalIconFile = normalIconFile;
        this.freatureName = name;
        this.url = urlLink;
        this.deviceType = deviceType;
    }

    public FeatureItem(String deviceID, String normalIconFile, String name, BaseAction<Object> baseAction, boolean showDialog, DeviceType deviceType) {
        Assert.notNull(name);
        this.deviceID = deviceID;
        this.normalIconFile = normalIconFile;
        this.freatureName = name;
        this.itemAction = baseAction;
        this.deviceType = deviceType;
    }

    public final PropertyPane getPropertyPane() {
        PropertyPane propertyPane = null;
        if (null == this.propertyPaneRef) {
            propertyPane = this.createPropertyPane();
            this.propertyPaneRef = new SoftReference<PropertyPane>(propertyPane);
        } else {
            propertyPane = this.propertyPaneRef.get();
            if (null == propertyPane) {
                propertyPane = this.createPropertyPane();
                this.propertyPaneRef = new SoftReference<PropertyPane>(propertyPane);
            }
        }
        propertyPane.setFeatureItem(this);
        if (propertyPane instanceof ProgressingPropertyPane) {
            this.propertyPaneRef = null;
        }
        return propertyPane;
    }

    protected PropertyPane createPropertyPane() {
        return ProgressingPropertyPane.getInstance();
    }

    public String getName() {
        return this.freatureName;
    }

    public ImageIcon getNormalIcon() {
        return this.getImgIcon(this.normalIconFile);
    }

    public void setNormalIcon(String normalIconFileTemp) {
        this.normalIconFile = normalIconFileTemp;
    }

    public ImageIcon getRolloverIcon() {
        return this.getImgIcon(this.rolloverIconFile);
    }

    public void setRolloverIcon(String rolloverIconFileTemp) {
        this.rolloverIconFile = rolloverIconFileTemp;
    }

    public ImageIcon getSelectedIcon() {
        return this.getImgIcon(this.selectedIconFile);
    }

    private ImageIcon getImgIcon(String iconName) {
        ImageIcon imgIcon = ResourceManager.getImage(iconName);
        if (imgIcon == ResourceManager.DEFAULT_ICON) {
            imgIcon = null;
        }
        return imgIcon;
    }

    public void setSelectedIcon(String icon) {
        this.selectedIconFile = icon;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String tooltipText) {
        this.tooltipText = tooltipText;
    }

    public String getDeviceID() {
        return this.deviceID;
    }

    public String getDetails() {
        return this.freatureDetails;
    }

    public void setDetails(String details) {
        this.freatureDetails = details;
    }

    public void setParent(FeatureItem parent) {
        this.parent = parent;
    }

    public void setLicenseFeature(Type.LicenseFuncFeatureType ... typesTemp) {
        Assert.notNullArray(typesTemp);
        this.types = Arrays.asList(typesTemp);
    }

    public List<Type.LicenseFuncFeatureType> getLicenseFeature() {
        return this.types;
    }

    public String getURLLink() {
        return this.url;
    }

    public void setURLLink(String link) {
        this.url = link;
    }

    public boolean isURLLink() {
        return this.url != null;
    }

    public List<FeatureItem> getParents() {
        LinkedList<FeatureItem> features = new LinkedList<FeatureItem>();
        FeatureItem parentItem = this.parent;
        while (null != parentItem) {
            features.add(0, parentItem);
            parentItem = parentItem.parent;
        }
        return features;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FeatureItem) {
            return false;
        }
        FeatureItem featureItem = (FeatureItem)obj;
        if (null == featureItem || null == this.getName() || null == featureItem.getName()) {
            return false;
        }
        return this.getName().equalsIgnoreCase(featureItem.getName()) && this.getDeviceType().toString().equalsIgnoreCase(featureItem.getDeviceType().toString());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getDeviceType().hashCode();
    }

    public void setAction(BaseAction<Object> baseAction) {
        this.itemAction = baseAction;
    }

    public BaseAction<Object> getAction() {
        return this.itemAction;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public boolean isTopFeatureItemn() {
        return this.topFeatureItemn;
    }

    public void setTopFeatureItemn(boolean topFeatureItemn) {
        this.topFeatureItemn = topFeatureItemn;
    }

    public boolean isExpandItem() {
        return this.expandItem;
    }

    public void setExpandItem(boolean expandItem) {
        this.expandItem = expandItem;
    }
}

