/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.util.CommonUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Map;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class AdvancePerfStatXYToolTipGenerator
extends StandardXYToolTipGenerator {
    private static final long serialVersionUID = -7240487067592636231L;
    private static final String TOOLTIP_FORMAT = "<html>{0}: {1}<br> {2}: {3} {4}<br> {5}: {6} </html>";
    private static final String THRESHOLD_TOOLTIP_FORMAT = "<html>{0}: {1}<br> {2}: {3}<br> {4}: {5} {6} </html>";
    private DefaultTableModel tableMode;
    private transient Map<String, Double> currentScales;

    public AdvancePerfStatXYToolTipGenerator(DateFormat xFormat, NumberFormat yFormat, DefaultTableModel tableMode, Map<String, Double> currentScales) {
        super(TOOLTIP_FORMAT, xFormat, yFormat);
        this.tableMode = tableMode;
        this.currentScales = currentScales;
    }

    public String generateLabelString(XYDataset dataset, int series, int item) {
        String result = null;
        Object[] items = this.createItemArray(dataset, series, item);
        String key = this.getSeriesKey(dataset, series);
        TableRow<?, ?> tableRow = this.tableMode.getTableRowBy(key);
        Object[] infos = this.getPerfStatItemInfos(tableRow);
        double scale = this.currentScales.get(key);
        Object[] allItems = new Object[7];
        if (!ResourceManager.getString("perf.threshold.ui.threshold").equals(key)) {
            allItems[0] = infos[0];
            allItems[1] = infos[1];
            allItems[2] = infos[2];
            allItems[3] = Double.valueOf(items[2].toString().replaceAll(",", "")) / scale;
            allItems[4] = infos[3];
            allItems[5] = ResourceManager.getString("TIME_TITLE");
            allItems[6] = items[1];
            result = MessageFormat.format(TOOLTIP_FORMAT, allItems);
        } else {
            allItems[0] = CommonUtil.removeColon(ResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_PANEL_STYLE"));
            allItems[1] = infos[0];
            allItems[2] = CommonUtil.removeColon(ResourceManager.getString("PERFORMANCE_STATISTIC_PARAMETERS_PANEL_DATA_TYPE"));
            allItems[3] = infos[2];
            allItems[4] = ResourceManager.getString("perf.threshold.ui.threshold");
            allItems[5] = Double.valueOf(items[2].toString().replaceAll(",", "")) / scale;
            allItems[6] = infos[3];
            result = MessageFormat.format(THRESHOLD_TOOLTIP_FORMAT, allItems);
        }
        return result;
    }

    private Object[] getPerfStatItemInfos(TableRow tRow) {
        Object[] infos = new Object[]{tRow.getValueAt(1), tRow.getValueAt(2), tRow.getValueAt(4), tRow.getValueAt(5)};
        return infos;
    }

    private String getSeriesKey(XYDataset dataset, int series) {
        return dataset.getSeriesKey(series).toString();
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof AdvancePerfStatXYToolTipGenerator)) {
            return false;
        }
        return super.equals(ob);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

