/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.TableRow;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Map;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.data.xy.XYDataset;

public class IOClassMonitorXYToolTipGenerator
extends StandardXYToolTipGenerator {
    private static final long serialVersionUID = -8699090139475515121L;
    private static final String SMARTQOS_TOOLTIP = "<html>{0}: {1} {2}<br> {3} </html>";
    private DefaultTableModel tableMode;
    private transient Map<String, Double> currentScales;

    public IOClassMonitorXYToolTipGenerator(DateFormat xFormat, NumberFormat yFormat, DefaultTableModel tableMode, Map<String, Double> currentScales) {
        super(SMARTQOS_TOOLTIP, xFormat, yFormat);
        this.tableMode = tableMode;
        this.currentScales = currentScales;
    }

    public String generateLabelString(XYDataset dataset, int series, int item) {
        String result = null;
        Object[] items = this.createItemArray(dataset, series, item);
        String key = this.getSeriesKey(dataset, series);
        TableRow<?, ?> tableRow = this.tableMode.getTableRowBy(key);
        Object[] infos = this.getPerfStatItemInfos(tableRow);
        double scale = this.currentScales.get(key);
        Object[] allItems = new Object[4];
        if (ResourceManager.getString("Throughput").equals(key) || ResourceManager.getString("BandWidth").equals(key) || ResourceManager.getString("AverageIOResponseTime").equals(key)) {
            allItems[0] = infos[0];
            allItems[1] = Double.valueOf(items[2].toString().replaceAll(",", "")) / scale;
            allItems[2] = infos[1];
            allItems[3] = items[1];
            result = MessageFormat.format(SMARTQOS_TOOLTIP, allItems);
        }
        return result;
    }

    private Object[] getPerfStatItemInfos(TableRow tableRow) {
        Object[] infos = new Object[]{tableRow.getValueAt(1), tableRow.getValueAt(2), tableRow.getValueAt(4), tableRow.getValueAt(5)};
        return infos;
    }

    private String getSeriesKey(XYDataset dataset, int series) {
        return dataset.getSeriesKey(series).toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IOClassMonitorXYToolTipGenerator)) {
            return false;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

