/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.impl.IPerfStatObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ObjectKeeper {
    private static Map<Launcher, Set<Object>> keepedObject = new ConcurrentHashMap<Launcher, Set<Object>>(0);
    private static Set<IPerfStatObject> dataObject = Collections.synchronizedSet(new HashSet());

    private ObjectKeeper() {
    }

    public static void keepObject(String deviceID, Object needKeepedObject) {
        ObjectKeeper.keepObject(LauncherManager.getInstance().getLauncher(deviceID), needKeepedObject);
    }

    public static void keepObject(Launcher launcher, Object needKeepedObject) {
        Set<Object> set;
        if (!keepedObject.containsKey(launcher)) {
            set = new HashSet();
            keepedObject.put(launcher, set);
        }
        set = keepedObject.get(launcher);
        set.add(needKeepedObject);
    }

    public static void addDataObject(IPerfStatObject object) {
        dataObject.add(object);
    }

    public static void removeDataObject(IPerfStatObject object) {
        dataObject.remove(object);
    }

    public static void removeDataObject(Set<IPerfStatObject> objects) {
        for (IPerfStatObject obj : objects) {
            dataObject.remove(obj);
        }
    }

    public static void removeDataObject(List<IPerfStatObject> objects) {
        for (IPerfStatObject obj : objects) {
            dataObject.remove(obj);
        }
    }

    public static boolean isDataObjectEmpty() {
        return dataObject.isEmpty();
    }

    public static void clear(Launcher launcher) {
        Set<Object> set = keepedObject.remove(launcher);
        if (set != null) {
            set.clear();
        }
    }
}

