/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.bean.impl.IDataTypeEnum;
import com.huawei.ism.common.bean.impl.IObjectTypeEnum;
import com.huawei.ism.common.bean.impl.IPerfStatObject;
import com.huawei.ism.common.bean.impl.IPerfStatObjectType;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui2.perfstat.util.TickableTreeNode;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfStatUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerfStatUtil.class);
    public static final String BASIC_DATA_TYPES = "basicDataTypes";
    public static final String ADVANCED_DATA_TYPES = "davancedDataTypes";
    public static final String IO_DISTRIBUTION_DATA_TYPES = "ioDistributionDataTypes";
    public static final String IO_TIME_DATA_TYPES = "iotTimeDataTypes";
    public static final String KEY_STRATEGY_SAMPLING_INTERVAL = "samplingInterval";
    public static final String KEY_STRATEGY_IS_ARCHIVE_SWITCH_ON = "isArchiveSwitchOn";
    public static final String KEY_STRATEGY_IS_AUTO_STOP = "isAutoStop";
    public static final String KEY_STRATEGY_MAX_DAYS = "statisticMaxDays";
    public static final String KEY_STRATEGY_ARCHIVE_INTERVAL = "archiveInterval";
    public static final String KEY_SWITCH_IS_PERFORMANCE_SWITCH_ON = "isPerformanceSwitchOn";
    public static final String KEY_SWITCH_BEGIN_TIME = "switchStartTime";
    public static final String KEY_SWITCH_END_TIME = "switchEndTime";
    public static final String ALL_DATA_TYPES = "allDataTypes";
    public static final String PNG = "png";

    public static String[] getScaleTableColNames() {
        return new String[]{ResourceManager.getString("perf.his.ui.legend"), CommonUtil.removeColon(ResourceManager.getString("PERFORMANCE_STATISTIC_OBJECT_PANEL_STYLE")), ResourceManager.getString("perf.his.ui.object"), ResourceManager.getString("perf.his.ui.scale"), ResourceManager.getString("perf.his.ui.datatype"), ResourceManager.getString("perf.threshold.ui.unit")};
    }

    public static String[] getObjectAndDataTypeNameTableColNames() {
        return new String[]{ResourceManager.getString("PERFORMANCE_STATISTIC_TABLE_HEAD_NAME")};
    }

    public static String transferStringToLower(String value) {
        return PerfStatUtil.transferStringToLower(value, null, false);
    }

    private static String transferStringToLower(String value, int[] notNeedTrans, boolean isUpperCase) {
        String validValue;
        Locale locale = ResourceManager.getLocale();
        String string = validValue = null == value ? "--" : value;
        if (locale.equals(Locale.ENGLISH)) {
            String[] words = validValue.split(" ");
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < words.length; ++i) {
                if (0 == i || PerfStatUtil.isContain(i, notNeedTrans)) {
                    result.append(words[i]);
                } else {
                    result.append(PerfStatUtil.changeFirstLow(words[i], isUpperCase));
                }
                if (i == words.length - 1) continue;
                result.append(" ");
            }
            return result.toString();
        }
        return validValue;
    }

    private static boolean isContain(int value, int[] arrays) {
        if (null == arrays) {
            return false;
        }
        for (int array : arrays) {
            if (value != array) continue;
            return true;
        }
        return false;
    }

    private static String changeFirstLow(String word, boolean isUpperCase) {
        if (isUpperCase) {
            return word.substring(0, 1).toUpperCase(Locale.getDefault()) + word.substring(1);
        }
        return word.substring(0, 1).toLowerCase(Locale.getDefault()) + word.substring(1);
    }

    public static void setSameWidthAndAlign(int alignment, JLabel ... labels) {
        PerfStatUtil.setSameWidth(labels);
        for (JLabel label : labels) {
            label.setHorizontalAlignment(alignment);
        }
    }

    private static void setSameWidth(JComponent ... components) {
        int maxWidth = 0;
        int width = 0;
        for (JComponent component : components) {
            width = component.getPreferredSize().width;
            maxWidth = width > maxWidth ? width : maxWidth;
        }
        for (JComponent component : components) {
            UCD.setJComponentSize(component, maxWidth + 6, component.getPreferredSize().height);
        }
    }

    public static void disabledComponentByUser(String deviceID, JComponent ... components) {
        Assert.notNullStr(deviceID);
        PerfStatUtil.disabledComponentByUser(deviceID, User.Level.Admin, components);
    }

    private static void disabledComponentByUser(String deviceID, User.Level level, JComponent ... components) {
        Assert.notNullStr(deviceID);
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
        User user = launcher.getDeviceContext().getCurrentUser();
        User.Level currentlevel = user.getLevel();
        if (null != level && null != currentlevel && currentlevel.getValue() > level.getValue()) {
            for (JComponent jComponent : components) {
                SwingUtil.setComponentsEnabled(jComponent, false);
                jComponent.setEnabled(false);
            }
        }
    }

    public static List<Pair<String, String>> getDeviceIDNamePair(List<String> deviceIDs) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>(0);
        Pair<String, String> pair = null;
        for (String deviceID : deviceIDs) {
            pair = new Pair<String, String>(deviceID, CommonUtil.getDeviceName(deviceID));
            pairs.add(pair);
        }
        return pairs;
    }

    public static Map<IObjectTypeEnum, DefaultMutableTreeNode> createObjectTypeToDataTypeTreeNodeMapping(Map<IObjectTypeEnum, List<IDataTypeEnum>> objectTypeToDataTypesMapping) {
        HashMap<IObjectTypeEnum, DefaultMutableTreeNode> map = new HashMap<IObjectTypeEnum, DefaultMutableTreeNode>(0);
        Set<Map.Entry<IObjectTypeEnum, List<IDataTypeEnum>>> entries = objectTypeToDataTypesMapping.entrySet();
        for (Map.Entry<IObjectTypeEnum, List<IDataTypeEnum>> entry : entries) {
            map.put(entry.getKey(), PerfStatUtil.createDataTypeTreeNode(entry.getValue()));
        }
        return map;
    }

    public static TickableTreeNode createDataTypeTreeNode(List<IDataTypeEnum> dataTypes) {
        TickableTreeNode rootNode = new TickableTreeNode("root");
        if (dataTypes != null) {
            Pair<IDataTypeEnum, String> pair = null;
            TickableTreeNode node = null;
            for (IDataTypeEnum dataTypeEnum : dataTypes) {
                pair = new Pair<IDataTypeEnum, String>(dataTypeEnum, dataTypeEnum.getDescription());
                node = new TickableTreeNode(pair);
                node.setSelectable(false);
                rootNode.add(node);
            }
        }
        return rootNode;
    }

    public static Map<IObjectTypeEnum, List<IDataTypeEnum>> convertToObjectTypeToDataTypesMapping(Map<IPerfStatObjectType, List<Object>> perfStatObjectTypeToMOMap) {
        Set<IPerfStatObjectType> perfStatObjectTypes = perfStatObjectTypeToMOMap.keySet();
        HashMap<IObjectTypeEnum, List<IDataTypeEnum>> objectTypeToDataTypesMapping = new HashMap<IObjectTypeEnum, List<IDataTypeEnum>>(0);
        for (IPerfStatObjectType perfStatObjectType : perfStatObjectTypes) {
            objectTypeToDataTypesMapping.put(perfStatObjectType.getType(), perfStatObjectType.getDataTypeList());
        }
        return objectTypeToDataTypesMapping;
    }

    public static Map<IObjectTypeEnum, DefaultMutableTreeNode> createNewObjectTypeToObjectsMapping(Map<IObjectTypeEnum, DefaultMutableTreeNode> oldObjectTypeToObjectsMapping, Map<IObjectTypeEnum, DefaultMutableTreeNode> newObjectTypeToObjectsMapping, Map<IPerfStatObjectType, List<Object>> perfStatObjectTypeToMOMap) {
        Set<Map.Entry<IObjectTypeEnum, DefaultMutableTreeNode>> entries = oldObjectTypeToObjectsMapping.entrySet();
        for (Map.Entry<IObjectTypeEnum, DefaultMutableTreeNode> entry : entries) {
            DefaultMutableTreeNode oldNode = entry.getValue();
            DefaultMutableTreeNode newNode = newObjectTypeToObjectsMapping.get(entry.getKey());
            PerfStatUtil.syncAncestorAndDescendantNodeTickedStatus(oldNode, newNode);
        }
        return newObjectTypeToObjectsMapping;
    }

    private static void syncAncestorAndDescendantNodeTickedStatus(DefaultMutableTreeNode sourceAncestorNode, DefaultMutableTreeNode destAncestorNode) {
        if (sourceAncestorNode == null || destAncestorNode == null) {
            return;
        }
        ArrayList<TreeNode> souceNodes = Collections.list(sourceAncestorNode.breadthFirstEnumeration());
        for (DefaultMutableTreeNode defaultMutableTreeNode : souceNodes) {
            if (!(defaultMutableTreeNode instanceof TickableTreeNode)) continue;
            TickableTreeNode sourceTickableTreeNode = CommonUtil.convertObject(defaultMutableTreeNode, TickableTreeNode.class);
            DefaultMutableTreeNode destNode = PerfStatUtil.findDescendantNode(destAncestorNode, defaultMutableTreeNode);
            if (!(destNode instanceof TickableTreeNode)) continue;
            TickableTreeNode destTickableTreeNode = CommonUtil.convertObject(destNode, TickableTreeNode.class);
            destTickableTreeNode.setTicked(sourceTickableTreeNode.isTicked());
        }
    }

    private static DefaultMutableTreeNode findDescendantNode(DefaultMutableTreeNode parentNode, DefaultMutableTreeNode descendantNode) {
        Enumeration<TreeNode> nodes = parentNode.breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            if (!PerfStatUtil.isNodeEquals(node, descendantNode)) continue;
            return node;
        }
        return null;
    }

    private static boolean isNodeEquals(DefaultMutableTreeNode nodeA, DefaultMutableTreeNode nodeB) {
        if (nodeA == null && nodeB == null) {
            throw new NullPointerException("Both node is null.");
        }
        if (nodeA == null && nodeB != null || nodeA != null && nodeB == null) {
            return false;
        }
        if (nodeA == nodeB) {
            return true;
        }
        Object userObjectA = nodeA.getUserObject();
        Object userObjectB = nodeB.getUserObject();
        if (!(userObjectA instanceof Pair) || !(userObjectB instanceof Pair)) {
            return false;
        }
        Pair pairA = (Pair)userObjectA;
        Pair pairB = (Pair)userObjectB;
        return ((IPerfStatObject)pairA.getKey()).equals(pairB.getKey()) && ((String)pairA.getValue()).equals(pairB.getValue());
    }

    public static String getSeparator() {
        if ("en".equals(ResourceManager.getLocale().getLanguage())) {
            return " ";
        }
        return "";
    }

    public static boolean existCurrentObjectType(IObjectTypeEnum type, Set<IPerfStatObject> selectedObjectsSet) {
        if (null == type || null == selectedObjectsSet) {
            LOGGER.warn("something is null, can not remove the chart : type and selectedObjectsSet is null. ");
            return false;
        }
        for (IPerfStatObject perfStatObject : selectedObjectsSet) {
            if (!type.equals(perfStatObject.getObjectType())) continue;
            return false;
        }
        return true;
    }
}

