/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import com.huawei.ism.ui.module.perfhis.util.ColorContainer;
import com.huawei.ism.ui2.perfstat.util.TickableTreeNode;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TickableTree
extends JTree {
    private static final int LABEL_WIDTH = 150;
    private static final long serialVersionUID = -1133801922881733787L;
    private boolean isMultiTick = true;
    private boolean displayDefaultIcon = false;
    private boolean autoSelectedWhenTick = true;
    private transient List<TreeTickListener> treeTickListeners = new LinkedList<TreeTickListener>();
    private transient ColorContainer colorContainer;
    private JToolTip tooltip = new JToolTip();
    private transient Popup popup;
    private TickableTreeNode showingNode;
    private boolean isColor;

    public TickableTree(boolean isMultiTick, boolean isMultiSelect) {
        this(isMultiTick, isMultiSelect, false);
    }

    public TickableTree(boolean isMultiTick, boolean isMultiSelect, boolean isColor) {
        super(new Object[0]);
        this.isMultiTick = isMultiTick;
        this.isColor = isColor;
        if (isColor) {
            this.colorContainer = new ColorContainer();
        }
        this.setMultiSelect(isMultiSelect);
        this.setCellRenderer(this.getTickableTreeCellRender());
        this.insertMouseListeners(0, this.getMouseAdapter());
    }

    private Color getColor() {
        return this.colorContainer.getColor();
    }

    private void releaseColor(Color color) {
        this.colorContainer.releaseColor(color);
    }

    public void releaseAllColor() {
        this.colorContainer.releaseAllColor();
    }

    public void setRoot(DefaultMutableTreeNode root) {
        DefaultTreeModel model = new DefaultTreeModel(root);
        this.setModel(model);
    }

    public DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    public List<TickableTreeNode> getTickedTreeNodes() {
        ArrayList<TickableTreeNode> tickedNodes = new ArrayList<TickableTreeNode>(0);
        List<TickableTreeNode> allTickableNodes = this.getAllTickableTreeNode();
        for (TickableTreeNode node : allTickableNodes) {
            if (!node.isTicked()) continue;
            tickedNodes.add(node);
        }
        return tickedNodes;
    }

    public List<DefaultMutableTreeNode> getSelectedTreeNodes() {
        ArrayList<DefaultMutableTreeNode> selectedNodes = new ArrayList<DefaultMutableTreeNode>(0);
        TreePath[] selectedPaths = this.getSelectionPaths();
        if (selectedPaths != null) {
            for (TreePath treePath : selectedPaths) {
                selectedNodes.add((DefaultMutableTreeNode)treePath.getLastPathComponent());
            }
        }
        return selectedNodes;
    }

    public void setDisplayLine(boolean isDisplay) {
        if (isDisplay) {
            this.putClientProperty("JTree.lineStyle", "Angled");
        } else {
            this.putClientProperty("JTree.lineStyle", "None");
        }
    }

    public boolean isDisplayDefaultIcon() {
        return this.displayDefaultIcon;
    }

    public void setDisplayDefaultIcon(boolean isDisplayDefaultIcon) {
        this.displayDefaultIcon = isDisplayDefaultIcon;
    }

    public boolean isAutoSelectedWhenTick() {
        return this.autoSelectedWhenTick;
    }

    public void setAutoSelectedWhenTick(boolean isAutoSelectedWhenTick) {
        this.autoSelectedWhenTick = isAutoSelectedWhenTick;
    }

    public void addTreeTickListener(TreeTickListener treeTickListener) {
        this.treeTickListeners.add(treeTickListener);
    }

    public void removeTreeTickListener(TreeTickListener treeTickListener) {
        this.treeTickListeners.remove(treeTickListener);
    }

    public void fireTreeTicked(TreeTickEvent e) {
        for (TreeTickListener treeTickListener : this.treeTickListeners) {
            if (treeTickListener == null) continue;
            treeTickListener.treeTicked(e);
        }
    }

    public void reload() {
        TreeModel model = this.getModel();
        if (model instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)model;
            defaultTreeModel.reload();
        }
    }

    public void nodeChanged(DefaultMutableTreeNode node) {
        TreeModel model = this.getModel();
        if (model instanceof DefaultTreeModel) {
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)model;
            defaultTreeModel.nodeChanged(node);
        }
    }

    private TreeCellRenderer getTickableTreeCellRender() {
        return new MyCellRender(this.isColor);
    }

    private MouseAdapter getMouseAdapter() {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TickableTree.this.processMousePressed(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TickableTree.this.processMouseEntered(e);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TickableTree.this.processMouseMoved(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TickableTree.this.hideToolTip();
            }
        };
        return adapter;
    }

    private void processMousePressed(MouseEvent mouseEvent) {
        int mouseEventX = mouseEvent.getX();
        int mouseEventY = mouseEvent.getY();
        int row = this.getRowForLocation(mouseEventX, mouseEventY);
        Rectangle bounds = this.getRowBounds(row);
        TreePath path = this.getPathForRow(row);
        if (null == path) {
            return;
        }
        Object object = path.getLastPathComponent();
        if (object instanceof TickableTreeNode) {
            TickableTreeNode node = (TickableTreeNode)object;
            if (!node.isSelectable()) {
                mouseEvent.consume();
            }
            if (this.isClickInTickBox(mouseEventX, bounds)) {
                this.clickTickBox(node);
                this.fireTreeTicked(new TreeTickEvent(this, node));
                if (!this.autoSelectedWhenTick || !node.isTicked()) {
                    mouseEvent.consume();
                }
            }
        }
    }

    private void processMouseEntered(MouseEvent mouseEvent) {
        int mouseEventY;
        int mouseEventX = mouseEvent.getX();
        int row = this.getRowForLocation(mouseEventX, mouseEventY = mouseEvent.getY());
        TreePath path = this.getPathForRow(row);
        if (null == path) {
            this.hideToolTip();
            return;
        }
        Object object = path.getLastPathComponent();
        if (object instanceof TickableTreeNode) {
            TickableTreeNode node = (TickableTreeNode)object;
            if (node.getNodeName() != null) {
                this.showToolTip(node, mouseEventY - 15);
            } else {
                this.hideToolTip();
            }
        } else {
            this.hideToolTip();
        }
    }

    private void processMouseMoved(MouseEvent mouseEvent) {
        int mouseEventY;
        int mouseEventX = mouseEvent.getX();
        int row = this.getRowForLocation(mouseEventX, mouseEventY = mouseEvent.getY());
        TreePath path = this.getPathForRow(row);
        if (null == path) {
            this.hideToolTip();
            return;
        }
        Object object = path.getLastPathComponent();
        if (object instanceof TickableTreeNode) {
            TickableTreeNode node = (TickableTreeNode)object;
            if (node.getNodeName() != null) {
                this.showToolTip(node, mouseEventY - 15);
            } else {
                this.hideToolTip();
            }
        } else {
            this.hideToolTip();
        }
    }

    private void showToolTip(TickableTreeNode node, int y) {
        if (this.showingNode == node) {
            return;
        }
        this.hideToolTip();
        this.showingNode = node;
        this.tooltip.setTipText(this.showingNode.getNodeName());
        Point point = this.computeInformLocation(y);
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        this.popup = popupFactory.getPopup(this, this.tooltip, point.x, point.y);
        this.popup.show();
    }

    private void hideToolTip() {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        this.showingNode = null;
    }

    private Point computeInformLocation(int yy) {
        boolean leftToRight = this.getComponentOrientation().isLeftToRight();
        Rectangle sBounds = this.getGraphicsConfiguration().getBounds();
        Point screenLocation = this.getLocationOnScreen();
        Point location = new Point();
        Dimension size = this.tooltip.getPreferredSize();
        Point preferredLocation = new Point(10, 24);
        int locationX = (int)screenLocation.getX() + (int)preferredLocation.getX() + 150;
        int locationY = (int)screenLocation.getY() + (int)preferredLocation.getY() + yy;
        if (!leftToRight) {
            locationX -= size.width;
        }
        Rectangle popupRect = new Rectangle();
        popupRect.setBounds(locationX, locationY, size.width, size.height);
        if (locationX < (int)sBounds.getX()) {
            locationX = (int)sBounds.getX();
        } else if (locationX - (int)sBounds.getX() + size.width > sBounds.width) {
            locationX = (int)sBounds.getX() + Math.max(0, sBounds.width - size.width);
        }
        if (locationY < (int)sBounds.getY()) {
            locationY = (int)sBounds.getY();
        } else if (locationY - (int)sBounds.getY() + size.height > sBounds.height) {
            locationY = (int)sBounds.getY() + Math.max(0, sBounds.height - size.height);
        }
        location.setLocation(locationX, locationY);
        return location;
    }

    private void clickTickBox(TickableTreeNode node) {
        if (this.isMultiTick) {
            this.clickMultiTickBox(node);
        } else {
            this.clickSingleTickBox(node);
        }
    }

    private void clickSingleTickBox(TickableTreeNode node) {
        this.clearAllTicked();
        node.setTicked(true);
        if (this.isColor) {
            node.setColor(this.getColor());
        }
        this.nodeChanged(node);
    }

    private void clickMultiTickBox(TickableTreeNode node) {
        node.reverseTicked();
        if (this.isColor) {
            if (node.isTicked()) {
                node.setColor(this.getColor());
            } else {
                this.releaseColor(node.getColor());
                node.setColor(null);
            }
        }
        this.nodeChanged(node);
    }

    private JLabel createTickBoxLabel(TickableTreeNode node) {
        JLabel tickLabel = new JLabel();
        if (this.isMultiTick) {
            if (node.isTicked()) {
                tickLabel.setIcon(UIManager.getIcon("CheckBox.selectedEnabledIcon"));
            } else {
                tickLabel.setIcon(UIManager.getIcon("CheckBox.icon"));
            }
        } else if (node.isTicked()) {
            tickLabel.setIcon(UIManager.getIcon("RadioButton.selectedEnabledIcon"));
        } else {
            tickLabel.setIcon(UIManager.getIcon("RadioButton.icon"));
        }
        return tickLabel;
    }

    private JLabel createColorLabel(Color color) {
        JLabel colorLabel = new JLabel();
        colorLabel.setIcon(new SquareIcon(color));
        return colorLabel;
    }

    private boolean isClickInTickBox(int xx, Rectangle bounds) {
        if (bounds == null) {
            return false;
        }
        Icon icon = UIManager.getIcon("CheckBox.icon");
        return xx >= (int)bounds.getX() && xx <= (int)bounds.getX() + icon.getIconWidth() + 2;
    }

    private List<TickableTreeNode> getAllTickableTreeNode() {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        ArrayList<TickableTreeNode> tickableTreeNode = new ArrayList<TickableTreeNode>(0);
        if (root == null) {
            return tickableTreeNode;
        }
        Enumeration<TreeNode> allNodes = root.breadthFirstEnumeration();
        DefaultMutableTreeNode node = null;
        while (allNodes.hasMoreElements()) {
            node = (DefaultMutableTreeNode)allNodes.nextElement();
            if (!(node instanceof TickableTreeNode)) continue;
            tickableTreeNode.add((TickableTreeNode)node);
        }
        return tickableTreeNode;
    }

    private void clearAllTicked() {
        List<TickableTreeNode> allNodes = this.getAllTickableTreeNode();
        for (TickableTreeNode node : allNodes) {
            node.setTicked(false);
        }
        if (this.isColor) {
            this.releaseAllColor();
        }
    }

    private void setMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect) {
            this.getSelectionModel().setSelectionMode(4);
        } else {
            this.getSelectionModel().setSelectionMode(1);
        }
    }

    private void insertMouseListeners(int index, MouseAdapter mouseAdapter) {
        LinkedList<MouseListener> listeners = new LinkedList<MouseListener>(Arrays.asList(this.getMouseListeners()));
        for (MouseListener mouseListener : listeners) {
            this.removeMouseListener(mouseListener);
        }
        listeners.add(index, mouseAdapter);
        for (MouseListener mouseListener : listeners) {
            this.addMouseListener(mouseListener);
        }
        LinkedList<MouseMotionListener> motionListeners = new LinkedList<MouseMotionListener>(Arrays.asList(this.getMouseMotionListeners()));
        for (MouseMotionListener mouseMotionListener : motionListeners) {
            this.removeMouseMotionListener(mouseMotionListener);
        }
        motionListeners.add(index, mouseAdapter);
        for (MouseMotionListener mouseMotionListener : motionListeners) {
            this.addMouseMotionListener(mouseMotionListener);
        }
    }

    private class MyCellRender
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -430882878168916133L;
        private boolean isColor;

        public MyCellRender(boolean isColor) {
            this.isColor = isColor;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel infoLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof TickableTreeNode) {
                TickableTreeNode node = (TickableTreeNode)value;
                if (!TickableTree.this.displayDefaultIcon) {
                    infoLabel.setIcon(node.getNodeIcon());
                }
                if (node.isDispalyTickBox()) {
                    JLabel tickBoxLabel = TickableTree.this.createTickBoxLabel(node);
                    return this.createTreeNodeLabel(infoLabel, node, tickBoxLabel);
                }
                return infoLabel;
            }
            if (!TickableTree.this.displayDefaultIcon) {
                infoLabel.setIcon(null);
            }
            if (this.isColor) {
                FontMetrics fontMetrics = infoLabel.getFontMetrics(infoLabel.getFont());
                int length = fontMetrics.stringWidth(infoLabel.getText());
                infoLabel.setPreferredSize(new Dimension(length, 18));
            }
            return infoLabel;
        }

        private Component createTreeNodeLabel(JLabel infoLabel, TickableTreeNode node, JLabel tickBoxLabel) {
            if (this.isColor) {
                if (node.isTicked() && node.getColor() != null) {
                    JLabel colorLabel = TickableTree.this.createColorLabel(node.getColor());
                    this.cutInfoLabel(infoLabel, node);
                    return UCD.buildHBoxLeft(5, tickBoxLabel, infoLabel, colorLabel);
                }
                this.resizeInfoLabel(infoLabel, node);
                return UCD.buildHBoxLeft(5, tickBoxLabel, infoLabel);
            }
            return UCD.buildHBoxLeft(5, tickBoxLabel, infoLabel);
        }

        private void cutInfoLabel(JLabel label, TickableTreeNode node) {
            FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
            int length = fontMetrics.stringWidth(label.getText());
            if (length > 150) {
                node.setNodeName(label.getText());
            }
            label.setPreferredSize(new Dimension(150, 18));
        }

        private void resizeInfoLabel(JLabel label, TickableTreeNode node) {
            FontMetrics fontMetrics = label.getFontMetrics(label.getFont());
            int length = fontMetrics.stringWidth(label.getText());
            node.setNodeName(null);
            label.setPreferredSize(new Dimension(length, 20));
        }
    }

    private static final class SquareIcon
    implements Icon {
        private static final int SQUARE_WIDTH = 30;
        private static final int SQUARE_HEIGHT = 3;
        private Color color;
        private boolean checkSelected = false;

        public SquareIcon(Color color) {
            this.setColor(color);
        }

        @Override
        public int getIconHeight() {
            return 3;
        }

        @Override
        public int getIconWidth() {
            return 30;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public boolean isSelected() {
            return this.checkSelected;
        }

        public void setSelected(boolean isSelected) {
            this.checkSelected = isSelected;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            graphics.setColor(this.color);
            graphics.fill3DRect(xx, yy, this.getIconWidth(), this.getIconHeight(), !this.checkSelected);
        }
    }

    public static class TreeTickEvent
    extends EventObject {
        private static final long serialVersionUID = -8187187253724630978L;
        private TickableTreeNode currentNode;

        public TreeTickEvent(Object source, TickableTreeNode node) {
            super(source);
            this.currentNode = node;
        }

        public TickableTreeNode getCurrentNode() {
            return this.currentNode;
        }
    }

    public static abstract class TreeTickListener
    implements EventListener {
        public abstract void treeTicked(TreeTickEvent var1);
    }
}

