/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.perfstat.util;

import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.ui.module.perfhis.TimeSeriesChart;
import com.huawei.ism.ui.module.perfhis.XYTimeSeriesData;
import com.huawei.ism.ui2.perfstat.NormalPerfStatXYToolTipGenerator;
import com.huawei.ism.ui2.perfstat.PerfStatSurveyInfoDialog;
import com.huawei.ism.ui2.perfstat.util.PerfStatChartProgressListener;
import com.huawei.ism.ui2.perfstat.util.SetFrameOnTopThread;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.TimeSeries;

public class TimeSeriesChartWithMagnifier
extends JPanel {
    private static final long serialVersionUID = 6593210601773057476L;
    private static final int TITLE_HEIGHT = 14;
    private JLabel title;
    private TimeSeriesChart chart;
    private Map<String, Color> colorMap = new HashMap<String, Color>();
    private boolean isMagnify = false;
    private Frame frame;
    private String fromPane;

    public TimeSeriesChartWithMagnifier(Frame frame, boolean properties, boolean save, boolean print, boolean zoom, boolean tooltips, boolean legend, boolean domainZoomable, boolean rangeZoomable, String fromPaneValue) {
        this.frame = frame;
        this.title = new JLabel("");
        this.title.setFont(new Font("Dialog", 1, 14));
        this.chart = new TimeSeriesChart(properties, save, print, zoom, tooltips, legend, domainZoomable, rangeZoomable);
        this.fromPane = fromPaneValue;
        this.addLisenter();
        this.initLayout();
        this.solveCannotDisplayTooltips();
    }

    private void solveCannotDisplayTooltips() {
        this.chart.getChart().addProgressListener((ChartProgressListener)new PerfStatChartProgressListener(this.chart));
        this.chart.setAutoPopulateSeriesShape(false);
    }

    private void addLisenter() {
        this.chart.getChartPanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!TimeSeriesChartWithMagnifier.this.isMagnify && mouseEvent.getButton() == 1) {
                    TimeSeriesChartWithMagnifier.this.magnifySeriesChart();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                TimeSeriesChartWithMagnifier.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                TimeSeriesChartWithMagnifier.this.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                TimeSeriesChartWithMagnifier.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        });
    }

    private void initLayout() {
        this.setLayout(new BorderLayout());
        Box box = new Box(0);
        box.add(Box.createHorizontalGlue());
        box.add(this.title);
        box.add(Box.createHorizontalGlue());
        box.setBackground(Color.WHITE);
        this.add((Component)box, "North");
        this.add((Component)this.chart, "Center");
    }

    private void magnifySeriesChart() {
        this.isMagnify = true;
        PerfStatSurveyInfoDialog perfStatSurveyInfoDialog = new PerfStatSurveyInfoDialog(this.frame, this, this.fromPane);
        SwingUtil.putParentCenter(perfStatSurveyInfoDialog, this.frame);
        this.frame.setAlwaysOnTop(true);
        SetFrameOnTopThread frameOnTopThread = new SetFrameOnTopThread(this.frame);
        ThreadPoolManager.getInstance().execute(frameOnTopThread);
        perfStatSurveyInfoDialog.setVisible(true);
        this.frame.requestFocusInWindow();
    }

    public void closeMagnifier() {
        this.isMagnify = false;
        this.add((Component)this.chart, "Center");
        this.revalidate();
    }

    public TimeSeries getOrCreate(String key, Color color) {
        TimeSeries timeSeries = this.chart.getSeries((Comparable<?>)((Object)key));
        boolean isNeedSetColor = false;
        if (null == timeSeries) {
            isNeedSetColor = true;
        }
        TimeSeries temp = this.chart.getOrCreate((Comparable<?>)((Object)key));
        if (isNeedSetColor && color != null) {
            this.colorMap.put(key, color);
            this.resetColor();
        }
        return temp;
    }

    private void resetColor() {
        for (Map.Entry<String, Color> entry : this.colorMap.entrySet()) {
            this.chart.setSeriesColor((Comparable)((Object)entry.getKey()), entry.getValue());
        }
    }

    public List<TimeSeries> getAllSeries() {
        return this.chart.getAllSeries();
    }

    public void removeSeriesByKey(String key) {
        this.chart.removeSeriesByKey(key);
        this.colorMap.remove(key);
        this.resetColor();
    }

    public void removeAllSeries() {
        this.chart.removeAllSeries();
        this.colorMap.clear();
    }

    public void setTimeZone(TimeZone timeZone) {
        this.chart.setTimeZone(timeZone);
    }

    public void setDataFormat(SimpleDateFormat dateFormat) {
        this.chart.setDataFormat(dateFormat);
    }

    public void setAutoRange(long autoRange) {
        this.chart.setAutoRange(autoRange);
    }

    public void addData(String key, Color color, Collection<XYTimeSeriesData> datas) {
        this.chart.addData(key, datas);
        this.colorMap.put(key, color);
        this.resetColor();
    }

    public TimeSeriesChart getChart() {
        return this.chart;
    }

    public JLabel getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title.setText(title);
    }

    public void setToolTipGenerator(NormalPerfStatXYToolTipGenerator generator) {
        this.chart.setToolTipGenerator((XYToolTipGenerator)generator);
    }

    public DateAxis getAxisX() {
        return this.chart.getAxisX();
    }

    public void setDateAxisFormat(SimpleDateFormat dateFormat) {
        this.chart.setDateAxisFormat(dateFormat);
    }

    public void setTitleMaxWidth(int titleMaxWidth) {
        FontMetrics fontMetrics = this.title.getFontMetrics(this.title.getFont());
        int length = fontMetrics.stringWidth(this.title.getText());
        int min = length > titleMaxWidth ? titleMaxWidth : length;
        this.title.setPreferredSize(new Dimension(min, 14));
    }
}

