/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util.parser;

import com.huawei.ism.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileOutStreamParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileOutStreamParser.class);
    private String fileAbsolutePath = "";
    private FileOutputStream fileOutputStream = null;

    public FileOutStreamParser(String fileAbsolutePath) throws FileNotFoundException {
        this.fileAbsolutePath = fileAbsolutePath;
        File file = new File(Utils.fixFotifyPathManipulation(fileAbsolutePath));
        File dir = file.getParentFile();
        if (dir.isFile() && !dir.delete()) {
            LOGGER.info("delete fail.");
        }
        if (!dir.exists() && !dir.mkdirs()) {
            LOGGER.info("mkdirs fail.");
        }
        this.fileOutputStream = new FileOutputStream(file);
    }

    public FileOutStreamParser(String filePrefix, String fileSuffix) throws IOException {
        File tempDir = File.createTempFile("IsmV100R001" + filePrefix, '.' + fileSuffix);
        tempDir.deleteOnExit();
        this.fileAbsolutePath = tempDir.getCanonicalPath();
        this.fileOutputStream = new FileOutputStream(tempDir);
    }

    public void close() throws IOException {
        if (null != this.fileOutputStream) {
            this.fileOutputStream.close();
        }
    }

    public String getAbsolutePath() {
        return this.fileAbsolutePath;
    }

    public void writeFileFromStream(InputStream stream) throws IOException {
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = stream.read(b)) > 0) {
            this.fileOutputStream.write(b, 0, len);
        }
    }
}

