/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.util.NetUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A3000Connection
extends RestConnection {
    private static final Logger log = LoggerFactory.getLogger(A3000Connection.class);
    public static final String INCORRECT_ACCOUNT_EXCEPTION_ID = "devicemanager.layout.device.rest.connection.a3000.password.is.wrong";
    private static final String HTTPS_PREFIX = "https://";
    private static final String QUERY_ESN_URI = "/fce/framework/v1/license/esn";
    private static final List<String> INCORRECT_ACCOUNT_ERROR_CODE = Arrays.asList("04040007", "04042301");
    private static final List<String> NEED_RE_LOGIN_ERROR_CODE = Collections.unmodifiableList(Arrays.asList("04040183"));
    private static final String LOGIN_URL = "/fce/framework/v1/iam/auth/login";
    private static final String VERSION_URL = "/fce/framework/v1/site/info";
    private static final String LOGOUT_URL = "/fce/framework/v1/sessions/clear";

    public A3000Connection(DevNode devNode) {
        super(devNode);
        this.uri = HTTPS_PREFIX + this.parseIp() + LOGIN_URL;
    }

    private String parseIp() {
        String ip = this.devNode.getIp();
        if (NetUtil.isIPV6((String)ip)) {
            ip = "[" + ip + "]";
        }
        return ip;
    }

    @Override
    public String getBaseUrl() {
        return HTTPS_PREFIX + this.parseIp();
    }

    public String getLoginUrl() {
        return HTTPS_PREFIX + this.parseIp() + LOGIN_URL;
    }

    public String getQueryEsnUrl() {
        return this.getBaseUrl() + QUERY_ESN_URI;
    }

    public String getVersionUrl() {
        return this.getBaseUrl() + VERSION_URL;
    }

    @Override
    public void logOut() {
        String loginOutUrl = this.getBaseUrl() + LOGOUT_URL;
        try {
            this.execPost(loginOutUrl, "");
        }
        catch (ToolException e) {
            log.error("logout error:", (Throwable)e);
        }
    }

    @Override
    public void closeSession() {
        super.closeSession();
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        req.addParam("username", this.devNode.getLoginUser().getUserName());
        req.addParam("password", this.devNode.getLoginUser().getPassword());
        req.setHeader("Content-Type", "application/json");
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("X-Auth-Token", this.session.getToken());
        req.setHeader("Content-Type", "application/json");
        req.setHeader("Accept-Language", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) throws ToolException {
        if (resp == null) {
            return false;
        }
        log.info("start to check a3000 login result.");
        String content = resp.getContent();
        if (StringUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        JSONObject json = JSON.parseObject((String)content);
        String errorCode = json.getString("code");
        JSONObject dataContent = json.getJSONObject("data");
        String token = "";
        if (dataContent != null && dataContent.containsKey((Object)"token")) {
            token = dataContent.getString("token");
        }
        if (StringUtils.isNotEmpty((CharSequence)errorCode) && !errorCode.equals("0") || StringUtils.isEmpty((CharSequence)token)) {
            log.error("login failed,resp={}", (Object)content);
            if (INCORRECT_ACCOUNT_ERROR_CODE.contains(errorCode)) {
                throw new ToolException(INCORRECT_ACCOUNT_EXCEPTION_ID);
            }
            return false;
        }
        this.session.setToken(token);
        return true;
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        JSONObject json;
        String code;
        String content = resp.getContent();
        if (!StringUtils.isEmpty((CharSequence)content) && NEED_RE_LOGIN_ERROR_CODE.contains(code = (json = JSON.parseObject((String)content)).getString("code"))) {
            log.info("Need to relogin, errorcode is {}", (Object)code);
            return true;
        }
        return false;
    }
}

