/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.rest.iterf.IRestConn;
import com.huawei.ism.tool.safe.SensitiveInfoFilter;
import com.huawei.json.JSONObject;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A800DpcRequestConnection
extends RestConnection {
    private static final Logger log = LoggerFactory.getLogger(A800DpcRequestConnection.class);
    private String systemEsn;

    public A800DpcRequestConnection(DevNode devNode) {
        super(devNode, devNode.isDsStorage());
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) throws ToolException {
        int code = resp.getStatusLine().getStatusCode();
        if (code != 200) {
            log.error("receive a bad http status code {} , response : {} ", (Object)code, (Object)SensitiveInfoFilter.filter(resp.getContent()));
            throw new ToolException("http.authorized.failed");
        }
        String content = resp.getContent();
        JSONObject json = new JSONObject(content);
        if (!json.has("data")) {
            throw new ToolException("http.authorized.failed");
        }
        this.session.setToken(this.getJsonValue("x_auth_token", json.getJSONObject("data")));
        this.systemEsn = this.getJsonValue("system_esn", json.getJSONObject("data"));
        return true;
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("X-Auth-Token", this.session.getToken());
    }

    @Override
    public ResponseInfo execPost(String url, String param, IRestConn.RestParamEntity entity) throws ToolException {
        String newUrl = url;
        if (url.contains("{SYSTEM_ESN}")) {
            newUrl = url.replace("{SYSTEM_ESN}", this.systemEsn);
        }
        return this.execPost(newUrl, param, entity, null);
    }
}

