/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.util.NetUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FusionCubeConnection
extends RestConnection {
    private static final Logger log = LoggerFactory.getLogger(FusionCubeConnection.class);
    public static final int FCE_PORT = 443;
    public static final String INCORRECT_ACCOUNT_EXCEPTION_ID = "devicemanager.layout.device.rest.connection.fusioncube.password.is.wrong";
    private static final String HTTPS_PREFIX = "https://";
    private static final String SESSION_URI = "/fce/login";
    private static final String STORAGE_DM_PORT = "8088";
    private static final String QUERY_STORAGE_INFO_URI = "/fce/device-manager/v1/device/info/list";
    private static final String OEM_PROPERYIES = "system.properties";
    private static final String APP_NAME = "app.name";
    private static final String OEM = "oem";
    private static final List<String> INCORRECT_ACCOUNT_ERROR_CODE = Arrays.asList("04040007", "04042301");
    private static final List<String> NEED_RE_LOGIN_ERROR_CODE = Collections.unmodifiableList(Arrays.asList("04040183"));
    private static final String VERSION_URL = "/fce/framework/v1/site/info";
    private static final String INIT_STATUS_URL = "/fce/operation/v1/initialize/status";
    private static final String DEVICE_LIST_URL = "/fce/device-manager/v1/device/devices";
    private static final String CUBE_URL_PREFIX = "/fce/device-manager/v1";
    private static final String LOGOUT_URL = "/fce/framework/v1/sessions/clear";

    public FusionCubeConnection(DevNode devNode) {
        super(devNode);
        this.uri = HTTPS_PREFIX + this.parseIp() + SESSION_URI;
    }

    private String parseIp() {
        String ip = this.devNode.getIp();
        if (NetUtil.isIPV6((String)ip)) {
            ip = "[" + ip + "]";
        }
        return ip;
    }

    public String getDeviceListUrl() {
        return this.getBaseUrl() + DEVICE_LIST_URL;
    }

    @Override
    public String getBaseUrl() {
        return HTTPS_PREFIX + this.parseIp();
    }

    public String getLoginUrl() {
        return HTTPS_PREFIX + this.parseIp() + SESSION_URI;
    }

    public String getQueryStorageInfoUrl() {
        return this.getBaseUrl() + QUERY_STORAGE_INFO_URI;
    }

    public String getVersionUrl() {
        return this.getBaseUrl() + VERSION_URL;
    }

    public String getInitStatusUrl() {
        return this.getBaseUrl() + INIT_STATUS_URL;
    }

    @Override
    public void logOut() {
        String loginOutUrl = this.getBaseUrl() + LOGOUT_URL;
        try {
            this.execPost(loginOutUrl, "");
        }
        catch (ToolException e) {
            log.error("logout error:", (Throwable)e);
        }
    }

    @Override
    public void closeSession() {
        super.closeSession();
    }

    @Override
    protected void setLoginParam(RequestInfo req) {
        req.addParam("username", this.devNode.getLoginUser().getUserName());
        req.addParam("password", this.devNode.getLoginUser().getPassword());
        req.setHeader("Content-Type", "application/json");
    }

    @Override
    protected void createHeader(RequestInfo req, Map headerParam) {
        req.setHeader("X-Auth-Token", this.session.getToken());
        req.setHeader("Content-Type", "application/json");
        req.setHeader("Accept-Language", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
    }

    @Override
    protected boolean checkLoginResult(ResponseInfo resp) throws ToolException {
        if (resp == null) {
            return false;
        }
        log.info("check fce login result.");
        String content = resp.getContent();
        if (StringUtils.isEmpty((CharSequence)content)) {
            return false;
        }
        JSONObject json = JSON.parseObject((String)content);
        String errorCode = json.getString("code");
        JSONObject dataContent = json.getJSONObject("data");
        String token = "";
        if (dataContent != null && dataContent.containsKey((Object)"token")) {
            token = dataContent.getString("token");
        }
        if (StringUtils.isNotEmpty((CharSequence)errorCode) && !errorCode.equals("0") || StringUtils.isEmpty((CharSequence)token)) {
            log.error("login failed,resp={}", (Object)content);
            if (INCORRECT_ACCOUNT_ERROR_CODE.contains(errorCode)) {
                throw new ToolException(INCORRECT_ACCOUNT_EXCEPTION_ID);
            }
            return false;
        }
        this.session.setToken(token);
        return true;
    }

    @Override
    public boolean isNeedReLogin(ResponseInfo resp) {
        JSONObject json;
        String code;
        String content = resp.getContent();
        if (!StringUtils.isEmpty((CharSequence)content) && NEED_RE_LOGIN_ERROR_CODE.contains(code = (json = JSON.parseObject((String)content)).getString("code"))) {
            log.info("start to relogin.");
            return true;
        }
        return false;
    }
}

