/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.rest;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.rest.entity.RequestInfo;
import com.huawei.ism.tool.protocol.rest.entity.UrlFormatException;
import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostRequestByFile
extends RequestInfo {
    private static final Logger log = LoggerFactory.getLogger(PostRequestByFile.class);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(PostRequestByFile.class);
    private File file;
    private String filePartName = "file";
    private List<String> clusterNodeIds;

    public PostRequestByFile(String url, File file) {
        super(url);
        this.file = file;
    }

    public PostRequestByFile(String url, String filePartName, File file) {
        this(url, file);
        this.filePartName = filePartName;
    }

    public PostRequestByFile(String url, File file, List<String> nodes) {
        this(url, file);
        this.clusterNodeIds = nodes;
    }

    public PostRequestByFile(String url, String encoding) {
        super(url, encoding);
    }

    @Override
    public HttpUriRequestBase getHttpUriRequest(String encoding) {
        HttpPost httpPost;
        try {
            httpPost = new HttpPost(this.normalizeUrl(this.getURL()));
        }
        catch (IllegalArgumentException | URISyntaxException e) {
            log.error("Invalid url is: {} ", (Object)this.getURL());
            throw new UrlFormatException(e);
        }
        MultipartEntityBuilder reqEntity = MultipartEntityBuilder.create().setMode(HttpMultipartMode.LEGACY);
        FileBody fileBody = new FileBody(this.file);
        reqEntity.addPart((String)StringUtils.defaultIfEmpty((CharSequence)this.filePartName, (CharSequence)"file"), (ContentBody)fileBody);
        if (this.clusterNodeIds != null) {
            for (String nodeId : this.clusterNodeIds) {
                reqEntity.addTextBody("node_ids", nodeId);
                HttpEntity multiPartEntity = reqEntity.build();
                httpPost.setEntity(multiPartEntity);
            }
            LOGGER.info("select Ids = {}", (Object)this.clusterNodeIds.toString());
        } else {
            if (MapUtils.isNotEmpty(this.getParams())) {
                this.getParams().forEach((key, value) -> reqEntity.addTextBody(key, value.toString()));
            }
            HttpEntity multiPartEntity = reqEntity.build();
            httpPost.setEntity(multiPartEntity);
        }
        return httpPost;
    }
}

