/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.sftp;

import com.google.common.base.Stopwatch;
import com.huawei.common.devmgr.DeviceLocator;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.connection.ProxySOCKS5;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.connection.mina.SshUtils;
import com.huawei.ism.tool.obase.connection.support.SftpPermWrapper;
import com.huawei.ism.tool.obase.connection.support.SftpProgressMonitor;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.EntityUtils;
import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.PortUnreachableException;
import com.huawei.ism.tool.obase.exception.PwdException;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.sftp.SftpProgressInterface;
import com.huawei.ism.tool.protocol.sftp.SftpTransferProgress;
import com.huawei.ism.tool.protocol.sftp.SftpTsfWrapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.file.util.BasePath;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.sftp.client.SftpClient;
import org.apache.sshd.sftp.client.SftpClientFactory;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.apache.sshd.sftp.client.fs.SftpPath;
import org.apache.sshd.sftp.common.SftpException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpTransfer {
    private static final Logger log = LoggerFactory.getLogger(SftpTransfer.class);
    public static final int DEFAULT_PORT = 22;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SftpTransfer.class);
    private static final int MAX_RETRY_TIMES = 3;
    private static final int MAX_FILE_LENGTH = 255;
    private static final int RETRY_DELAY = 10000;
    private int retryTimes = 0;
    private static int globalRetryTimes = 0;
    private static int globalRetryInterval = 10000;
    private int retryInterval = 0;
    private SftpClient sftpClient;
    private ClientSession session;
    private SftpTransferProgress sftpTansferProgress = new SftpTransferProgress();
    private DevNode dev = null;
    private boolean pwdWillExpireBreak = false;
    private SshConnection connection;
    private static Map<String, SftpFileSystem> fsClientCacheMap = new HashMap<String, SftpFileSystem>();

    public void setRetryInterval(int retryInterval) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Thread name :" + Thread.currentThread().getName() + " id : " + Thread.currentThread().getId() + "set sftp interval to:" + this.retryTimes + " dev:" + this.dev.getIp());
        }
        this.retryInterval = retryInterval;
    }

    public int getRetryInterval() {
        return this.retryInterval != 0 ? this.retryInterval : globalRetryInterval;
    }

    public static int getGlobalRetryInterval() {
        return globalRetryInterval;
    }

    public static void setGlobalRetryInterval(int globalRetryInterval) {
        SftpTransfer.globalRetryInterval = globalRetryInterval;
    }

    public static void downloadFile(String localPath, String serverFilePath, SftpClient sftp) throws IOException {
        Path localFilePath = Paths.get(localPath, new String[0]);
        if (new File(localPath).isDirectory()) {
            localFilePath = Paths.get(localPath, new File(serverFilePath).getName());
        }
        try (InputStream inputStream = sftp.read(serverFilePath);){
            Files.copy(inputStream, localFilePath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void uploadFile(String serverPath, String localPath, SftpClient sftp) throws IOException {
        String serverFile = "";
        try {
            serverFile = sftp.lstat(serverPath).isDirectory() ? serverPath + "/" + new File(localPath).getName() : serverPath;
        }
        catch (SftpException e) {
            log.error("protocol ls server file path error. server path is file.", (Throwable)e);
            serverFile = serverPath;
        }
        SftpFileSystem fs = SftpTransfer.getSftpFileSystem(sftp);
        BasePath remote = fs.getDefaultDir().resolve(serverFile);
        if (ApplicationContext.getInstance().isSftpChannel()) {
            SftpTransfer.uploadFileFully(sftp, Paths.get(localPath, new String[0]), (Path)remote);
        } else {
            SftpTransfer.uploadFile(localPath, sftp, (Path)remote);
        }
        log.info("protocol upload success!");
    }

    private static SftpFileSystem getSftpFileSystem(SftpClient sftp) throws IOException {
        String sessionAddress = sftp.getSession().getConnectAddress().toString();
        SftpFileSystem fs = fsClientCacheMap.get(sessionAddress);
        if (fs == null || !fs.isOpen()) {
            fs = SftpClientFactory.instance().createSftpFileSystem(sftp.getSession());
            fsClientCacheMap.put(sessionAddress, fs);
        }
        return fs;
    }

    public boolean isExistFile(String serverPath) {
        try {
            this.sftpClient.lstat(serverPath);
        }
        catch (IOException e) {
            log.error("protocol ls server file path error. server path is file:{}", (Object)e.getMessage());
            return false;
        }
        log.info("file is exist.");
        return true;
    }

    private static void uploadFile(String localPath, SftpClient sftp, Path remote) throws IOException {
        Stopwatch watch = Stopwatch.createStarted();
        try (SftpClient.CloseableHandle handle = sftp.open(remote.toString(), new SftpClient.OpenMode[]{SftpClient.OpenMode.Write, SftpClient.OpenMode.Create});
             BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(Paths.get(localPath, new String[0]), new OpenOption[0]));){
            int len;
            byte[] srcBuf = new byte[0x100000];
            long fileOffset = 0L;
            while ((len = bufferedInputStream.read(srcBuf)) != -1) {
                sftp.write((SftpClient.Handle)handle, fileOffset, srcBuf, 0, len);
                fileOffset += (long)len;
            }
            log.info("sftp transfer from file {} cost: {}", (Object)remote.getFileName(), (Object)watch.stop());
        }
        catch (IOException e) {
            log.error("sftp upload File failed", (Throwable)e);
            throw e;
        }
    }

    private static void uploadFileFully(SftpClient sftpClient, Path localFile, Path remoteFile) throws IOException {
        try (FileChannel remoteChannel = sftpClient.openRemoteFileChannel(remoteFile.toString(), new SftpClient.OpenMode[]{SftpClient.OpenMode.Write, SftpClient.OpenMode.Create});
             FileChannel localChannel = FileChannel.open(localFile, new OpenOption[0]);){
            Stopwatch watch = Stopwatch.createStarted();
            remoteChannel.transferFrom(localChannel, 0L, Files.size(localFile));
            log.info("sftp transfer from file {} cost: {}", (Object)remoteFile.getFileName(), (Object)watch.stop());
        }
    }

    public int getRetryTimes() {
        return this.retryTimes == 0 ? globalRetryTimes : this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Thread name :" + Thread.currentThread().getName() + " id : " + Thread.currentThread().getId() + "set Sftp times to:" + retryTimes + " dev:" + this.dev.getIp());
        }
        this.retryTimes = retryTimes;
    }

    public static int getGlobalRetryTimes() {
        return globalRetryTimes;
    }

    public static void setGlobalRetryTimes(int globalRetryTimes) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Thread name :" + Thread.currentThread().getName() + " id : " + Thread.currentThread().getId() + "set Sftp global times to:" + globalRetryTimes);
        }
        SftpTransfer.globalRetryTimes = globalRetryTimes;
    }

    public SftpTransferProgress getSftpTansferProgress() {
        return this.sftpTansferProgress;
    }

    public SftpTransfer(boolean isPwdWillExpireBreak) {
        this.pwdWillExpireBreak = isPwdWillExpireBreak;
    }

    public SftpTransfer(DevNode dev, boolean isPwdWillExpireBreak) {
        this(isPwdWillExpireBreak);
        this.dev = dev;
    }

    public void closeConnection() {
        try {
            if (this.sftpClient != null) {
                this.sftpClient.close();
            }
            if (null != this.session) {
                this.session.close();
                this.session = null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Close Sftp Error!", (Throwable)e);
        }
    }

    public void prepareSessionWithDefault(User defaultUser, String defaultIp, int defaultPort) throws IsmException {
        if (this.sftpClient != null && this.sftpClient.isOpen() && this.session != null && this.session.isOpen()) {
            return;
        }
        this.closeConnection();
        if (this.dev != null) {
            this.createSession(this.dev.getLoginUser(), this.dev.getIp(), 22);
        } else {
            this.createSession(defaultUser, defaultIp, defaultPort);
        }
    }

    private void createSession(User user, String hostIP, int port) throws IsmException {
        ProxySOCKS5 proxyData = null;
        String actualHostIp = hostIP;
        int actualPort = port;
        if (null != this.dev) {
            try {
                this.connection = (SshConnection)SshConnectionManager.getSshConnection(this.dev, null, this.pwdWillExpireBreak, false);
                actualHostIp = this.connection.getHost();
                actualPort = this.connection.getPort();
            }
            catch (PortUnreachableException e) {
                throw new IsmException(e.getDes(), (Throwable)e);
            }
            catch (ToolException e) {
                throw new IsmException(e.getErrorId(), (Throwable)e);
            }
            catch (PwdException e) {
                throw new IsmException(e.getErrorMsg(), (Throwable)e);
            }
            if (null != this.dev.getSocks5Proxy()) {
                Socks5Proxy proxy = this.dev.getSocks5Proxy();
                proxyData = new ProxySOCKS5(proxy.getServerIp(), Integer.valueOf(proxy.getPort()));
                if (proxy.isAuthentic()) {
                    String pwd = proxy.getPass();
                    proxyData.setUserPasswd(proxy.getUser(), pwd);
                    pwd = null;
                }
            }
        }
        if (null != this.session && this.session.isOpen()) {
            return;
        }
        this.countRetryTime(user, actualHostIp, actualPort, proxyData);
    }

    private void countRetryTime(User user, String hostIP, int port, ProxySOCKS5 proxyData) {
        int retryTime = 0;
        String actualHostIp = hostIP;
        int actualPort = port;
        while (true) {
            try {
                if (null == this.session || !this.session.isOpen()) {
                    this.fetchSessionIfneeded(user, actualHostIp, actualPort, proxyData);
                }
                this.sftpClient = SftpClientFactory.instance().createSftpClient(this.session);
                retryTime = 0;
            }
            catch (IOException e) {
                if (null == this.dev) {
                    LOGGER.error("the dev is null", (Throwable)e);
                    return;
                }
                boolean useSshForwrd = this.dev.getSshForwardList() != null && !this.dev.getSshForwardList().isEmpty();
                this.reBuildConnIfUseForawrd(useSshForwrd);
                if (useSshForwrd) {
                    actualHostIp = this.connection.getHost();
                    actualPort = this.connection.getPort();
                }
                LOGGER.error("try to connect to the sftp server failed, the " + ++retryTime + "th time.", (Throwable)e);
                this.checkIfTryEnd(retryTime, e);
                this.beforTryNeedDo();
                continue;
            }
            break;
        }
    }

    private void beforTryNeedDo() {
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    private void checkIfTryEnd(int retryTime, Exception exception) {
        if (retryTime > 3) {
            if (exception.getMessage().equals("Auth fail") || exception.getMessage().equals("Auth cancel")) {
                throw new IsmException(1073949186L, (Throwable)exception);
            }
            throw new IsmException(1073949187L, (Throwable)exception);
        }
    }

    private void reBuildConnIfUseForawrd(boolean useSshForwrd) {
        try {
            if (useSshForwrd) {
                SshConnectionManager.releaseConnection(this.connection);
                this.connection = (SshConnection)SshConnectionManager.getSshConnection(this.dev, null, this.pwdWillExpireBreak, false);
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Attention:rebuild tunnelconn success! devIp:" + this.dev.getIp() + " SN:" + this.dev.getDeviceSerialNumber());
                }
            }
        }
        catch (ToolException ee) {
            LOGGER.error("rebuild tunnelconn error:" + ee.getErrorId(), (Throwable)ee);
        }
        catch (PwdException ee) {
            LOGGER.error("rebuild tunnelconn error:" + ee.getErrorMsg(), (Throwable)ee);
        }
        catch (Exception e) {
            LOGGER.error("rebuild tunnelconn error:", (Throwable)e);
        }
    }

    private void fetchSessionIfneeded(User user, String hostIP, int port, ProxySOCKS5 proxyData) throws IOException {
        int timeout = 300000;
        String pwd = user.getPassword();
        this.session = SshUtils.getSessionWithPublicKey(user.getUserName(), hostIP, port, pwd, this.getPublicKeyInfo(hostIP));
        CoreModuleProperties.IDLE_TIMEOUT.set((PropertyResolver)this.session, (Object)Duration.ofMinutes(30L));
        this.session.auth().verify(timeout, new CancelOption[0]);
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
    }

    private PriKeyInfo getPublicKeyInfo(String hostIP) {
        PriKeyInfo priKey;
        PriKeyInfo priKeyInfo = priKey = this.dev == null ? null : this.dev.getPriKey();
        if (priKey == null) {
            DevNode dn = EntityUtils.toOldDev(DeviceLocator.getDevNodeByKey((String)(this.dev == null ? hostIP : this.dev.getDevKey())));
            priKey = dn == null ? null : dn.getPriKey();
        }
        return priKey;
    }

    public int getCurrentStep() {
        long fileSize = this.sftpTansferProgress.getFileSize();
        long finishSize = this.sftpTansferProgress.getFinishSize();
        if (0L == fileSize) {
            return 0;
        }
        int step = (int)(finishSize * 100L / fileSize);
        long tmp = finishSize * 100L % fileSize;
        if (tmp != 0L) {
            ++step;
        }
        if (step > 100) {
            step = 100;
        }
        return step;
    }

    public void transferDirFromDevice(String serverIP, String serverPath, String localPath, User user) throws IsmException {
        this.transferDirFromDevice(serverIP, serverPath, localPath, user, 22);
    }

    public void transferDirFromDevice(String serverIP, String serverPath, String localPath, User user, int port) throws IsmException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("TransferFileFromDevice,localDir" + localPath);
        }
        try {
            this.createSession(user, serverIP, port);
            for (SftpClient.DirEntry dirEntry : this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(serverPath))) {
                this.degreeTransfer(serverIP, serverPath, localPath, user, port, dirEntry);
            }
        }
        catch (IOException e) {
            log.error("transferFileFromDevice fail once.user SftpException:", (Throwable)e);
            throw new IsmException(1073949187L, (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        LOGGER.info("transferFileFromDevice over.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void degreeTransfer(String serverIP, String serverPath, String localPath, User user, int port, SftpClient.DirEntry le) {
        String longName = le.getLongFilename();
        String fileName = le.getFilename();
        try {
            if (!longName.startsWith("dr")) {
                this.transferFileDown(serverIP, user, port, serverPath + "/" + fileName, localPath);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * Exception decompiling
     */
    private void transferFileDown(String hostIP, User user, int port, String serverRelativePath, String localPath) throws IsmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sleepSomeTime(int interval) {
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException e) {
            LOGGER.error("error!", (Throwable)e);
        }
    }

    private void doDownload(String hostIP, User user, int port, String serverRelativePath, String localPath) throws IOException {
        this.createSession(user, hostIP, port);
        SftpTransfer.downloadFile(localPath, serverRelativePath, this.sftpClient);
    }

    /*
     * Exception decompiling
     */
    private void transferFileUp(String hostIP, User user, int port, String serverRelativePath, String localPath) throws IsmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doUpload(String hostIP, User user, int port, String serverRelativePath, String localPath) throws SftpException {
        this.createSession(user, hostIP, port);
        SftpTsfWrapper transfer = new SftpTsfWrapper(this.connection, (SftpProgressMonitor)this.sftpTansferProgress, this.sftpClient, localPath);
        transfer.uploadWithPermHandle(serverRelativePath);
    }

    public void transferFileFromDevice(String serverIP, String serverPath, String localPath, User user) throws IsmException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("transferFileFromDevice,localPath" + localPath);
        }
        try {
            this.transferFileDown(serverIP, user, 22, serverPath, localPath);
        }
        catch (IsmException e) {
            LOGGER.error("Sftp Fail. serverIp:" + serverIP);
            throw e;
        }
        finally {
            this.closeConnection();
        }
        LOGGER.info("transferFileFromDevice over.");
    }

    public void transferFileToDevice(String serverIP, String localPath, String serverPath, User user) throws IsmException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("TransferFileToDevice,localPath:" + localPath);
        }
        try {
            this.transferFileUp(serverIP, user, 22, serverPath, localPath);
        }
        catch (IsmException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("transferFileToDevice error:" + user);
            }
            throw e;
        }
        finally {
            this.closeConnection();
        }
        LOGGER.info("transferFileToDevice over.");
    }

    public void closeSshConnection() {
        if (null != this.dev && null != this.connection) {
            SshConnectionManager.releaseConnection(this.connection);
        }
    }

    public void putFile(String devIp, String localPath, String serverPath, User user, SftpProgressInterface progressListener) throws IsmException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("putFile , localPath:" + localPath);
        }
        try {
            this.sftpTansferProgress.setProgressInterface(progressListener);
            this.transferFileUp(devIp, user, 22, serverPath, localPath);
        }
        catch (IsmException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("transferFileToDevice error:" + user);
            }
            throw e;
        }
        finally {
            this.sftpTansferProgress.setProgressInterface(null);
            this.sftpTansferProgress.setFinishSize(0L);
            this.closeConnection();
        }
        LOGGER.info("transferFileToDevice over.");
    }

    public void getFile(String serverIP, String localPath, String serverPath, User user, SftpProgressInterface progressListener) throws IsmException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("getFile , localPath:" + localPath);
        }
        try {
            this.sftpTansferProgress.setProgressInterface(progressListener);
            this.transferFileDown(serverIP, user, 22, serverPath, localPath);
        }
        catch (IsmException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("transferFileToDevice error:" + user);
            }
            throw e;
        }
        finally {
            this.sftpTansferProgress.setProgressInterface(null);
            this.sftpTansferProgress.setFinishSize(0L);
            this.closeConnection();
        }
        LOGGER.info("transferFileToDevice over.");
    }

    public void transferStreamToDevice(String hostIP, User user, int port, String serverFileName, InputStream localStream) throws IsmException {
        this.createSession(user, hostIP, port);
        try {
            SftpPermWrapper transfer = new SftpPermWrapper(this.connection, (SftpProgressMonitor)this.sftpTansferProgress, this.sftpClient, localStream);
            transfer.uploadWithPermHandle(serverFileName);
        }
        catch (Exception e) {
            throw new IsmException("", (Throwable)e);
        }
    }

    public void transferStreamToDevice(String hostIP, User user, String serverFileName, InputStream localStream) throws IsmException {
        this.transferStreamToDevice(hostIP, user, 22, serverFileName, localStream);
    }

    public void uploadFile(String serIp, User user, String serFilePath, String localFilePath) throws IOException {
        try {
            this.createSession(user, serIp, 22);
            this.mkdirs(serFilePath);
            SftpTransfer.uploadFile(serFilePath, localFilePath, this.sftpClient);
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("transferFileToDevice error:" + user);
            }
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createDirs(String remoteDirPath) {
        this.mkdirs(remoteDirPath);
        try (SftpClient.CloseableHandle ignoredHandle = this.sftpClient.openDir(remoteDirPath);){
            boolean bl = true;
            return bl;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public OutputStream openRemoteFileToWrite(String remoteFilePath) throws IOException {
        SftpPath filePath = (SftpPath)SftpTransfer.getSftpFileSystem(this.sftpClient).getDefaultDir().resolve(remoteFilePath);
        this.mkdirs(((SftpPath)filePath.getParent()).toString());
        return this.sftpClient.write(filePath.toString());
    }

    public void uploadFiles(String serIp, User user, String serFilePath, String localFilePath) throws IOException {
        try {
            ArrayList<String> paths = new ArrayList<String>();
            File file = new File(localFilePath);
            this.getPaths(file, paths);
            this.createSession(user, serIp, 22);
            for (String str : paths) {
                String serName = new File(str.replace(localFilePath, "")).getParent();
                if (serName.contains("\\")) {
                    serName = serName.replaceAll("\\\\", "/");
                }
                String dir = serFilePath + "/" + serName;
                this.mkdirs(dir);
                SftpTransfer.uploadFile(dir, localFilePath, this.sftpClient);
            }
        }
        catch (IOException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("transferFileToDevice error.", (Object)user);
            }
            throw e;
        }
        finally {
            this.closeConnection();
        }
    }

    private void getPaths(File localFiles, List<String> paths) {
        if (!localFiles.exists()) {
            LOGGER.error("The input parameter file is abnormal.");
            return;
        }
        if (!localFiles.isDirectory()) {
            try {
                paths.add(localFiles.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("get path fail.", (Throwable)e);
            }
            return;
        }
        File[] files = localFiles.listFiles();
        if (files == null) {
            LOGGER.error("files is null!");
            return;
        }
        for (File file : files) {
            this.getPaths(file, paths);
        }
    }

    private void mkdirs(String serverPath) throws IsmException {
        LOGGER.info("mkdirs,serverDir:*****");
        try {
            String[] paths = serverPath.split("/");
            String relPath = "/";
            for (String s : paths) {
                if (StringUtils.isNULLStr(s)) continue;
                relPath = relPath + s + '/';
                try (SftpClient.CloseableHandle handle = this.sftpClient.openDir(relPath);){
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("mkdirs,serverDir:xxxxxx is exists " + handle);
                }
                catch (SftpException e) {
                    log.error("SftpException eid : ", (Throwable)e);
                    this.createDirectory(relPath, s, e);
                }
            }
        }
        catch (Exception e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("transferFileFromDevice fail once.user SftpException:", (Throwable)e);
            }
            throw new IsmException(1073949187L, (Throwable)e);
        }
        LOGGER.info("transferFileFromDevice over.");
    }

    protected void createDirectory(String relPath, String s, SftpException e) {
        try {
            String parentDir = relPath.substring(0, relPath.indexOf(s));
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("parentDir = " + parentDir);
            }
            this.sftpClient.mkdir(relPath);
            LOGGER.info("mkdirs,serverDir:*****", (Throwable)e);
        }
        catch (Exception e1) {
            try {
                if (Objects.isNull(this.connection)) {
                    LOGGER.warn("SFTP created using the temporary CLI, no need to use execute cmd!");
                    return;
                }
                this.connection.execCmd("mkdir -p " + relPath);
            }
            catch (Exception e2) {
                LOGGER.error("mkdir error", (Throwable)e);
                throw new EncapsulatedRuntimeException("create folder error.", (Throwable)e);
            }
        }
    }

    public boolean isPwdWillExpireBreak() {
        return this.pwdWillExpireBreak;
    }

    public void setPwdWillExpireBreak(boolean pwdWillExpireBreak) {
        this.pwdWillExpireBreak = pwdWillExpireBreak;
    }

    public void setSftpTansferProgress(SftpTransferProgress upgradeSftpTansferProgress) {
        this.sftpTansferProgress = upgradeSftpTansferProgress;
    }

    public synchronized boolean deleteFile(String hostIP, User user, String ... fileNames) throws ToolException {
        if (fileNames == null || fileNames.length == 0 || hostIP == null || user == null) {
            log.error("Parameter is not legal");
            return false;
        }
        try {
            this.createSession(user, hostIP, 22);
            for (String fileName : fileNames) {
                this.sftpClient.remove(fileName);
            }
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Remote file from remote error.", (Throwable)e);
            throw new ToolException("Remote file from remote error.", false, (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return true;
    }

    public synchronized boolean deleteDirectory(String hostIP, User user, String dirPath) throws ToolException {
        if (StringUtils.isNULLStr(dirPath) || hostIP == null || user == null) {
            log.error("Parameter is not legal");
            return false;
        }
        try {
            this.createSession(user, hostIP, 22);
            this.sftpClient.rmdir(dirPath);
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("Remote dir from remote error.", (Throwable)e);
            throw new ToolException("Remote dir from remote error.", false, (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return true;
    }

    public List<String> listFiles(@NotNull String hostIP, @NotNull User user, @NotNull String path, String filter) throws ToolException {
        ArrayList<String> fileList = new ArrayList<String>();
        if (path.length() > 255) {
            log.error("Parameter is not legal");
            return fileList;
        }
        String lsFilter = "*";
        if (!StringUtils.isNULLStr(filter)) {
            lsFilter = filter;
        }
        try {
            this.createSession(user, hostIP, 22);
            for (SftpClient.DirEntry dirEntry : this.sftpClient.listDir((SftpClient.Handle)this.sftpClient.openDir(path))) {
                fileList.add(dirEntry.getFilename());
            }
        }
        catch (IOException e) {
            log.error("get file from remote error.");
            throw new ToolException("get file from remote error.", false, (Throwable)e);
        }
        finally {
            this.closeConnection();
        }
        return fileList;
    }

    public SftpClient getChannelSftp() {
        if (this.sftpClient == null && this.dev != null) {
            this.createSession(this.dev.getLoginUser(), this.dev.getIp(), 22);
        }
        return this.sftpClient;
    }
}

