/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.tlv;

import com.huawei.ism.connection.TLVConnection;
import com.huawei.ism.tlv.TLVMOMsg;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.DataPackage;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.connection.MultiRouteManager;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.ProxySOCKS5;
import com.huawei.ism.tool.obase.entity.Socks5Proxy;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.SecurityConfigUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.ui.module.notification.GFCommon;
import com.huawei.ism.util.CommonUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class TLVConnectionImpl
implements ITLVConnection {
    public static final int MSG_HEAD_LENGTH = 28;
    public static final String USER_NAME = "USER_NAME";
    public static final String PWD = "PASSWORD";
    public static final String IP_OR_NAME = "IP_OR_NAME";
    public static final String PORT = "PORT";
    public static final String CONNECTION_PROXY = "CONNECTION_PROXY";
    private final Object lock = new Object();
    private BufferedInputStream bis = null;
    private BufferedOutputStream bos = null;
    private Socket socket = null;
    private String ip = null;
    private String userName = null;
    private long sessionKey = -1L;
    private String deviceID = null;
    private Socks5Proxy socks5Proxy = null;
    private List<MultiRouteNode> sshForwardNodes = null;
    private MultiRouteManager multiRouteManager = null;

    public String getDeviceID() {
        return this.deviceID;
    }

    public void setDeviceID(String deviceID) {
        this.deviceID = deviceID;
    }

    public void setSessionKey(long sessionKey) {
        this.sessionKey = sessionKey;
    }

    public synchronized boolean init(Properties properties) {
        this.userName = properties.getProperty(USER_NAME);
        this.ip = properties.getProperty(IP_OR_NAME);
        int port = 0;
        int timeOut = 0;
        int connType = 0;
        try {
            port = Integer.valueOf(properties.getProperty(PORT));
            timeOut = 30;
            if (properties.getProperty("TIME_OUT_PROPERTY") != null) {
                timeOut = Integer.valueOf(properties.getProperty("TIME_OUT_PROPERTY"));
            }
            connType = 0;
            if (properties.getProperty("CONN_PROTOCOL") != null) {
                connType = Integer.valueOf(properties.getProperty("CONN_PROTOCOL"));
            }
        }
        catch (NumberFormatException e) {
            throw new TLVException(0x100000001L, (Throwable)e);
        }
        if (this.socket != null && this.socket.isConnected()) {
            return true;
        }
        if (this.checkParam(port, connType, properties)) {
            throw new IllegalArgumentException();
        }
        try {
            this.createConnMath(port, connType, timeOut);
            this.bos = new BufferedOutputStream(this.socket.getOutputStream());
            this.bis = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (ToolException e) {
            throw new TLVException(e.getErrorLocaleDescription(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TLVException(0x100000001L, (Throwable)e);
        }
        return true;
    }

    private synchronized void createConnMath(int port, int connType, int timeOut) throws ToolException, IOException {
        if (null != this.socks5Proxy && null != this.sshForwardNodes && !this.sshForwardNodes.isEmpty()) {
            throw new TLVException("the connection seted socksProxy and seted sshForward");
        }
        if (null != this.sshForwardNodes && !this.sshForwardNodes.isEmpty()) {
            this.multiRouteManager = new MultiRouteManager(this.sshForwardNodes);
            int localPort = this.multiRouteManager.createForwarderLocalPort(this.ip, port);
            this.socket = this.connect("127.0.0.1", localPort, connType, timeOut);
        } else {
            this.socket = this.connect(this.ip, port, connType, timeOut);
        }
        this.socket.setReceiveBufferSize(0x100000);
        if (timeOut > 0) {
            this.socket.setSoTimeout(timeOut * 1000);
        }
    }

    private boolean checkParam(int port, int connType, Properties properties) {
        ToolLoggerFactory.getLogger(this.getClass()).error("Init:" + port + connType);
        String pwd = properties.getProperty("USER_WORD");
        boolean ret = this.isNullStr(this.userName) || this.isNullStr(pwd) || this.isNullStr(this.ip) || port < 0 || connType < 0;
        return ret;
    }

    private boolean isNullStr(String content) {
        return null == content || content.isEmpty();
    }

    private synchronized Socket connect(String socketIp, int port, int connType, int timeout) throws IOException {
        Socket soc = null;
        ProxySOCKS5 proxySOCKS5 = null;
        if (null != this.socks5Proxy) {
            proxySOCKS5 = new ProxySOCKS5(this.socks5Proxy.getServerIp(), Integer.valueOf(this.socks5Proxy.getPort()));
            if (this.socks5Proxy.isAuthentic()) {
                String pass = this.socks5Proxy.getPass();
                proxySOCKS5.setUserPasswd(this.socks5Proxy.getUser(), pass);
                pass = null;
            }
            proxySOCKS5.setDest(socketIp, port);
        }
        if (connType == 1) {
            try {
                soc = this.getSslSocket(socketIp, port, proxySOCKS5, "TLSv1.2", timeout);
            }
            catch (Exception e) {
                if (SecurityConfigUtil.isOnlySecurityAlgorithm()) {
                    throw e;
                }
                ToolLoggerFactory.getLogger(this.getClass()).error(e.toString(), (Throwable)e);
                soc = this.getSslSocket(socketIp, port, proxySOCKS5, "SSLv3", timeout);
            }
            return soc;
        }
        if (connType == 0) {
            if (null != proxySOCKS5) {
                return proxySOCKS5.connect();
            }
            try {
                soc = new Socket();
                InetSocketAddress address = new InetSocketAddress(socketIp, port);
                soc.connect(address);
                soc.setReuseAddress(true);
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("connect socket failed.", (Throwable)e);
                this.closeSocket(soc);
            }
            catch (Exception e1) {
                ToolLoggerFactory.getLogger(this.getClass()).error("connect socket failed.", (Throwable)e1);
                this.closeSocket(soc);
            }
            return soc;
        }
        throw new TLVException("connType error.");
    }

    private void closeSocket(Socket soc) {
        if (null != soc) {
            try {
                soc.close();
            }
            catch (Exception e2) {
                ToolLoggerFactory.getLogger(this.getClass()).error("connect socket failed.", (Throwable)e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket getSslSocket(String socketIp, int port, ProxySOCKS5 proxySOCKS5, String sslVersion, int timeout) throws IOException {
        Socket soc;
        block8: {
            soc = null;
            try {
                ToolLoggerFactory.getLogger(this.getClass()).info("Use ssl version: " + sslVersion);
                TrustManager[] tms = new TrustManager[]{new IsmTrustManager()};
                SSLContext context = SSLContext.getInstance(sslVersion);
                context.init(null, tms, SecureRandom.getInstanceStrong());
                SSLSocketFactory ssf = context.getSocketFactory();
                if (null != proxySOCKS5) {
                    soc = ssf.createSocket(proxySOCKS5.connect(), socketIp, port, false);
                    break block8;
                }
                soc = ssf.createSocket();
                if (sslVersion.equals("SSLv3")) {
                    SSLSocket tempSoc = (SSLSocket)CommonUtil.convertObject((Object)soc, SSLSocket.class);
                    tempSoc.setEnabledProtocols(new String[]{"SSLv3"});
                    ToolLoggerFactory.getLogger(this.getClass()).info("Success to enable SSLv3.");
                }
                InetSocketAddress address = new InetSocketAddress(socketIp, port);
                soc.connect(address, timeout * 1000);
                Object object = this.lock;
                synchronized (object) {
                    int ot = soc.getSoTimeout();
                    soc.setSoTimeout(20000);
                    SSLSocket tempSoc = (SSLSocket)CommonUtil.convertObject((Object)soc, SSLSocket.class);
                    tempSoc.startHandshake();
                    soc.setSoTimeout(ot);
                    soc.setReuseAddress(true);
                }
            }
            catch (RuntimeException e) {
                throw new IOException(e);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return soc;
    }

    @Override
    public synchronized void close() {
        if (null == this.socket) {
            return;
        }
        try {
            this.socket.close();
        }
        catch (Exception e) {
            throw new TLVException(0x100000001L, (Throwable)e);
        }
        finally {
            if (null != this.multiRouteManager) {
                StreamUtils.closeResource(null, this.multiRouteManager);
            }
            StreamUtils.closeStream(this.bos, this.bis);
        }
    }

    public void logout() {
        Param userNameParam = new Param(1, ParamType.STRING, this.userName);
        this.invoke(8596529153L, Arrays.asList(userNameParam));
    }

    public void sendCMD(long cmdWord, List<Param> tlvParams) throws ToolException {
        this.sendCMD(cmdWord, tlvParams, 30);
    }

    public void sendCMD(long cmdWord, List<Param> tlvParams, int timeout) throws TLVException {
        this.invoke(cmdWord, tlvParams, timeout);
    }

    public synchronized Record invoke(long cmdWord, List<Param> tlvParams) throws TLVException {
        return this.invoke(cmdWord, tlvParams, 30, (short)-3);
    }

    @Override
    public synchronized Record invoke(long cmdWord, List<Param> tlvParams, int timeout) throws TLVException {
        return this.invoke(cmdWord, tlvParams, timeout, (short)-3);
    }

    public synchronized Record invoke(long cmdWord, List<Param> tlvParams, int timeout, short nodeID) throws TLVException {
        List<Record> datas = this.getBatch(cmdWord, tlvParams, timeout, nodeID);
        return datas.isEmpty() ? null : datas.get(0);
    }

    public synchronized List<Record> getBatch(long cmdWord, List<Param> tlvParams) throws TLVException {
        return this.getBatch(cmdWord, tlvParams, 30, (short)-3);
    }

    @Override
    public synchronized List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout) throws TLVException {
        return this.getBatch(cmdWord, tlvParams, timeout, (short)-3);
    }

    public synchronized List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout, short nodeID) throws TLVException {
        TLVConnection.CMD_WORK_CONTRL node = -3 == nodeID ? TLVConnection.CMD_WORK_CONTRL.MASTER_CONTROLLER : TLVConnection.CMD_WORK_CONTRL.CURRENT_CONTROLLER;
        DataPackage sendData = TLVUtils.param2DP((long)cmdWord, (String)String.valueOf(this.sessionKey), tlvParams, (TLVConnection.CMD_WORK_CONTRL)node);
        DataPackage returnData = this.sendAndReceive(sendData, timeout);
        return returnData.getRecordset();
    }

    public synchronized List<Record> getNext(long cmdWord, Param param) throws TLVException {
        return this.getNext(cmdWord, param, 30, (short)-3);
    }

    @Override
    public synchronized List<Record> getNext(long cmdWord, Param param, int timeout) throws TLVException {
        return this.getNext(cmdWord, param, timeout, (short)-3);
    }

    public synchronized List<Record> getNext(long cmdWord, Param param, int timeOut, short nodeID) throws TLVException {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> tmpDatas = this.getBatch(cmdWord, (List<Param>)TLVUtils.singleItemList((Param)param), timeOut, nodeID);
        while (!tmpDatas.isEmpty()) {
            for (int i = 0; i < tmpDatas.size() - 1; ++i) {
                dataList.add(tmpDatas.get(i));
            }
            Record lastRecord = tmpDatas.get(tmpDatas.size() - 1);
            if (TLVUtils.containTag((Record)lastRecord, (int)4095)) {
                long errorcode = ((IsmInteger)lastRecord.getParamValue(4095)).longValue();
                if (errorcode == 1L) break;
                throw new TLVException(errorcode);
            }
            dataList.add(lastRecord);
            tmpDatas = this.getBatch(cmdWord, (List<Param>)TLVUtils.singleItemList((int)param.getIndex(), (ParamType)param.getType(), (Object)lastRecord.getParamValue(param.getIndex())), timeOut, nodeID);
        }
        return dataList;
    }

    private synchronized DataPackage sendAndReceive(DataPackage sendData, int timeout) throws TLVException {
        long receiveCode;
        long sendOpCode;
        this.clearBuff();
        this.tryRealSocket(sendData, timeout);
        DataPackage resultDP = null;
        do {
            byte[] result;
            try {
                byte[] receiveDataHead = new byte[28];
                this.fillBuffer(receiveDataHead);
                byte[] tmp4Byte = new byte[4];
                System.arraycopy(receiveDataHead, 8, tmp4Byte, 0, 4);
                System.arraycopy(receiveDataHead, 24, tmp4Byte, 0, 4);
                int bufferLength = GFCommon.bytes2int((byte[])tmp4Byte, (boolean)false);
                result = new byte[28 + bufferLength];
                byte[] receiveDataBuf = new byte[bufferLength];
                this.fillBuffer(receiveDataBuf);
                System.arraycopy(receiveDataHead, 0, result, 0, 28);
                System.arraycopy(receiveDataBuf, 0, result, 28, receiveDataBuf.length);
            }
            catch (RuntimeException e) {
                throw new TLVException(16797698L, (Throwable)e);
            }
            catch (Exception e) {
                throw new TLVException(16797698L, (Throwable)e);
            }
            resultDP = TLVUtils.decode((byte[])result);
            sendOpCode = sendData.getHead().getOperationCode();
            if (resultDP.getRecordset().isEmpty()) {
                ToolLoggerFactory.getLogger(this.getClass()).error("receive data record is empty.");
                throw new TLVException(16797698L);
            }
            receiveCode = ((Record)resultDP.getRecordset().get(0)).getMsgCode();
            ToolLoggerFactory.getLogger(this.getClass()).info("send data op code:" + sendOpCode + ", receive data op code: " + receiveCode);
            this.getIsTlvLog(sendData, resultDP);
        } while (sendOpCode != receiveCode && receiveCode != 0L);
        return resultDP;
    }

    private void getIsTlvLog(DataPackage sendData, DataPackage resultDP) {
        if (StringUtils.getCheckItemValue((String)"is.print.tlv.log")) {
            ToolLoggerFactory.getLogger(this.getClass()).info("SEND TO " + this.socket.getRemoteSocketAddress() + ":" + System.lineSeparator() + sendData.toString());
            ToolLoggerFactory.getLogger(this.getClass()).info("RECEIVE FROM " + this.socket.getRemoteSocketAddress() + ":" + System.lineSeparator() + resultDP.getHead().toString() + ",result data:" + resultDP.getRecordset());
        }
    }

    private void tryRealSocket(DataPackage sendData, int timeout) {
        try {
            this.socket.setSoTimeout(timeout * 1000);
            this.bos.write(sendData.toByteArray());
            this.bos.flush();
        }
        catch (RuntimeException e) {
            this.close();
            throw new TLVException(0x1005001L, (Throwable)e);
        }
        catch (Exception e) {
            this.close();
            throw new TLVException(0x1005001L, (Throwable)e);
        }
    }

    private void clearBuff() {
        if (null == this.bis) {
            return;
        }
        int readFlag = -1;
        try {
            int length = this.bis.available();
            if (length > 0) {
                byte[] buf = new byte[length];
                readFlag = this.bis.read(buf);
                Thread.sleep(200L);
                String result = new String(buf, "UTF-8");
                ToolLoggerFactory.getLogger(this.getClass()).info("clear buff msg: " + result);
            } else {
                ToolLoggerFactory.getLogger(this.getClass()).info("tlv is no cmd buff. don't need clear.");
            }
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("clear input stream buff failed.", (Throwable)e);
        }
        catch (InterruptedException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("sleep failed.", (Throwable)e);
        }
        if (readFlag > -1) {
            ToolLoggerFactory.getLogger(this.getClass()).info("Clear buffer failed.");
        }
    }

    private synchronized void fillBuffer(byte[] receiveDataBuf) throws IOException, InterruptedException {
        int bufferLength = receiveDataBuf.length;
        int lengthBuf = 0;
        for (int i = 0; i < 600; ++i) {
            int lengthOfOnceRead = this.getLengthOfOnceRead(receiveDataBuf, lengthBuf, bufferLength - lengthBuf);
            if (lengthOfOnceRead > -1) {
                lengthBuf += lengthOfOnceRead;
            }
            if (lengthBuf == bufferLength) break;
            this.sleep100m();
        }
        if (lengthBuf < bufferLength) {
            throw new TLVException(16797698L);
        }
    }

    private int getLengthOfOnceRead(byte[] receiveDataBuf, int lengthBuf, int len) throws IOException {
        return this.bis.read(receiveDataBuf, lengthBuf, len);
    }

    private void sleep100m() throws InterruptedException {
        Thread.sleep(100L);
    }

    public synchronized String getURL() {
        return this.ip;
    }

    public synchronized Record pmCreate(int moType, List<Param> tlvParams, int timeout) throws TLVException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(moType));
        return this.invoke(0xD00004000L, TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam}), timeout);
    }

    public void pmDelete(int moType, String moid, int timeout) throws TLVException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), moid);
        this.sendCMD(0xD00006000L, TLVUtils.addParam((List)TLVUtils.paramList((Param[])new Param[0]), (Param[])new Param[]{moTypeParam, moidParam}), timeout);
    }

    public void pmModify(int moType, String moid, List<Param> tlvParams, int timeout) throws TLVException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), moid);
        this.sendCMD(0xD00002000L, TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam, moidParam}), timeout);
    }

    public Record pmGet(int moType, String moid, int timeout) throws TLVException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(moType));
        Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), moid);
        return this.invoke(0xD00000000L, TLVUtils.addParam((List)TLVUtils.paramList((Param[])new Param[0]), (Param[])new Param[]{moTypeParam, moidParam}), timeout);
    }

    public List<Record> pmGetBacthNext(int moType, List<Param> tlvParams, int timeout) throws TLVException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(moType));
        return this.bacthNext(0xD0000C000L, TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam}), timeout);
    }

    public List<Record> bacthNext(long cmd, List<Param> tlvParams, int timeout) throws TLVException {
        ArrayList<Record> dataList = new ArrayList<Record>();
        List<Record> datas = this.getBatch(cmd, tlvParams, timeout);
        while (!datas.isEmpty()) {
            for (int i = 0; i < datas.size() - 1; ++i) {
                dataList.add(datas.get(i));
            }
            Record lastRecord = datas.get(datas.size() - 1);
            if (TLVUtils.containTag((Record)lastRecord, (int)4095)) {
                long errorcode = ((IsmInteger)lastRecord.getParamValue(4095)).longValue();
                if (errorcode == 1L) break;
                throw new TLVException(errorcode);
            }
            dataList.add(lastRecord);
            Param moidParam = new Param(TLVMOMsg.ID.getParamIndex(), lastRecord.getParamStrValue(TLVMOMsg.ID.getParamIndex()));
            datas = this.getBatch(cmd, TLVUtils.addParam(tlvParams, (Param[])new Param[]{moidParam}), timeout);
        }
        return dataList;
    }

    public int pmCount(int moType, List<Param> tlvParams, int timeout) throws TLVException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(moType));
        Record record = this.invoke(0xD0000E000L, TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam}), timeout);
        if (record == null) {
            throw new TLVException(33L);
        }
        Object obj = record.getParamValue(TLVMOMsg.COUNT.getParamIndex());
        if (obj == null || !(obj instanceof IsmInteger)) {
            throw new TLVException(33L);
        }
        return ((IsmInteger)obj).intValue();
    }

    public List<Record> pmAssociate(int srcMOType, int associateMOType, String associateMOID, int timeout) throws TLVException {
        Param srcmoTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), associateMOID);
        return this.bacthNext(0xD0000A000L, TLVUtils.addParam((List)TLVUtils.paramList((Param[])new Param[0]), (Param[])new Param[]{srcmoTypeParam, associateMOTypeParam, associateMOIDParam}), timeout);
    }

    public Record pmCreateAssociate(int srcMOType, String srcMOID, int associateMOType, String associateMOID, List<Param> tlvParams, int timeout) throws TLVException {
        Param srcmoTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param srcmoidTypeParam = new Param(TLVMOMsg.ID.getParamIndex(), srcMOID);
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), associateMOID);
        return this.invoke(0xD00005000L, TLVUtils.addParam(tlvParams, (Param[])new Param[]{srcmoTypeParam, srcmoidTypeParam, associateMOTypeParam, associateMOIDParam}), timeout);
    }

    public void pmRemoveAssociate(int srcMOType, String srcMOID, int associateMOType, String associateMOID, List<Param> tlvParams, int timeout) throws TLVException {
        Param moTypeParam = new Param(TLVMOMsg.TYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(srcMOType));
        Param moidTypeParam = new Param(TLVMOMsg.ID.getParamIndex(), srcMOID);
        Param associateMOTypeParam = new Param(TLVMOMsg.ASSOCIATEOBJTYPE.getParamIndex(), (IsmInteger)new UnsignedInt32(associateMOType));
        Param associateMOIDParam = new Param(TLVMOMsg.ASSOCIATEOBJID.getParamIndex(), associateMOID);
        this.sendCMD(0xD00007000L, TLVUtils.addParam(tlvParams, (Param[])new Param[]{moTypeParam, moidTypeParam, associateMOTypeParam, associateMOIDParam}), timeout);
    }

    public long getSessionKey() {
        return this.sessionKey;
    }

    public synchronized void setSocks5Proxy(Socks5Proxy socks5Proxy) {
        this.socks5Proxy = socks5Proxy;
    }

    public synchronized void setSshForwardNodes(List<MultiRouteNode> sshForwardNodes) {
        this.sshForwardNodes = sshForwardNodes;
    }

    public static String getPassword() {
        return PWD;
    }

    @Override
    public void connect() throws TLVException {
    }

    @Override
    public synchronized boolean isConnected() {
        return this.socket != null && !this.socket.isClosed();
    }

    @Override
    public List<Record> getBatch(long cmdWord, List<Param> tlvParams, int timeout, int retryTimes) throws TLVException {
        return this.getBatch(cmdWord, tlvParams, timeout, (short)-3);
    }

    @Override
    public Record invoke(long cmdWord, List<Param> tlvParams, int timeout, int retryTimes) throws TLVException {
        return this.invoke(cmdWord, tlvParams, timeout, (short)-3);
    }

    private static class IsmTrustManager
    implements X509TrustManager {
        private IsmTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

