/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.tlv;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.pubservice.common.IProtocolService;
import com.huawei.ism.tool.framework.pubservice.exception.ServiceException;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.DeviceTypeUtil;
import com.huawei.ism.tool.protocol.exception.ProtocolException;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import com.huawei.ism.tool.protocol.tlv.ITLVConnection;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.tool.protocol.tlv.impl.InnerIpTlvConnection;
import com.huawei.ism.tool.protocol.tlv.impl.MasterTlvConn;
import com.huawei.ism.tool.protocol.tlv.impl.TV2Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class TlvConnectionManager
implements IProtocolService {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TlvConnectionManager.class);
    private static final Map<String, ITLVConnection> CONNECTION_POOL = new HashMap<String, ITLVConnection>();
    private static int globalRetryTimes = 0;
    private static int globalRetryInterval = 0;

    public static int getGlobalRetryTimes() {
        return globalRetryTimes;
    }

    public static void setGlobalRetryTimes(int globalRetryTimes) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Thread name :" + Thread.currentThread().getName() + " id : " + Thread.currentThread().getId() + "set global interval to:" + globalRetryTimes);
        }
        TlvConnectionManager.globalRetryTimes = globalRetryTimes;
    }

    public static int getGlobalRetryInterval() {
        return globalRetryInterval;
    }

    public static void setGlobalRetryInterval(int globalRetryInterval) {
        TlvConnectionManager.globalRetryInterval = globalRetryInterval;
    }

    public static int getCmdRetryTimes() {
        return globalRetryTimes;
    }

    public static void setCmdRetryTimes(int cmdRetryTimes) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Thread name :" + Thread.currentThread().getName() + " id : " + Thread.currentThread().getId() + "set global times to:" + cmdRetryTimes);
        }
        globalRetryTimes = cmdRetryTimes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITLVConnection getConnection(DevNode devNode) throws ToolException {
        ITLVConnection connection = null;
        Map<String, ITLVConnection> map = CONNECTION_POOL;
        synchronized (map) {
            if (TlvConnectionManager.contains(devNode)) {
                ITLVConnection conn = CONNECTION_POOL.get(devNode.getDevKey());
                if (!conn.isConnected()) {
                    TlvConnectionManager.doConnect(conn);
                }
                return conn;
            }
            connection = TlvConnectionManager.createConnection(devNode);
            TlvConnectionManager.doConnect(connection);
            CONNECTION_POOL.put(devNode.getDevKey(), connection);
        }
        return connection;
    }

    private static void doConnect(ITLVConnection connection) throws ToolException {
        try {
            connection.connect();
        }
        catch (UserStatusException e1) {
            connection.close();
            throw e1;
        }
        catch (Exception e) {
            connection.close();
            throw new ToolException("tlv connect 2 dev error.", false, (Throwable)e);
        }
    }

    private static void handleOnException(ITLVConnection conn, Exception except) throws ToolException {
        if (conn != null) {
            conn.close();
        }
        throw new ToolException("tlv connect 2 dev second controller ip error.", false, (Throwable)except);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITLVConnection getConnectionByInnerIp(DevNode devNode) throws ToolException {
        if (!DeviceTypeUtil.hasSVPModule(devNode)) {
            return TlvConnectionManager.getConnection(devNode);
        }
        ITLVConnection conn = null;
        Map<String, ITLVConnection> map = CONNECTION_POOL;
        synchronized (map) {
            conn = CONNECTION_POOL.get(devNode.getDevKey());
            if (null != conn) {
                return conn;
            }
            try {
                boolean useSSL = ApplicationContext.getInstance().isDeviceUsingSSL();
                ToolLoggerFactory.getLogger(TlvConnectionManager.class).info("ProductVersion:" + devNode.getProductVersion());
                if (devNode.getProductVersion().endsWith("V100R001C00") || devNode.getProductVersion().endsWith("V100R001C00B033") || devNode.getProductVersion().contains("V100R001C99")) {
                    useSSL = false;
                }
                conn = new InnerIpTlvConnection(devNode, useSSL);
                conn.connect();
                devNode.setIp(devNode.getIpList().get(0));
            }
            catch (UserStatusException e1) {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception e) {
                        throw new ToolException("tlv connect 1 dev inner ip error.", false, (Throwable)e);
                    }
                }
                throw e1;
            }
            catch (Exception e) {
                TlvConnectionManager.closeConn(conn);
                throw new ToolException("tlv connect 2 dev inner ip error.", false, (Throwable)e);
            }
            CONNECTION_POOL.put(devNode.getDevKey(), conn);
        }
        return conn;
    }

    private static void closeConn(ITLVConnection conn) throws ToolException {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (Exception e1) {
            throw new ToolException("tlv connect 3 dev inner ip error.", false, (Throwable)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static ITLVConnection getTvlConnection(String ip) {
        LOGGER.warn("use danger oper get Tlv conn by IP !!!!!!!!!!!!!! ip is:" + ip);
        Map<String, ITLVConnection> map = CONNECTION_POOL;
        synchronized (map) {
            for (Map.Entry<String, ITLVConnection> entry : CONNECTION_POOL.entrySet()) {
                if (!entry.getKey().contains(ip)) continue;
                LOGGER.warn("useing danger oper get Tlv conn by result\uff1a" + entry.getValue());
                return entry.getValue();
            }
            LOGGER.warn("useing danger oper get Tlv conn by IP failed ip is:" + ip);
            return CONNECTION_POOL.get(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean contains(DevNode devNode) {
        Map<String, ITLVConnection> map = CONNECTION_POOL;
        synchronized (map) {
            return null != CONNECTION_POOL.get(devNode.getDevKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(DevNode devNode) throws ToolException {
        Map<String, ITLVConnection> map = CONNECTION_POOL;
        synchronized (map) {
            if (TlvConnectionManager.contains(devNode)) {
                ITLVConnection connection = TlvConnectionManager.getConnection(devNode);
                CONNECTION_POOL.remove(devNode.getDevKey());
                connection.close();
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Tlv conn released :" + devNode.getDevKey());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(ITLVConnection connection) {
        if (null == connection) {
            return;
        }
        try {
            Map<String, ITLVConnection> map = CONNECTION_POOL;
            synchronized (map) {
                String key = TlvConnectionManager.getKeyByVal(CONNECTION_POOL, connection);
                if (null != key) {
                    CONNECTION_POOL.remove(key);
                }
                connection.close();
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(TlvConnectionManager.class).error("error close tlv connection .", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean startTlv(String ip, String username, String password) throws ServiceException {
        LOGGER.warn("use danger oper start Tlv conn by IP !!!!!!!!!!!!!! ip is:" + ip);
        Map<String, ITLVConnection> map = CONNECTION_POOL;
        synchronized (map) {
            ITLVConnection conn = TlvConnectionManager.getTvlConnection(ip);
            if (null != conn) {
                try {
                    conn.connect();
                    return true;
                }
                catch (TLVException e) {
                    throw new ProtocolException(e);
                }
                catch (UserStatusException e) {
                    throw new ProtocolException(e);
                }
            }
            conn = new TV2Connection(ip, username, password);
            try {
                conn.connect();
            }
            catch (TLVException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
                throw new ProtocolException(e);
            }
            catch (UserStatusException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
                throw new ProtocolException(e);
            }
            CONNECTION_POOL.put(ip, conn);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void stopTlv(String ip) {
        LOGGER.warn("useing danger oper stopTlv Tlv conn by IP !!!!!!!!!!!!!! ip is:" + ip);
        Map<String, ITLVConnection> map = CONNECTION_POOL;
        synchronized (map) {
            ITLVConnection conn = TlvConnectionManager.getTvlConnection(ip);
            if (null != conn) {
                CONNECTION_POOL.remove(ip);
                conn.close();
            }
        }
    }

    public static <K, V> K getKeyByVal(Map<K, V> kvMap, V value) {
        Set<Map.Entry<K, V>> entrys = kvMap.entrySet();
        Iterator<Map.Entry<K, V>> iters = entrys.iterator();
        K removedKey = null;
        while (iters.hasNext()) {
            Map.Entry<K, V> entry = iters.next();
            if (entry.getValue() != value) continue;
            removedKey = entry.getKey();
            break;
        }
        return removedKey;
    }

    private static ITLVConnection createConnection(DevNode devNode) {
        if (DeviceTypeUtil.hasSVPModule(devNode)) {
            return new MasterTlvConn(devNode);
        }
        return new TV2Connection(devNode);
    }
}

