/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.tlv.impl;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.tlv.TLV;
import com.huawei.ism.tlv.TLVUtils;
import com.huawei.ism.tlv.bean.Param;
import com.huawei.ism.tlv.bean.Record;
import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmInteger;
import com.huawei.ism.tlv.lang.SignedInt32;
import com.huawei.ism.tlv.lang.UnsignedInt32;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.protocol.exception.UserStatusException;
import com.huawei.ism.tool.protocol.tlv.ShakeHandRunable;
import com.huawei.ism.tool.protocol.tlv.TLVConnectionImpl;
import com.huawei.ism.tool.protocol.tlv.exception.TLVException;
import com.huawei.ism.tool.protocol.tlv.impl.AbstractConnection;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;

public class TV2Connection
extends AbstractConnection {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(TV2Connection.class);
    public static final long OM_OPCODE_USER_LOGIN = 55847813121L;
    public static final long OM_OPCODE_USER_LOGOUT = 55847813122L;
    private boolean connected = false;
    private DevNode devNode;
    private User userInfo;
    private String ip;
    private String user;
    private String pass;
    private String userId;
    private boolean enableSSL = true;
    private boolean passExpiringStop = true;

    public TV2Connection(String ip, String username, String pass) {
        this.ip = ip;
        this.user = username;
        this.setPass(pass);
    }

    public TV2Connection(DevNode devNode) {
        this(devNode, true);
    }

    public TV2Connection(DevNode devNode, boolean enableSSL) {
        this(devNode.getIp(), devNode.getLoginUser().getUserName(), devNode.getLoginUser().getPassword());
        this.devNode = devNode;
        this.enableSSL = enableSSL;
    }

    public String getPass() {
        return AESEncrypt.decrypt((String)this.pass);
    }

    public void setPass(String pass) {
        this.pass = AESEncrypt.encrypt((String)pass);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSocketConnected() {
        TLVConnectionImpl impl = this.getOmConn();
        return impl != null && impl.isConnected();
    }

    @Override
    public void connect() throws TLVException {
        Properties properties = new Properties();
        properties.put("USER_NAME", this.user);
        properties.put("USER_WORD", this.getPass());
        properties.put("IP_OR_NAME", this.ip);
        properties.put("PORT", "8080");
        properties.put("TIME_OUT_PROPERTY", "30");
        if (this.enableSSL) {
            properties.put("CONN_PROTOCOL", "1");
        }
        ToolLoggerFactory.getLogger(this.getClass()).info("create tlv connection ,cur props is: ip:" + this.ip);
        this.setOmConn(new TLVConnectionImpl());
        if (null != this.devNode) {
            this.getOmConn().setSocks5Proxy(this.devNode.getSocks5Proxy());
            this.getOmConn().setSshForwardNodes(this.devNode.getSshForwardList());
        }
        this.getOmConn().setSessionKey(0L);
        this.getOmConn().init(properties);
        boolean isAuthenticate = this.authenticate(this.getPass());
        if (!isAuthenticate) {
            throw new TLVException("authenticate error.");
        }
        this.connected = true;
        Thread thread = new Thread(new ShakeHandRunable(this, 55847813125L));
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                LOGGER.error(thread.getName() + ":" + throwable.getMessage());
            }
        });
        thread.setName("tlv-shakeHandThread-->" + this.ip);
        thread.start();
    }

    public void reConnect() throws TLVException {
        try {
            this.passExpiringStop = false;
            this.connect();
        }
        catch (TLVException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("reconnect to dev " + this.ip + "error", (Throwable)e);
            throw e;
        }
    }

    private boolean authenticate(String passWd) throws TLVException {
        ToolLoggerFactory.getLogger(this.getClass()).info("Begin connect to device by TLV.");
        try {
            Param username = new Param(2, ParamType.STRING, this.user);
            Param password = new Param(65, ParamType.STRING, passWd);
            Param scope = new Param(71, ParamType.ENUM, (IsmInteger)new UnsignedInt32(0));
            List list = TLVUtils.paramList((Param[])new Param[]{username, password, scope});
            Record record = this.getOmConn().invoke(55847813121L, list);
            if (record == null) {
                LOGGER.error("Connect to device by TLV failed.record is null.");
                return false;
            }
            this.createUserInfo(record);
            this.isUserStatusNormal(record);
            this.userId = record.getParamStrValue(1);
            long sessionKey = ((IsmInteger)record.getParamValue(68)).longValue();
            this.getOmConn().setSessionKey(sessionKey);
            ToolLoggerFactory.getLogger(this.getClass()).info("Connect to device by TLV success.");
            return true;
        }
        catch (UserStatusException e1) {
            this.close();
            throw e1;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("tlv authenticate exception:", (Throwable)e);
            return false;
        }
    }

    private void isUserStatusNormal(Record record) throws UserStatusException {
        IsmInteger accountStatus = record.getParamIntValue(76);
        if (null == accountStatus) {
            ToolLoggerFactory.getLogger(this.getClass()).error("TV2R1 do not have this interface.");
            return;
        }
        int accStatusInt = record.getParamIntValue(76).intValue();
        ToolLoggerFactory.getLogger(this.getClass()).info("User Status is:" + accountStatus);
        if (accStatusInt == User.Status.Pwd_expired.ordinal()) {
            throw new UserStatusException("conn.userdatus.pwd.expired");
        }
        if (this.passExpiringStop && accStatusInt == User.Status.Pwd_expiring.ordinal()) {
            throw new UserStatusException("conn.userdatus.pwd.expiring");
        }
        if (accStatusInt == User.Status.Pwd_initial.ordinal()) {
            throw new UserStatusException("conn.userdatus.pwd.initial");
        }
    }

    private User createUserInfo(Record record) {
        this.userInfo = new User(this.user);
        this.userInfo.setLevel(User.Level.valueOf((int)record.getParamIntValue(TLV.USER.LEVEL.getParamIndex()).intValue()));
        this.userInfo.setID(record.getParamStrValue(TLV.USER.ID.getParamIndex()));
        int userState = record.getParamIntValue(TLV.USER.ACCOUNTSTATE.getParamIndex(), (IsmInteger)new SignedInt32(User.Status.Online.getValue())).intValue();
        this.userInfo.setStatus(User.Status.valueOf((int)userState));
        return this.userInfo;
    }

    public User getLoginUser() {
        return this.userInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() {
        try {
            if (!this.isConnected() || this.getOmConn() == null) {
                return;
            }
            Param paramUserId = new Param(1, ParamType.STRING, this.userId);
            Param scope = new Param(71, ParamType.ENUM, (IsmInteger)new UnsignedInt32(0));
            List params = TLVUtils.paramList((Param[])new Param[]{paramUserId, scope});
            this.getOmConn().invoke(55847813122L, params);
            ToolLoggerFactory.getLogger(this.getClass()).info("close connection" + this.ip + " finished");
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("close connection" + this.ip + " failed", (Throwable)e);
        }
        finally {
            this.connected = false;
            if (null != this.getOmConn()) {
                this.getOmConn().close();
                this.setOmConn(null);
            }
        }
    }

    @Override
    public String toString() {
        return "TV2Connection{ip='" + this.ip + '\'' + '}';
    }
}

