/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.utils;

import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.NodeHardwareUsage;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.ResourceUsageService;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDistributedDeviceHardwareUsage {
    private static final Logger log = LoggerFactory.getLogger(GetDistributedDeviceHardwareUsage.class);
    private static final String ERROR_CODE = "-1";
    private static final String SUCCESS_CODE = "0";
    private static final String HAS_ABNORMAL_NODE_CODE = "33759591";
    private static final String OVER_LIMIT_FLAG = ResourceUtil.getString("distributed.device.hardware.usage.over.limit.sign");
    private static final Map<String, Map<String, String>> NODE_ROLES_MAP = new HashMap<String, Map<String, String>>();
    private static final List<Integer> CRITERION_FOR_COMPUTE_NODE = Arrays.asList(70, 85, 80, 85);
    private static final List<Integer> CRITERION_FOR_STORAGE_NODE = Arrays.asList(80, 92, 80, 85);

    public static List<NodeHardwareUsage> getHardwareStatus(DevNode devNode) throws ToolException {
        return GetDistributedDeviceHardwareUsage.getHardwareStatus(devNode, devNode.getSelectClusterNodeIntIds());
    }

    public static List<NodeHardwareUsage> getHardwareStatus(DevNode devNode, List<Integer> clusterNodeIds) throws ToolException {
        if (Objects.isNull(devNode) || !ResourceUsageService.isSupportHardwareUsageQuery(devNode)) {
            return Collections.emptyList();
        }
        GetDistributedDeviceHardwareUsage.setNodeRole(devNode);
        String url = RestUtil.getInfoCollectUri(devNode);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", "log");
        params.put("node_ids", clusterNodeIds);
        return GetDistributedDeviceHardwareUsage.parseResponse(devNode.getIp(), GetDistributedDeviceHardwareUsage.getResponseInfo(devNode, url, params));
    }

    private static void setNodeRole(DevNode devNode) {
        NODE_ROLES_MAP.put(devNode.getIp(), devNode.getClusterNodes().stream().filter(node -> ObjectUtils.isNotEmpty((Object)node.getManagementIp())).distinct().collect(Collectors.toMap(ClusterNode::getManagementIp, node -> node.getRoles().toString(), (ip1, ip2) -> ip2)));
    }

    private static ResponseInfo getResponseInfo(DevNode devNode, String url, HashMap<String, Object> params) throws ToolException {
        ResponseInfo responseInfo;
        try (RestConnection restConn = RestConnectionManager.getRestConnection(devNode);){
            if (restConn == null) {
                log.error("query hardware usage: rest connection is null!");
                throw new ToolException("query hardware usage: rest connection is null!");
            }
            responseInfo = restConn.execPut(url, params);
        }
        catch (Exception e) {
            log.error("query hardware usage failed");
            throw new ToolException("query hardware usage failed", e);
        }
        return responseInfo;
    }

    @NotNull
    private static List<NodeHardwareUsage> parseResponse(String devIp, ResponseInfo responseInfo) throws ToolException {
        if (responseInfo == null || responseInfo.getContent().isEmpty()) {
            log.error("query hardware usage: responseInfo is null!");
            throw new ToolException("responseInfo is null!");
        }
        JSONObject jsonObject = new JSONObject(responseInfo.getContent());
        String code = ERROR_CODE;
        if (jsonObject.has("result")) {
            code = jsonObject.getJSONObject("result").getStringOrDefault("code", ERROR_CODE);
        }
        if (!SUCCESS_CODE.equals(code) && !HAS_ABNORMAL_NODE_CODE.equals(code)) {
            log.error("query hardware usage: query failed!");
            throw new ToolException(String.format("query failed! code=%s", code));
        }
        if (SUCCESS_CODE.equals(code)) {
            return Collections.emptyList();
        }
        String desc = jsonObject.getJSONObject("result").getStringOrDefault("description", "");
        try {
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            ArrayList<NodeHardwareUsage> nodeInfoRes = new ArrayList<NodeHardwareUsage>();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject nodeHardwareInfo = jsonArray.getJSONObject(i);
                nodeInfoRes.add(GetDistributedDeviceHardwareUsage.parseNodeHardwareUsage(devIp, nodeHardwareInfo, desc));
            }
            return nodeInfoRes;
        }
        catch (JSONException | IllegalArgumentException e) {
            log.error("query hardware usage: parse error!", e);
            throw new ToolException("query hardware usage: parse error!");
        }
    }

    private static NodeHardwareUsage parseNodeHardwareUsage(String devIp, JSONObject nodeHardwareInfo, String desc) {
        String nodeIp = nodeHardwareInfo.getStringOrDefault("node_ip", "");
        String nodeRoles = NODE_ROLES_MAP.get(devIp).getOrDefault(nodeIp, "");
        List<Integer> currentCriterion = null;
        if (nodeHardwareInfo.has("thresholds")) {
            JSONObject thresholds = nodeHardwareInfo.getJSONObject("thresholds");
            currentCriterion = GetDistributedDeviceHardwareUsage.parseThresholds(thresholds);
        }
        if (CollectionUtils.isEmpty(currentCriterion)) {
            currentCriterion = nodeRoles.contains("storage") ? CRITERION_FOR_STORAGE_NODE : CRITERION_FOR_COMPUTE_NODE;
        }
        String cpuUsage = nodeHardwareInfo.getStringOrDefault("cpu_usage", "");
        String memUsage = nodeHardwareInfo.getStringOrDefault("mem_usage", "");
        String ioUsage = nodeHardwareInfo.getStringOrDefault("io_usage", "");
        String diskUsage = nodeHardwareInfo.getStringOrDefault("disk_usage", "");
        cpuUsage = GetDistributedDeviceHardwareUsage.addSignIfUsageOverLimit(cpuUsage, currentCriterion.get(0));
        memUsage = GetDistributedDeviceHardwareUsage.addSignIfUsageOverLimit(memUsage, currentCriterion.get(1));
        ioUsage = GetDistributedDeviceHardwareUsage.addSignIfUsageOverLimit(ioUsage, currentCriterion.get(2));
        diskUsage = GetDistributedDeviceHardwareUsage.addSignIfUsageOverLimit(diskUsage, currentCriterion.get(3));
        return new NodeHardwareUsage(devIp, Arrays.asList(nodeIp, cpuUsage, memUsage, ioUsage, diskUsage, nodeRoles, desc));
    }

    private static String addSignIfUsageOverLimit(String usage, Integer criterion) {
        return StringUtils.str2Int(usage) >= criterion ? usage + OVER_LIMIT_FLAG : usage;
    }

    private static List<Integer> parseThresholds(JSONObject jsonObject) {
        try {
            return Arrays.asList(jsonObject.getInt("cpu_usage_thresholds"), jsonObject.getInt("mem_usage_thresholds"), jsonObject.getInt("io_usage_thresholds"), jsonObject.getInt("disk_usage_thresholds"));
        }
        catch (JSONException e) {
            log.error("parse hardware usage thresholds fail", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

