/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.protocol.utils;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;

public class TlvUtils {
    public static final List<String> NEED_OPEN_TLV_CHANNEL_VERSIONS = Arrays.asList("V300R003", "V300R005");
    private static final Logger logger = ToolLoggerFactory.getLogger(TlvUtils.class);

    public static boolean isNeedOpenOrCloseTlv(DevNode devNode) {
        String productVersion = devNode.getProductVersion().trim();
        for (String str : NEED_OPEN_TLV_CHANNEL_VERSIONS) {
            if (null == str || !productVersion.contains(str.trim())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openTlv(DevNode devNode) {
        ICliConnection con = null;
        boolean developerSwitch = false;
        try {
            con = SshConnectionManager.getSshConnection(devNode, null, true, false);
            developerSwitch = TlvUtils.openDeveloperView(con);
            String changeModeResult = con.execCmd("change user_mode current_mode user_mode=developer");
            if (logger.isInfoEnabled()) {
                logger.info(devNode.getIp() + "developer open " + changeModeResult);
            }
            String tlv = con.execCmd("change system external_tlv_channel enabled=yes");
            logger.error(devNode.getIp() + "  tlv open  " + tlv);
            con.execCmd("y");
            con.execCmd("y");
        }
        catch (Exception e) {
            logger.error("open tlv failed", (Throwable)e);
        }
        finally {
            if (developerSwitch) {
                TlvUtils.closeDeveloperView(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeTlv(DevNode devNode) {
        ICliConnection connection = null;
        boolean developerSwitch = false;
        try {
            connection = SshConnectionManager.getSshConnection(devNode, null, true, false);
            developerSwitch = TlvUtils.openDeveloperView(connection);
            String changeModeResult = connection.execCmd("change user_mode current_mode user_mode=developer");
            if (logger.isInfoEnabled()) {
                logger.info(devNode.getIp() + " change mode  " + changeModeResult);
            }
            String changeTlvResult = connection.execCmd("change system external_tlv_channel enabled=no");
            if (logger.isInfoEnabled()) {
                logger.info(devNode.getIp() + "  tlv began to  close   " + changeTlvResult);
            }
            connection.execCmd("y");
            connection.execCmd("y");
        }
        catch (Exception e) {
            logger.error("exits closed tlv failure", (Throwable)e);
        }
        finally {
            if (developerSwitch) {
                TlvUtils.closeDeveloperView(connection);
            }
        }
    }

    public static boolean openDeveloperView(ICliConnection con) {
        try {
            if (con == null) {
                return false;
            }
            String checkResult = con.execCmd("show user_mode enabled");
            if (logger.isInfoEnabled()) {
                logger.info("check developer switch: " + checkResult);
            }
            if (!checkResult.contains("Disabled") && !checkResult.contains("^")) {
                return false;
            }
            String openResult = con.execCmd("change user_mode enabled user_mode=developer enabled=yes");
            logger.error("developer view open: " + openResult);
            return true;
        }
        catch (Exception e) {
            logger.error("open developer view failed", (Throwable)e);
            return false;
        }
    }

    public static void closeDeveloperView(ICliConnection con) {
        try {
            if (con == null) {
                return;
            }
            String closeResult = con.execCmd("change user_mode enabled user_mode=developer enabled=no");
            logger.error("developer view close: " + closeResult);
        }
        catch (Exception e) {
            logger.error("close developer view failed", (Throwable)e);
        }
    }
}

