/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.collect.dstorage.service;

import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.collect.dstorage.ICollector;
import com.huawei.ism.tool.service.collect.dstorage.entity.CollectModule;
import com.huawei.ism.tool.service.collect.dstorage.entity.CollectTaskDetail;
import com.huawei.ism.tool.service.collect.dstorage.service.PollingCollector;
import com.huawei.ism.tool.service.common.ITask;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectTask
implements ITask<TaskResult> {
    private static final Logger log = LoggerFactory.getLogger(CollectTask.class);
    private static final Map<CollectModule.Mode, ICollector<TaskResult>> COLLECTOR_ROUTE = new HashMap<CollectModule.Mode, ICollector<TaskResult>>();
    private final DevNode devNode;
    private final String localPath;
    private final CollectTaskDetail detail = new CollectTaskDetail();
    private final long startTime;
    private final long endTime;

    public CollectTask(DevNode devNode, Observer obs, String localPath, long startTime, long endTime) {
        this.devNode = devNode;
        this.localPath = localPath + File.separator + "collect";
        this.startTime = startTime;
        this.endTime = endTime;
        this.detail.setResultDir(this.localPath);
        if (obs != null) {
            this.detail.addObserver(obs);
        }
    }

    @Override
    public TaskResult prepare() throws ToolException {
        DstoragePatchInfo patchInfo = Context.INS.findBestMatchPatch(this.devNode, DstoragePatchInfo.Type.COLLECT);
        if (Objects.isNull(patchInfo)) {
            return TaskResult.fail((String)"patch.collect.notFound");
        }
        return Context.INS.syncAutoImport(this.devNode, patchInfo, null);
    }

    @Override
    public TaskResult doTask() throws ToolException {
        DstoragePatchInfo patchInfo = Context.INS.findBestMatchPatch(this.devNode, DstoragePatchInfo.Type.COLLECT);
        List<CollectModule> modules = CollectModule.buildModule(patchInfo.getCollectItems(), this.localPath, this.detail, this.startTime, this.endTime);
        this.detail.setSubTasks(modules.stream().map(CollectModule::getDetail).collect(Collectors.toList()));
        ArrayList<TaskResult> results = new ArrayList<TaskResult>();
        for (CollectModule module : modules) {
            results.add(COLLECTOR_ROUTE.get((Object)module.getMode()).doCollect(this.devNode, module));
        }
        return TaskResult.success((Object)"");
    }

    @Override
    public TaskResult postHandle() throws ToolException {
        Context.INS.uninstallAutoImportPatch(this.devNode, DstoragePatchInfo.Type.COLLECT, null);
        return new TaskResult(TaskResult.Result.SUCCESS);
    }

    @Override
    public String getTaskThreadName() {
        return "CollectTask_" + this.devNode.getIp();
    }

    @Override
    public void notifyTaskObs(Object obj) {
        if (!(obj instanceof TaskResult)) {
            return;
        }
        TaskResult result = (TaskResult)obj;
        if (result.isTaskSuccess()) {
            return;
        }
        this.detail.fail(result.getErrorLocaleDescription());
    }

    static {
        COLLECTOR_ROUTE.put(CollectModule.Mode.POLL, new PollingCollector());
    }
}

