/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.deploy.conf;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.devicemanager.entity.ProductUniqueIdConfig;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.deploy.conf.PlatformStrategy;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VersionMappingStrategy {
    private static final Logger log = LoggerFactory.getLogger(VersionMappingStrategy.class);
    private static final String VERSION_MAPPING_NAME = "Version_Mapping.xml";
    private static final String XQL_PRODUCT_EXP = "config/product";
    private static final String PLATFORM_TAG = "platform";
    private static final String ATTRIBUTE_TAG = "attribute";
    private static final String ATTR_NAME_KEY = "name";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String STRATEGY_UPDATE_TIME_KEY = "updateTime";
    private static final String STRATEGY_MINI_TOOL_VERSION = "minToolVersion";
    private static final String TOOL_VERSION_KEY = "tool.version";
    private static final String SPLIT = ";";
    private final Map<String, Map<String, PlatformStrategy>> strategy = new ConcurrentHashMap<String, Map<String, PlatformStrategy>>();
    private String updateToolTips = "";

    public VersionMappingStrategy(String localConfDir) {
        this.init(localConfDir);
    }

    private void init(String localConfDir) {
        try {
            Document doc = this.initDoc(localConfDir);
            this.initProductsStrategy(doc);
        }
        catch (FileNotFoundException e) {
            log.error("file not found.");
        }
        catch (Exception e) {
            log.error("init mapping strategy failed", (Throwable)e);
        }
    }

    private Document initDoc(String localConfDir) throws FileNotFoundException {
        Document localDoc = XmlUtils.parseDocument((InputStream)new FileInputStream(new File(localConfDir, VERSION_MAPPING_NAME)));
        Document remoteDoc = this.initRemoteDoc();
        if (remoteDoc == null) {
            log.info("Can not find remote strategy or parse error,using local strategy.");
            return localDoc;
        }
        return this.compareVerInfoAndGetDoc(Objects.requireNonNull(localDoc), remoteDoc);
    }

    private Document compareVerInfoAndGetDoc(Document localDoc, Document remoteDoc) {
        Element localDocRoot = localDoc.getDocumentElement();
        String localDate = localDocRoot.getAttribute(STRATEGY_UPDATE_TIME_KEY);
        Element remoteDocRoot = remoteDoc.getDocumentElement();
        String remoteDate = remoteDocRoot.getAttribute(STRATEGY_UPDATE_TIME_KEY);
        String miniToolVer = remoteDocRoot.getAttribute(STRATEGY_MINI_TOOL_VERSION);
        String currentToolVer = UserOpDataSaveUtil.getToolIniProp((String)TOOL_VERSION_KEY);
        Calendar localCalendar = Calendar.getInstance();
        Calendar remoteCalendar = Calendar.getInstance();
        try {
            localCalendar.setTime(this.parseUpdateDate(localDate));
            remoteCalendar.setTime(this.parseUpdateDate(remoteDate));
        }
        catch (Exception e) {
            log.error("Compare version error.", (Throwable)e);
            return localDoc;
        }
        log.info("Remote mapping strategy update time {} , local strategy update time is {}.", (Object)remoteDate, (Object)localDate);
        if (remoteCalendar.after(localCalendar)) {
            if (Objects.requireNonNull(currentToolVer).compareTo(miniToolVer) < 0) {
                log.info("Current tool version : {} is lower than minToolVersion {}.", (Object)currentToolVer, (Object)miniToolVer);
                this.updateToolTips = ResourceUtil.getStringWithParams("deploy.tool.update.tips", currentToolVer, miniToolVer);
                return localDoc;
            }
            log.info("Using remote mapping strategy.");
            return remoteDoc;
        }
        return localDoc;
    }

    private Document initRemoteDoc() {
        String remoteMappingPath = ApplicationContext.getInstance().getCurrWorkPath() + File.separator + "updates" + File.separator + "deployHelper" + File.separator + VERSION_MAPPING_NAME;
        Document docRemote = null;
        try {
            docRemote = XmlUtils.parseDocument((InputStream)new FileInputStream(remoteMappingPath));
        }
        catch (FileNotFoundException e) {
            log.warn("Can not find remote mapping file.");
        }
        catch (Exception e) {
            log.warn("Remote mapping file parse err.", (Throwable)e);
        }
        return docRemote;
    }

    private Date parseUpdateDate(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return sdf.parse(date);
    }

    private void initProductsStrategy(Document doc) {
        NodeList productList = XmlUtils.searchNodeByExp((Document)doc, (String)XQL_PRODUCT_EXP);
        if (productList == null) {
            log.info("init Products Strategy failed. productList is null.");
            return;
        }
        for (int i = 0; i < productList.getLength(); ++i) {
            Node node = productList.item(i);
            if (!(node instanceof Element)) continue;
            this.initProductStrategy((Element)node);
        }
    }

    private void initProductStrategy(Element product) {
        String[] products = product.getAttribute(KEY).split(SPLIT);
        Map<String, PlatformStrategy> productStrategy = this.initPlatformStrategy(product);
        Arrays.stream(products).forEach(productKey -> this.strategy.put((String)productKey, productStrategy));
    }

    private Map<String, PlatformStrategy> initPlatformStrategy(Element product) {
        return XmlUtils.getChildren((Element)product, (String)PLATFORM_TAG).stream().map(this::initPlatformAttribute).collect(Collectors.toMap(PlatformStrategy::getPlatformId, PlatformStrategy::getSelf));
    }

    private PlatformStrategy initPlatformAttribute(Element platformEle) {
        String id = platformEle.getAttribute(KEY);
        PlatformStrategy platformStrategy = new PlatformStrategy(ProductUniqueIdConfig.HardwarePlatform.getById((String)id));
        this.appendAttribute(platformEle, platformStrategy);
        return platformStrategy;
    }

    private void appendAttribute(Element platformEle, PlatformStrategy platformStrategy) {
        XmlUtils.getChildren((Element)platformEle, (String)ATTRIBUTE_TAG).forEach(attributeEle -> platformStrategy.addAttribute(attributeEle.getAttribute(ATTR_NAME_KEY), attributeEle.getAttribute(KEY), attributeEle.getAttribute(VALUE)));
    }

    public Map<String, Map<String, PlatformStrategy>> getStrategy() {
        return this.strategy;
    }

    public String getUpdateToolTips() {
        return this.updateToolTips;
    }
}

