/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.inspect.dstorage;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.ClusterNodeStatus;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.common.ITask;
import com.huawei.ism.tool.service.common.entity.Item;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectTask
extends Observable
implements ITask<TaskResult> {
    private static final Logger log = LoggerFactory.getLogger(InspectTask.class);
    private static final String ERROR_CODE_RES_PREFIX = "exec.errorCode.";
    private static final int QUERY_TIMEOUT = 1800000;
    private static final int MAX_QUERY_ITEM_NUM = 10;
    private final DevNode devNode;
    private final DstoragePatchInfo.Type patchType;
    private final List<Item> items;
    private final String resultDir;
    private long lastUpdateTime;
    private DstoragePatchInfo patch;
    private TaskResult result = new TaskResult();
    private String taskId;

    public void init() {
        this.patch = Context.INS.findBestMatchPatch(this.devNode, this.patchType);
    }

    public TaskResult importScript() throws ToolException {
        if (!this.checkNodeStatusIsNormal()) {
            log.error("Exist abnormal node.");
            this.result.setResult(TaskResult.Result.FAILED);
            this.result.setErrorLocaleDescription(ResourceUtil.getStringWithParams("exec.node.status.abnormal", this.devNode.getIp()));
            return this.result;
        }
        this.result = Context.INS.syncAutoImport(this.devNode, this.patch, null);
        return this.result;
    }

    private boolean checkNodeStatusIsNormal() throws ToolException {
        RestConnection conn = this.getConn(this.devNode);
        ResponseInfo resp = conn.execGet(RestUtil.getClusterNodesUri((DevNode)this.devNode));
        this.checkIsError(resp);
        JSONArray nodesArray = (JSONArray)resp.getContentMap().get("data");
        for (int i = 0; i < nodesArray.length(); ++i) {
            JSONObject jsonData = nodesArray.getJSONObject(i);
            String id = jsonData.getStringOrDefault("id", "");
            boolean isSelect = this.getClusterNodeSelect(id);
            if (!isSelect || ClusterNodeStatus.getClusterNodeStatus(jsonData.getInt("status")).isNormal()) continue;
            return false;
        }
        return true;
    }

    private boolean getClusterNodeSelect(String id) {
        for (ClusterNode clusterNode : this.devNode.getClusterNodes()) {
            if (!id.equals(String.valueOf(clusterNode.getId()))) continue;
            return clusterNode.isSelected();
        }
        log.info("cluster node not found,id:{}", (Object)id);
        return false;
    }

    private RestConnection getConn(DevNode devNode) throws ToolException {
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            if (conn == null || !conn.isLogin()) {
                throw new ToolException("exec.connection.init.error");
            }
            return conn;
        }
        catch (Exception e) {
            throw new ToolException("exec.connection.init.error");
        }
    }

    @Override
    public TaskResult prepare() throws ToolException {
        this.init();
        return this.importScript();
    }

    @Override
    public TaskResult doTask() throws ToolException {
        this.taskId = this.startTask(this.items);
        if (StringUtils.isNULLStr(this.taskId)) {
            return TaskResult.fail((String)"exec.error");
        }
        this.pollingTaskResult(this.items);
        return this.result;
    }

    @Override
    public TaskResult postHandle() throws ToolException {
        this.deleteTask(this.taskId);
        Context.INS.uninstallAutoImportPatch(this.devNode, this.patch.getPatchType(), null);
        return TaskResult.success((Object)"");
    }

    @Override
    public String getTaskThreadName() {
        return "InspectTask_" + this.devNode.getIp();
    }

    @Override
    public void notifyTaskObs(Object obj) {
        if (!(obj instanceof TaskResult)) {
            return;
        }
        TaskResult taskResult = (TaskResult)obj;
        if (taskResult.isTaskSuccess()) {
            return;
        }
        String errorMessage = taskResult.getErrorLocaleDescription();
        this.items.stream().filter(item -> !item.isFinish()).forEach(item -> this.updateItemErrorMessageAndNotifyObservers(errorMessage, (Item)item));
    }

    private void updateItemErrorMessageAndNotifyObservers(String errorMessage, Item item) {
        item.setErrorMessage(errorMessage);
        this.setChanged();
        this.notifyObservers(item);
    }

    public void pollingTaskResult(List<Item> items) {
        this.lastUpdateTime = System.currentTimeMillis();
        while (true) {
            List<Item> notFinishedItem = items.stream().filter(item -> !item.isFinish()).collect(Collectors.toList());
            int oldProSum = notFinishedItem.stream().mapToInt(Item::getProgress).sum();
            this.queryProgressAndUpdate(notFinishedItem);
            this.checkProChangeAndUpdateTimeChecker(notFinishedItem, oldProSum);
            List<Item> finishedAndNotDownloadItem = items.stream().filter(item -> item.isFinish() && !item.isDownload()).collect(Collectors.toList());
            finishedAndNotDownloadItem.forEach(this::downloadNoException);
            if (this.isFinishedOrOverTime(items, this.lastUpdateTime)) break;
            this.sleepNoException();
        }
        log.info("Finished inspect or over time.");
    }

    private void checkProChangeAndUpdateTimeChecker(List<Item> notFinishedItem, int oldProSum) {
        int newProSum = notFinishedItem.stream().mapToInt(Item::getProgress).sum();
        if (newProSum != oldProSum) {
            this.lastUpdateTime = System.currentTimeMillis();
        }
    }

    private void sleepNoException() {
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException e) {
            log.error("Sleep interrupted.");
        }
    }

    private boolean isFinishedOrOverTime(List<Item> items, long updateTime) {
        boolean overTime;
        boolean finish = items.stream().allMatch(Item::isFinish);
        boolean bl = overTime = System.currentTimeMillis() - updateTime > 1800000L;
        if (overTime) {
            items.stream().filter(item -> !item.isFinish()).peek(item -> item.setProgress(100)).forEach(this::updateItemUI);
            log.info("Exec timeout,exit task.");
        }
        return finish || overTime;
    }

    String startTask(List<Item> items) throws ToolException {
        HashMap<String, String[]> reqParam = new HashMap<String, String[]>();
        reqParam.put("items", this.getItemIds(items));
        reqParam.put("nodes", this.getNodeIds());
        RestConnection conn = this.getConn(this.devNode);
        ResponseInfo resp = Objects.requireNonNull(conn).execPost(RestUtil.getInspectionUri((DevNode)this.devNode), reqParam);
        this.checkIsError(resp);
        return ((JSONObject)resp.getContentMap().get("data")).getStringOrDefault("task_id", "");
    }

    public void queryProgressAndUpdate(List<Item> items) {
        List<List<Item>> queryItemBlock = this.splitTask(items);
        String uri = RestUtil.getInspectionTaskUri((DevNode)this.devNode, (String)this.taskId);
        HashMap reqParam = new HashMap();
        queryItemBlock.forEach(taskList -> this.query(uri, reqParam, (List<Item>)taskList));
    }

    private void query(String uri, Map<String, Object> reqParam, List<Item> items) {
        try {
            RestConnection conn = this.getConn(this.devNode);
            reqParam.put("items", this.getItemIds(items));
            ResponseInfo resp = conn.execPost(uri, reqParam);
            JSONArray detailArray = (JSONArray)resp.getContentMap().get("data");
            for (int i = 0; i < detailArray.length(); ++i) {
                JSONObject itemJson = (JSONObject)detailArray.get(i);
                String itemId = itemJson.getStringOrDefault("item_id", "--");
                items.stream().filter(item -> item.getId().equals(itemId) && !item.isFinish()).forEach(item -> this.updateProgressAndStatus(itemJson, (Item)item));
            }
        }
        catch (Exception e) {
            log.error("Query task status failed. {}", (Object)e.getMessage());
        }
    }

    private void updateProgressAndStatus(JSONObject itemJson, Item item) {
        int newPro;
        int oldPro = item.getProgress();
        if (oldPro < (newPro = itemJson.getInt("process"))) {
            item.setProgress(newPro);
        }
        if (!item.isFinish()) {
            return;
        }
        JSONObject nodesStatus = itemJson.getJSONObject("node_status");
        Set nodesStatusSet = nodesStatus.keySet();
        nodesStatusSet.forEach(nodeIp -> item.updateNodeStatus((String)nodeIp, nodesStatus.getInt(nodeIp)));
    }

    public boolean downloadResult(String taskId, Item item, String targetDir) throws ToolException {
        log.info("Download item result. itemId : {}", (Object)item.getId());
        RestConnection conn = this.getConn(this.devNode);
        String uri = RestUtil.getInspectionTaskUri((DevNode)this.devNode, (String)taskId);
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("item_id", item.getId());
        ResponseInfo resp = Objects.requireNonNull(conn).execGetFile(uri, reqParam, targetDir);
        this.checkIsError(resp);
        String sourceFile = (String)resp.getContentMap().get("filePath");
        if (StringUtils.isNULLStr(sourceFile)) {
            return false;
        }
        log.info(" Download resource {}", (Object)sourceFile);
        FileAssistant.deCopmressAllZipFile(targetDir, sourceFile);
        String fileName = new File(sourceFile).getName();
        String preFileName = fileName.substring(0, fileName.lastIndexOf("."));
        File targetFile = new File(targetDir + File.separator + preFileName);
        item.setDownload(targetFile.exists());
        item.setResultPath(FilePathUtils.getCanonicalPath((File)targetFile));
        if (item.isDownload()) {
            FileUtils.deleteFile(new File(sourceFile));
        }
        return item.isDownload();
    }

    void deleteTask(String taskId) {
        if (StringUtils.isNULLStr(taskId)) {
            return;
        }
        try {
            String taskUri = RestUtil.getInspectionTaskUri((DevNode)this.devNode, (String)taskId);
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)this.devNode);
            Objects.requireNonNull(conn).execDelete(taskUri, null);
        }
        catch (Exception e) {
            log.error("Delete task {} failed.", (Object)taskId);
        }
    }

    private void checkIsError(ResponseInfo resp) throws ToolException {
        Long errorCode = (Long)resp.getContentMap().get("errorCode");
        if (errorCode != null && errorCode != 0L) {
            throw new ToolException(ERROR_CODE_RES_PREFIX + errorCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadNoException(Item item) {
        try {
            boolean bl = this.downloadResult(this.taskId, item, this.resultDir);
            return bl;
        }
        catch (Exception e) {
            log.error("Download result error.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.updateItemUI(item);
        }
    }

    private void updateItemUI(Item item) {
        this.setChanged();
        this.notifyObservers(item);
    }

    private String[] getNodeIds() {
        return this.devNode.getClusterNodes().stream().filter(ClusterNode::isSelected).map(ClusterNode::getManagementIp).collect(Collectors.toList()).toArray(new String[0]);
    }

    private String[] getItemIds(List<Item> items) {
        return items.stream().map(Item::getId).collect(Collectors.toList()).toArray(new String[0]);
    }

    private List<List<Item>> splitTask(List<Item> task) {
        int blockNum = InspectTask.calcBlockNum(task.size());
        ArrayList<List<Item>> pageTaskList = new ArrayList<List<Item>>();
        Stream.iterate(0, blockIndex -> blockIndex + 1).limit(blockNum).forEach(index -> pageTaskList.add(task.stream().skip(index * 10).limit(10L).collect(Collectors.toList())));
        return pageTaskList;
    }

    private static Integer calcBlockNum(Integer size) {
        return (size + 10 - 1) / 10;
    }

    public InspectTask(DevNode devNode, DstoragePatchInfo.Type patchType, List<Item> items, String resultDir) {
        this.devNode = devNode;
        this.patchType = patchType;
        this.items = items;
        this.resultDir = resultDir;
    }

    public String getTaskId() {
        return this.taskId;
    }
}

